/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.wst.server.core.internal.ServerPlugin;

public class Trace {
    public static int CONFIG = 0;
    public static int INFO = 1;
    public static int WARNING = 2;
    public static int SEVERE = 3;
    public static int FINER = 4;
    public static int FINEST = 5;
    public static int RESOURCES = 6;
    public static int EXTENSION_POINT = 7;
    public static int LISTENERS = 8;
    public static int RUNTIME_TARGET = 9;
    public static int PERFORMANCE = 10;
    private static final String[] levelNames = new String[]{"CONFIG   ", "INFO     ", "WARNING  ", "SEVERE   ", "FINER    ", "FINEST   ", "RESOURCES", "EXTENSION", "LISTENERS", "TARGET   ", "PERF     "};
    private static final String spacer = "                                   ";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy HH:mm.ss.SSS");
    protected static int pluginLength = -1;

    private Trace() {
    }

    public static void trace(int level, String s) {
        Trace.trace(level, s, null);
    }

    public static void trace(int level, String s, Throwable t) {
        Trace.trace("org.eclipse.wst.server.core", level, s, t);
    }

    private static void trace(String pluginId, int level, String s, Throwable t) {
        if (pluginId == null || s == null) {
            return;
        }
        if (!ServerPlugin.getInstance().isDebugging()) {
            return;
        }
        StringBuffer sb = new StringBuffer(pluginId);
        if (pluginId.length() > pluginLength) {
            pluginLength = pluginId.length();
        } else if (pluginId.length() < pluginLength) {
            sb.append(spacer.substring(0, pluginLength - pluginId.length()));
        }
        sb.append(" ");
        sb.append(levelNames[level]);
        sb.append(" ");
        sb.append(sdf.format(new Date()));
        sb.append(" ");
        sb.append(s);
        System.out.println(sb.toString());
        if (t != null) {
            t.printStackTrace();
        }
    }
}

