/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.datamodel.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.ui.TimedModifyListener;

public class DataModelSynchHelper
implements IDataModelListener {
    protected static final boolean isLinux = System.getProperty("os.name").equals("Linux");
    protected IDataModel dataModel;
    protected Map widgetToPropertyHash;
    protected Map propertyToWidgetHash;
    protected Map widgetToDepControls;
    protected String currentProperty;
    protected Widget currentWidget;
    protected Widget currentWidgetFromEvent;
    protected boolean ignoreModifyEvent = false;
    private ModifyTextListener modifyTextListener;
    private TimedModifyListener timedModifyListener;
    private ComboListener comboListener;
    private CheckboxSelectionListener checkboxSelectionListener;
    private CheckBoxViewerListener checkBoxViewerStateListener;

    public DataModelSynchHelper(IDataModel model) {
        this.dataModel = model;
        this.dataModel.addListener((IDataModelListener)this);
    }

    public void propertyChanged(DataModelEvent event) {
        String propertyName = event.getPropertyName();
        int flag = event.getFlag();
        if (flag == 3) {
            this.setEnablement(propertyName, event.isPropertyEnabled());
        } else {
            this.synchUIWithModel(propertyName, flag);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setProperty(String propertyName, Object value) {
        this.currentProperty = propertyName;
        try {
            this.dataModel.setProperty(propertyName, value);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.currentProperty = null;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.currentProperty = null;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setPropertyItems(String propertyName, Object[] items) {
        this.currentProperty = propertyName;
        try {
            this.dataModel.setProperty(propertyName, (Object)items);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.currentProperty = null;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.currentProperty = null;
            return;
        }
    }

    public void synchUIWithModel(final String propertyName, final int flag) {
        if (this.propertyToWidgetHash != null && this.propertyToWidgetHash.containsKey(propertyName)) {
            Display.getDefault().syncExec(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        DataModelSynchHelper.this.currentWidget = (Widget)DataModelSynchHelper.this.propertyToWidgetHash.get(propertyName);
                        if (DataModelSynchHelper.this.currentWidget != null && DataModelSynchHelper.this.currentWidget != DataModelSynchHelper.this.currentWidgetFromEvent) {
                            Widget widget = DataModelSynchHelper.this.currentWidget;
                            try {
                                DataModelSynchHelper.this.ignoreModifyEvent = true;
                                if (DataModelSynchHelper.this.currentWidget instanceof Text) {
                                    DataModelSynchHelper.this.setWidgetValue(propertyName, flag, (Text)DataModelSynchHelper.this.currentWidget);
                                } else if (DataModelSynchHelper.this.currentWidget instanceof Combo) {
                                    DataModelSynchHelper.this.setWidgetValue(propertyName, flag, (Combo)DataModelSynchHelper.this.currentWidget);
                                } else if (DataModelSynchHelper.this.currentWidget instanceof Button) {
                                    DataModelSynchHelper.this.setWidgetValue(propertyName, flag, (Button)DataModelSynchHelper.this.currentWidget);
                                } else if (DataModelSynchHelper.this.currentWidget instanceof Label) {
                                    DataModelSynchHelper.this.setWidgetValue(propertyName, flag, (Label)DataModelSynchHelper.this.currentWidget);
                                } else if (DataModelSynchHelper.this.currentWidget instanceof org.eclipse.swt.widgets.List) {
                                    DataModelSynchHelper.this.setWidgetValue(propertyName, flag, (org.eclipse.swt.widgets.List)DataModelSynchHelper.this.currentWidget);
                                } else if (DataModelSynchHelper.this.currentWidget instanceof Table) {
                                    DataModelSynchHelper.this.setWidgetValue(propertyName, flag, (Table)DataModelSynchHelper.this.currentWidget);
                                } else if (DataModelSynchHelper.this.currentWidget instanceof Tree) {
                                    DataModelSynchHelper.this.setWidgetValue(propertyName, flag, (Tree)DataModelSynchHelper.this.currentWidget);
                                }
                                Object var2_4 = null;
                                DataModelSynchHelper.this.ignoreModifyEvent = false;
                                DataModelSynchHelper.this.setEnablement((Control)widget, DataModelSynchHelper.this.dataModel.isPropertyEnabled(propertyName));
                            }
                            catch (Throwable throwable) {
                                Object var2_3 = null;
                                DataModelSynchHelper.this.ignoreModifyEvent = false;
                                throw throwable;
                            }
                        }
                        Object var4_7 = null;
                        DataModelSynchHelper.this.currentWidget = null;
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        DataModelSynchHelper.this.currentWidget = null;
                        throw throwable;
                    }
                }
            });
        }
    }

    protected void setEnablement(Control control, boolean enabled) {
        if (control.isEnabled() != enabled) {
            control.setEnabled(enabled);
        }
        this.setDependentControlEnablement(control, enabled);
    }

    private void setEnablement(final String propertyName, final boolean enabled) {
        if (this.propertyToWidgetHash != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    Control control = (Control)DataModelSynchHelper.this.propertyToWidgetHash.get(propertyName);
                    if (control != null) {
                        DataModelSynchHelper.this.setEnablement(control, enabled);
                    }
                }
            });
        }
    }

    private void setDependentControlEnablement(Control control, boolean enabled) {
        Control[] dependents;
        if (this.widgetToDepControls != null && (dependents = (Control[])this.widgetToDepControls.get(control)) != null) {
            Control dep = null;
            int i = 0;
            while (i < dependents.length) {
                dep = dependents[i];
                if (dep.isEnabled() != enabled) {
                    dep.setEnabled(enabled);
                }
                ++i;
            }
        }
    }

    protected void setWidgetValue(String propertyName, int flag, Button button) {
        if ((button.getStyle() & 0x20) == 32 || (button.getStyle() & 0x10) == 16) {
            boolean checked = this.dataModel.getBooleanProperty(propertyName);
            if (button.getSelection() != checked) {
                button.setSelection(checked);
            }
        }
    }

    protected void setWidgetValue(String propertyName, int flag, Combo combo) {
        if (flag == 4 || combo.getItemCount() == 0) {
            DataModelPropertyDescriptor[] descriptors = this.dataModel.getValidPropertyDescriptors(propertyName);
            String[] items = new String[descriptors.length];
            int i = 0;
            while (i < descriptors.length) {
                items[i] = descriptors[i].getPropertyDescription();
                ++i;
            }
            combo.setItems(items);
        }
        String newText = this.dataModel.getPropertyDescriptor(propertyName).getPropertyDescription();
        int selIndex = combo.getSelectionIndex();
        if (selIndex < 0 || !newText.equals(combo.getItem(selIndex))) {
            String[] items = combo.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(newText)) {
                    combo.select(i);
                    return;
                }
                ++i;
            }
        }
        combo.setText(newText);
    }

    protected void setWidgetValue(String propertyName, int flag, Text text) {
        String newText = this.dataModel.getStringProperty(propertyName);
        if (!newText.equals(text.getText())) {
            text.setText(newText);
        }
    }

    protected void setWidgetValue(String propertyName, int flag, Table table) {
        Object[] elements = (Object[])this.dataModel.getProperty(propertyName);
        if (elements == null || elements.length == 0) {
            this.setTableItemsChecked(table.getItems(), false);
            return;
        }
        List<Object> elementList = Arrays.asList(elements);
        TableItem[] tableItems = table.getItems();
        int i = 0;
        while (i < tableItems.length) {
            TableItem item = tableItems[i];
            if (elementList.contains(item.getData())) {
                item.setChecked(true);
            } else {
                item.setChecked(false);
            }
            ++i;
        }
    }

    protected void setTableItemsChecked(TableItem[] tableItems, boolean b) {
        int i = 0;
        while (i < tableItems.length) {
            tableItems[i].setChecked(b);
            ++i;
        }
    }

    protected void setWidgetValue(String propertyName, int flag, Tree tree) {
        Object[] elements = (Object[])this.dataModel.getProperty(propertyName);
        if (elements == null) {
            return;
        }
        List<Object> elementList = Arrays.asList(elements);
        TreeItem[] treeItems = tree.getItems();
        if (elementList.size() == 0) {
            this.setTreeItemsGrey(treeItems, false);
            return;
        }
        if (treeItems.length > 0) {
            this.setTreeItemChecked(treeItems, elementList);
        }
    }

    public void setTreeItemsGrey(TreeItem[] treeItems, boolean b) {
        int i = 0;
        while (i < treeItems.length) {
            TreeItem item = treeItems[i];
            item.setGrayed(b);
            this.setTreeItemsGrey(treeItems[i].getItems(), b);
            ++i;
        }
    }

    protected void setTreeItemChecked(TreeItem[] treeItems, List items) {
        int i = 0;
        while (i < treeItems.length) {
            if (items.contains(treeItems[i].getData())) {
                treeItems[i].setChecked(true);
                treeItems[i].setGrayed(false);
            } else {
                treeItems[i].setGrayed(true);
            }
            TreeItem[] childernItems = treeItems[i].getItems();
            if (childernItems.length > 0) {
                treeItems[i].setExpanded(true);
                this.setTreeItemChecked(childernItems, items);
            }
            ++i;
        }
    }

    protected void setWidgetValue(String propertyName, int flag, Label label) {
        String newText = this.dataModel.getStringProperty(propertyName);
        if (!newText.equals(label.getText())) {
            label.setText(newText);
        }
    }

    protected void setWidgetValue(String propertyName, int flag, org.eclipse.swt.widgets.List list) {
        Object newContents = this.dataModel.getProperty(propertyName);
        if (newContents == null) {
            list.setItems(new String[0]);
            return;
        }
        if (newContents instanceof List) {
            List modelContents = (List)newContents;
            String[] items = new String[modelContents.size()];
            int i = 0;
            while (i < modelContents.size()) {
                items[i] = modelContents.get(i).toString();
                ++i;
            }
            list.setItems(items);
        } else if (newContents instanceof String[]) {
            list.setItems((String[])newContents);
        }
    }

    public void synchAllUIWithModel() {
        Set keys;
        if (this.propertyToWidgetHash != null && !(keys = this.propertyToWidgetHash.keySet()).isEmpty()) {
            Iterator propertyNames = keys.iterator();
            String propertyName = null;
            while (propertyNames.hasNext()) {
                propertyName = (String)propertyNames.next();
                this.synchUIWithModel(propertyName, 1);
            }
        }
    }

    protected void synchComposite(Widget widget, String propertyName, Control[] depControls) {
        if (this.widgetToPropertyHash == null) {
            this.widgetToPropertyHash = new HashMap();
        }
        if (this.propertyToWidgetHash == null) {
            this.propertyToWidgetHash = new HashMap();
        }
        this.widgetToPropertyHash.put(widget, propertyName);
        this.propertyToWidgetHash.put(propertyName, widget);
        if (depControls != null) {
            if (this.widgetToDepControls == null) {
                this.widgetToDepControls = new HashMap();
            }
            this.widgetToDepControls.put(widget, depControls);
        }
        this.synchUIWithModel(propertyName, 1);
    }

    public void synchText(Text text, String propertyName, Control[] dependentControls) {
        this.synchText(text, propertyName, false, dependentControls);
    }

    public void synchText(Text text, String propertyName, boolean isTimeModified, Control[] dependentControls) {
        this.synchComposite((Widget)text, propertyName, dependentControls);
        if (isTimeModified) {
            text.addModifyListener((ModifyListener)this.getTimedListener());
        } else {
            text.addModifyListener((ModifyListener)this.getModifyTextListener());
        }
    }

    public void synchLabel(Label label, String propertyName, Control[] dependentControls) {
        this.synchComposite((Widget)label, propertyName, dependentControls);
    }

    public void synchList(org.eclipse.swt.widgets.List list, String propertyName, Control[] dependentControls) {
        this.synchComposite((Widget)list, propertyName, dependentControls);
    }

    public void synchCombo(Combo combo, String propertyName, Control[] dependentControls) {
        this.synchComposite((Widget)combo, propertyName, dependentControls);
        if (this.comboListener == null) {
            this.comboListener = new ComboListener();
        }
        combo.addSelectionListener((SelectionListener)this.comboListener);
        combo.addModifyListener((ModifyListener)this.comboListener);
    }

    public void synchCheckbox(Button checkbox, String propertyName, Control[] dependentControls) {
        this.synchComposite((Widget)checkbox, propertyName, dependentControls);
        if (this.checkboxSelectionListener == null) {
            this.checkboxSelectionListener = new CheckboxSelectionListener();
        }
        checkbox.addSelectionListener((SelectionListener)this.checkboxSelectionListener);
    }

    public void synchCheckBoxTableViewer(CheckboxTableViewer tableViewer, String propertyName, Control[] dependentControls) {
        this.synchComposite((Widget)tableViewer.getControl(), propertyName, dependentControls);
        if (this.checkBoxViewerStateListener == null) {
            this.checkBoxViewerStateListener = new CheckBoxViewerListener();
        }
        tableViewer.addCheckStateListener((ICheckStateListener)this.checkBoxViewerStateListener);
    }

    public void synchCheckBoxTreeViewer(CheckboxTreeViewer treeViewer, String propertyName, Control[] dependentControls) {
        treeViewer.expandAll();
        this.synchComposite((Widget)treeViewer.getControl(), propertyName, dependentControls);
        if (this.checkBoxViewerStateListener == null) {
            this.checkBoxViewerStateListener = new CheckBoxViewerListener();
        }
        treeViewer.addCheckStateListener((ICheckStateListener)this.checkBoxViewerStateListener);
    }

    public void synchRadio(Button radio, String propertyName, Control[] dependentControls) {
        this.synchCheckbox(radio, propertyName, dependentControls);
    }

    private TimedModifyListener getTimedListener() {
        if (this.timedModifyListener == null) {
            this.timedModifyListener = new TimedModifyListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Widget w = (Widget)e.getSource();
                    if (DataModelSynchHelper.this.currentWidget == w || w.isDisposed()) {
                        return;
                    }
                    String propertyName = (String)DataModelSynchHelper.this.widgetToPropertyHash.get(w);
                    DataModelSynchHelper.this.setTextProperty(propertyName, (Text)w);
                }
            }){

                public void modifyText(ModifyEvent e) {
                    if (DataModelSynchHelper.this.ignoreModifyEvent) {
                        return;
                    }
                    super.modifyText(e);
                }
            };
        }
        return this.timedModifyListener;
    }

    protected void setTextProperty(String propertyName, Text text) {
        this.setProperty(propertyName, text.getText());
    }

    private ModifyTextListener getModifyTextListener() {
        if (this.modifyTextListener == null) {
            this.modifyTextListener = new ModifyTextListener();
        }
        return this.modifyTextListener;
    }

    public IDataModel getDataModel() {
        return this.dataModel;
    }

    public void dispose() {
        this.dataModel.removeListener((IDataModelListener)this);
        this.checkboxSelectionListener = null;
        this.currentWidget = null;
        this.modifyTextListener = null;
        this.propertyToWidgetHash = null;
        this.timedModifyListener = null;
        this.widgetToDepControls = null;
        this.widgetToPropertyHash = null;
    }

    private class CheckBoxViewerListener
    implements ICheckStateListener {
        private CheckBoxViewerListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            StructuredViewer viewer = (StructuredViewer)event.getSource();
            Object[] items = null;
            if (viewer instanceof CheckboxTableViewer) {
                CheckboxTableViewer checkBoxTableViewer = (CheckboxTableViewer)viewer;
                items = checkBoxTableViewer.getCheckedElements();
            } else if (viewer instanceof CheckboxTreeViewer) {
                CheckboxTreeViewer checkBoxTreeViewer = (CheckboxTreeViewer)viewer;
                items = checkBoxTreeViewer.getCheckedElements();
            }
            String propertyName = (String)DataModelSynchHelper.this.widgetToPropertyHash.get(viewer.getControl());
            DataModelSynchHelper.this.setPropertyItems(propertyName, items);
        }
    }

    private class CheckboxSelectionListener
    implements SelectionListener {
        private CheckboxSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.getSource();
            if (DataModelSynchHelper.this.currentWidget == button) {
                return;
            }
            String propertyName = (String)DataModelSynchHelper.this.widgetToPropertyHash.get(button);
            DataModelSynchHelper.this.setProperty(propertyName, new Boolean(button.getSelection()));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class ComboListener
    implements SelectionListener,
    ModifyListener {
        private ComboListener() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void modifyText(ModifyEvent e) {
            if (DataModelSynchHelper.this.ignoreModifyEvent) {
                return;
            }
            combo = (Combo)e.getSource();
            if (DataModelSynchHelper.this.currentWidget == combo) {
                return;
            }
            try {
                DataModelSynchHelper.this.currentWidgetFromEvent = combo;
                propertyName = (String)DataModelSynchHelper.this.widgetToPropertyHash.get(combo);
                descriptors = DataModelSynchHelper.this.dataModel.getValidPropertyDescriptors(propertyName);
                description = combo.getText();
                if (DataModelSynchHelper.isLinux && description.length() == 0 && descriptors.length != 0 && !(descriptors[0].getPropertyValue() instanceof String)) {
lbl13:
                    // 2 sources

                    while (true) {
                        var7_6 = null;
                        DataModelSynchHelper.this.currentWidgetFromEvent = null;
                        return;
                    }
                }
                i = 0;
                while (true) {
                    block9: {
                        if (i < descriptors.length) break block9;
                        DataModelSynchHelper.this.setProperty(propertyName, combo.getText());
                        break;
                    }
                    if (description.equals(descriptors[i].getPropertyDescription())) {
                        DataModelSynchHelper.this.setProperty(propertyName, descriptors[i].getPropertyValue());
                        ** continue;
                    }
                    ++i;
                }
            }
            catch (Throwable var8_10) {
                var7_7 = null;
                DataModelSynchHelper.this.currentWidgetFromEvent = null;
                throw var8_10;
            }
            {
                var7_8 = null;
                DataModelSynchHelper.this.currentWidgetFromEvent = null;
                return;
            }
        }

        public void widgetSelected(SelectionEvent e) {
            Combo combo = (Combo)e.getSource();
            if (DataModelSynchHelper.this.currentWidget == combo) {
                return;
            }
            String propertyName = (String)DataModelSynchHelper.this.widgetToPropertyHash.get(combo);
            if (combo.getSelectionIndex() >= 0) {
                DataModelPropertyDescriptor[] descriptors = DataModelSynchHelper.this.dataModel.getValidPropertyDescriptors(propertyName);
                String description = combo.getItem(combo.getSelectionIndex());
                int i = 0;
                while (i < descriptors.length) {
                    if (description.equals(descriptors[i].getPropertyDescription())) {
                        DataModelSynchHelper.this.setProperty(propertyName, descriptors[i].getPropertyValue());
                        return;
                    }
                    ++i;
                }
                DataModelSynchHelper.this.setProperty(propertyName, combo.getItem(combo.getSelectionIndex()));
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class ModifyTextListener
    implements ModifyListener {
        private ModifyTextListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (DataModelSynchHelper.this.ignoreModifyEvent) {
                return;
            }
            Text text = (Text)e.getSource();
            if (DataModelSynchHelper.this.currentWidget == text) {
                return;
            }
            String propertyName = (String)DataModelSynchHelper.this.widgetToPropertyHash.get(text);
            DataModelSynchHelper.this.setProperty(propertyName, text.getText());
        }
    }
}

