/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.data.internal.ui.load;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.wst.rdb.data.internal.core.common.Output;
import org.eclipse.wst.rdb.data.internal.core.load.LoadData;
import org.eclipse.wst.rdb.data.internal.ui.OutputItemAdapter;
import org.eclipse.wst.rdb.data.internal.ui.load.LoadDataWizardPage;
import org.eclipse.wst.rdb.data.internal.ui.load.Messages;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.internal.outputview.OutputItem;
import org.eclipse.wst.rdb.internal.outputview.OutputViewAPI;

public class LoadDataWizard
extends Wizard {
    protected Table table;
    protected LoadDataWizardPage page;

    public LoadDataWizard(Table table) {
        this.table = table;
        this.setWindowTitle(Messages.getString("LoadDataWizard.LoadData"));
    }

    public void addPages() {
        this.page = new LoadDataWizardPage("org.eclipse.wst.rdb.data.ui.loadData");
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.page.saveSettings();
        String colDelim = this.page.getColumnDelimiter();
        String stringDelim = this.page.getStringDelimiter();
        String filePath = this.page.getFilePath();
        boolean replace = this.page.getReplace();
        final LoadData load = new LoadData(this.table, filePath);
        load.setDelims(colDelim, stringDelim);
        load.setReplace(replace);
        final OutputItem item = this.initDbOutputItem();
        Job job = new Job(Messages.getString("LoadDataWizard.DataLoading")){

            protected IStatus run(IProgressMonitor monitor) {
                int ret = load.doLoad((Output)new OutputItemAdapter(item));
                OutputViewAPI.getInstance().updateStatus(item, ret, true);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
        return true;
    }

    protected void showReport() {
    }

    protected OutputItem initDbOutputItem() {
        OutputItem item = OutputViewAPI.getInstance().findOutputItem(this.getFullyQualifiedName(), 38, true);
        if (item == null) {
            item = new OutputItem(5, 44, this.table.getName(), this.getFullyQualifiedName());
            OutputViewAPI.getInstance().addOutputItem(item, true);
        } else {
            OutputViewAPI.getInstance().resetOutputItem(item, true);
            OutputViewAPI.getInstance().updateStatus(item, 5, true);
        }
        return item;
    }

    protected String getFullyQualifiedName() {
        return "\"" + this.table.getSchema().getName() + "\".\"" + this.table.getName() + "\"";
    }
}

