/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.refactor.listeners;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class J2EEElementChangedListener
implements IElementChangedListener {
    public static final String PROJECT_COMPONENT_UPDATE_JOB_FAMILY = "org.eclipse.jst.j2ee.refactor.component";

    public void elementChanged(ElementChangedEvent event) {
        this.processJavaElementDelta(event.getDelta());
    }

    private void processJavaElementDelta(IJavaElementDelta delta) {
        block3: {
            IJavaProject jproject;
            IProject project;
            IJavaElement element;
            int flags;
            block4: {
                int kind = delta.getKind();
                if (kind != 4) break block3;
                flags = delta.getFlags();
                element = delta.getElement();
                if ((flags & 8) != 8) break block3;
                if (!(element instanceof IJavaModel)) break block4;
                IJavaElementDelta[] children = delta.getChangedChildren();
                int i = 0;
                while (i < children.length) {
                    this.processJavaElementDelta(children[i]);
                    ++i;
                }
                break block3;
            }
            if (!(element instanceof IJavaProject) || (flags & 0x20000) == 0 || ModuleCoreNature.getModuleCoreNature((IProject)(project = (jproject = (IJavaProject)element).getProject())) == null) break block3;
            try {
                this.alterMapping(delta.getAffectedChildren(), jproject, project);
            }
            catch (CoreException ce) {
                Logger.getLogger().logError((Throwable)ce);
            }
        }
    }

    private void alterMapping(IJavaElementDelta[] children, IJavaProject jproject, final IProject project) throws CoreException {
        ArrayList<IPath> pathsToAdd = null;
        ArrayList<IPath> pathsToRemove = null;
        int i = 0;
        while (i < children.length) {
            IJavaElementDelta delta = children[i];
            IJavaElement element = delta.getElement();
            if (element.getElementType() == 3) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                int cpeKind = 1;
                boolean abortAdd = false;
                try {
                    cpeKind = root.getKind();
                }
                catch (JavaModelException javaModelException) {
                    abortAdd = true;
                }
                if (cpeKind == 1) {
                    IPath path;
                    int flags = delta.getFlags();
                    if (delta.getKind() == 1 || (flags & 0x40) == 64) {
                        if (!abortAdd) {
                            if (pathsToAdd == null) {
                                pathsToAdd = new ArrayList<IPath>();
                            }
                            path = root.getPath().removeFirstSegments(1);
                            pathsToAdd.add(path);
                            if ((flags & 0x10) == 16) {
                                IJavaElement movedFromElement = delta.getMovedFromElement();
                                if (pathsToRemove == null) {
                                    pathsToRemove = new ArrayList();
                                }
                                pathsToRemove.add(movedFromElement.getPath().removeFirstSegments(1));
                            }
                        }
                    } else if ((flags & 0x80) == 128) {
                        if (pathsToRemove == null) {
                            pathsToRemove = new ArrayList<IPath>();
                        }
                        path = root.getPath().removeFirstSegments(1);
                        pathsToRemove.add(path);
                    }
                }
            }
            ++i;
        }
        if (pathsToAdd != null || pathsToRemove != null) {
            final ArrayList<IPath> jobPathsToAdd = pathsToAdd;
            final ArrayList<IPath> jobPathsToRemove = pathsToRemove;
            WorkspaceJob job = new WorkspaceJob("J2EEComponentMappingUpdateJob"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    int i;
                    IVirtualFolder destFolder = J2EEElementChangedListener.this.getDestinationFolder(project);
                    IPath path = null;
                    if (jobPathsToAdd != null) {
                        i = 0;
                        while (i < jobPathsToAdd.size()) {
                            path = (IPath)jobPathsToAdd.get(i);
                            destFolder.createLink(path, 0, monitor);
                            ++i;
                        }
                    }
                    if (jobPathsToRemove != null) {
                        i = 0;
                        while (i < jobPathsToRemove.size()) {
                            path = (IPath)jobPathsToRemove.get(i);
                            destFolder.removeLink(path, 0, monitor);
                            ++i;
                        }
                    }
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return J2EEElementChangedListener.PROJECT_COMPONENT_UPDATE_JOB_FAMILY.equals(family);
                }
            };
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            job.schedule();
        }
    }

    private IVirtualFolder getDestinationFolder(IProject project) throws CoreException {
        IVirtualComponent c = ComponentCore.createComponent((IProject)project);
        c.create(0, null);
        IVirtualFolder root = c.getRootFolder();
        if (J2EEProjectUtilities.isDynamicWebProject(project)) {
            return root.getFolder((IPath)new Path("WEB-INF/classes"));
        }
        return root;
    }
}

