/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.preferences;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.themes.ITheme;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.decorator.SVNDecoratorConfiguration;
import org.tigris.subversion.subclipse.ui.decorator.SVNLightweightDecorator;
import org.tigris.subversion.subclipse.ui.internal.SWTUtils;
import org.tigris.subversion.subclipse.ui.preferences.OverlayIcon;

public class SVNDecoratorPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button imageShowDirty;
    private Button imageShowHasRemote;
    private Button imageShowAdded;
    private Button imageShowNewResource;
    private Button imageShowExternal;
    private Text fileTextFormat;
    private Text folderTextFormat;
    private Text projectTextFormat;
    private Text dirtyFlag;
    private Text addedFlag;
    private Text externalFlag;
    private Button showDirty;
    private Button enableFontDecorators;
    protected static final Collection ROOT;
    private static ImageDescriptor newResource;
    private static ImageDescriptor dirty;
    private static ImageDescriptor added;
    private static ImageDescriptor checkedIn;
    private static ImageDescriptor external;
    private static ThemeListener fThemeListener;
    private Preview fPreview;

    static {
        PreviewFile project = new PreviewFile("Project", 4, false, false, false, false, true, false, null, "v1_0");
        ArrayList<PreviewFile> children = new ArrayList<PreviewFile>();
        children.add(new PreviewFile("Folder", 2, false, false, false, false, true, false, null, null));
        children.add(new PreviewFile("External Folder", 2, false, false, false, false, true, true, null, null));
        children.add(new PreviewFile("ignored.txt", 1, false, false, false, true, false, false, null, null));
        children.add(new PreviewFile("dirty.cpp", 1, false, false, true, false, true, false, null, null));
        children.add(new PreviewFile("added.java", 1, true, false, true, false, false, false, null, null));
        children.add(new PreviewFile("todo.txt", 1, false, true, false, false, false, false, null, null));
        children.add(new PreviewFile("bugs.txt", 1, false, false, true, false, true, false, null, null));
        children.add(new PreviewFile("archive.zip", 1, false, false, true, false, true, false, null, null));
        project.children = children;
        ROOT = Collections.singleton(project);
        dirty = new SVNLightweightDecorator.CachedImageDescriptor(TeamImages.getImageDescriptor((String)"ovr/dirty_ov.gif"));
        checkedIn = new SVNLightweightDecorator.CachedImageDescriptor(TeamImages.getImageDescriptor((String)"ovr/version_controlled.gif"));
        added = new SVNLightweightDecorator.CachedImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("ovr16/added_ov.gif"));
        newResource = new SVNLightweightDecorator.CachedImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("ovr16/question_ov.gif"));
        external = new SVNLightweightDecorator.CachedImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("ovr16/external_ov.gif"));
    }

    public SVNDecoratorPreferencesPage() {
        this.setDescription(Policy.bind("SVNDecoratorPreferencesPage.description"));
    }

    private Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 32);
        button.setText(label);
        return button;
    }

    private Control createGeneralDecoratorPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        SWTUtils.createPreferenceLink((IWorkbenchPreferenceContainer)this.getContainer(), composite, "org.eclipse.ui.preferencePages.Decorators", Policy.bind("SVNDecoratorPreferencesPage.labelDecorationsLink"));
        this.showDirty = this.createCheckBox(composite, Policy.bind("SVNDecoratorPreferencesPage.computeDeep"));
        this.enableFontDecorators = this.createCheckBox(composite, Policy.bind("SVNDecoratorPreferencesPage.useFontDecorators"));
        SWTUtils.createPreferenceLink((IWorkbenchPreferenceContainer)this.getContainer(), composite, "org.eclipse.ui.preferencePages.ColorsAndFonts", Policy.bind("SVNDecoratorPreferencesPage.colorsAndFontsLink"));
        return composite;
    }

    protected TextPair createFormatEditorControl(Composite composite, String title, String buttonText, final Map supportedBindings) {
        this.createLabel(composite, title, 1);
        Text format = new Text(composite, 2048);
        format.setLayoutData((Object)new GridData(768));
        format.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNDecoratorPreferencesPage.this.updateExamples();
            }
        });
        Button b = new Button(composite, 0);
        b.setText(buttonText);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, b.computeSize((int)-1, (int)-1, (boolean)true).x);
        b.setLayoutData((Object)data);
        final Text formatToInsert = format;
        b.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNDecoratorPreferencesPage.this.addVariables(formatToInsert, supportedBindings);
            }
        });
        return new TextPair(format, null);
    }

    protected void updateExamples() {
        if (this.fPreview != null) {
            this.fPreview.refresh();
        }
    }

    protected Control createContents(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Policy.bind("SVNDecoratorPreferencesPage.generalTabFolder"));
        tabItem.setControl(this.createGeneralDecoratorPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Policy.bind("SVNDecoratorPreferencesPage.textLabel"));
        tabItem.setControl(this.createTextDecoratorPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Policy.bind("Icon_Overlays_24"));
        tabItem.setControl(this.createIconDecoratorPage((Composite)tabFolder));
        this.initializeValues();
        this.fPreview = new Preview(parent);
        this.fPreview.setColorsAndFonts();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.tigris.subversion.subclipse.ui.decorators_preference_page_context");
        fThemeListener = new ThemeListener(this.fPreview);
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener((IPropertyChangeListener)fThemeListener);
        Dialog.applyDialogFont((Control)parent);
        return tabFolder;
    }

    private Control createTextDecoratorPage(Composite parent) {
        Composite fileTextGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        fileTextGroup.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        fileTextGroup.setLayoutData((Object)data);
        this.createLabel(fileTextGroup, Policy.bind("SVNDecoratorPreferencesPage.selectFormats"), 3);
        TextPair format = this.createFormatEditorControl(fileTextGroup, Policy.bind("SVNDecoratorPreferencesPage.fileFormat"), Policy.bind("SVNDecoratorPreferencesPage.addVariables"), this.getFileBindingDescriptions());
        this.fileTextFormat = format.t1;
        format = this.createFormatEditorControl(fileTextGroup, Policy.bind("SVNDecoratorPreferencesPage.folderFormat"), Policy.bind("SVNDecoratorPreferencesPage.addVariables"), this.getFolderBindingDescriptions());
        this.folderTextFormat = format.t1;
        format = this.createFormatEditorControl(fileTextGroup, Policy.bind("SVNDecoratorPreferencesPage.projectFormat"), Policy.bind("SVNDecoratorPreferencesPage.addVariables"), this.getProjectBindingDescriptions());
        this.projectTextFormat = format.t1;
        this.createLabel(fileTextGroup, Policy.bind("SVNDecoratorPreferencesPage.labelDecorationOutgoing"), 1);
        this.dirtyFlag = new Text(fileTextGroup, 2048);
        this.dirtyFlag.setLayoutData((Object)new GridData(768));
        this.dirtyFlag.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNDecoratorPreferencesPage.this.updateExamples();
            }
        });
        this.createLabel(fileTextGroup, "", 1);
        this.createLabel(fileTextGroup, Policy.bind("SVNDecoratorPreferencesPage.labelDecorationAdded"), 1);
        this.addedFlag = new Text(fileTextGroup, 2048);
        this.addedFlag.setLayoutData((Object)new GridData(768));
        this.addedFlag.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNDecoratorPreferencesPage.this.updateExamples();
            }
        });
        this.createLabel(fileTextGroup, "", 1);
        this.createLabel(fileTextGroup, Policy.bind("SVNDecoratorPreferencesPage.labelDecorationExternal"), 1);
        this.externalFlag = new Text(fileTextGroup, 2048);
        this.externalFlag.setLayoutData((Object)new GridData(768));
        this.externalFlag.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNDecoratorPreferencesPage.this.updateExamples();
            }
        });
        return fileTextGroup;
    }

    private Control createIconDecoratorPage(Composite parent) {
        Composite imageGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        imageGroup.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        imageGroup.setLayoutData((Object)data);
        this.imageShowDirty = this.createCheckBox(imageGroup, Policy.bind("Sho&w_outgoing_25"));
        this.imageShowHasRemote = this.createCheckBox(imageGroup, Policy.bind("Show_has_&remote_26"));
        this.imageShowAdded = this.createCheckBox(imageGroup, Policy.bind("S&how_is_added_27"));
        this.imageShowNewResource = this.createCheckBox(imageGroup, Policy.bind("SVNDecoratorPreferencesPage.newResources"));
        this.imageShowExternal = this.createCheckBox(imageGroup, Policy.bind("SVNDecoratorPreferencesPage.externalResources"));
        return imageGroup;
    }

    private Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fileTextFormat.setText(store.getString("pref_filetext_decoration"));
        this.folderTextFormat.setText(store.getString("pref_foldertext_decoration"));
        this.projectTextFormat.setText(store.getString("pref_projecttext_decoration"));
        this.addedFlag.setText(store.getString("pref_added_flag"));
        this.dirtyFlag.setText(store.getString("pref_dirty_flag"));
        this.externalFlag.setText(store.getString("pref_external_flag"));
        this.imageShowDirty.setSelection(store.getBoolean("pref_show_overlaydirty"));
        this.imageShowAdded.setSelection(store.getBoolean("pref_show_added"));
        this.imageShowHasRemote.setSelection(store.getBoolean("pref_show_hasremote"));
        this.imageShowNewResource.setSelection(store.getBoolean("pref_show_newresource"));
        this.imageShowExternal.setSelection(store.getBoolean("pref_show_external"));
        this.showDirty.setSelection(store.getBoolean("pref_calculate_dirty"));
        this.enableFontDecorators.setSelection(store.getBoolean("pref_use_font_decorators"));
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNDecoratorPreferencesPage.this.fPreview.refresh();
            }
        };
        this.enableFontDecorators.addSelectionListener((SelectionListener)selectionListener);
        this.imageShowDirty.addSelectionListener((SelectionListener)selectionListener);
        this.imageShowAdded.addSelectionListener((SelectionListener)selectionListener);
        this.imageShowHasRemote.addSelectionListener((SelectionListener)selectionListener);
        this.imageShowNewResource.addSelectionListener((SelectionListener)selectionListener);
        this.imageShowExternal.addSelectionListener((SelectionListener)selectionListener);
        this.setValid(true);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("pref_filetext_decoration", this.fileTextFormat.getText());
        store.setValue("pref_foldertext_decoration", this.folderTextFormat.getText());
        store.setValue("pref_projecttext_decoration", this.projectTextFormat.getText());
        store.setValue("pref_added_flag", this.addedFlag.getText());
        store.setValue("pref_dirty_flag", this.dirtyFlag.getText());
        store.setValue("pref_external_flag", this.externalFlag.getText());
        store.setValue("pref_show_overlaydirty", this.imageShowDirty.getSelection());
        store.setValue("pref_show_added", this.imageShowAdded.getSelection());
        store.setValue("pref_show_hasremote", this.imageShowHasRemote.getSelection());
        store.setValue("pref_show_newresource", this.imageShowNewResource.getSelection());
        store.setValue("pref_show_external", this.imageShowExternal.getSelection());
        store.setValue("pref_calculate_dirty", this.showDirty.getSelection());
        store.setValue("pref_use_font_decorators", this.enableFontDecorators.getSelection());
        SVNProviderPlugin.getPlugin().getPluginPreferences().setValue("resursive_status_update", this.showDirty.getSelection());
        SVNProviderPlugin.getPlugin().savePluginPreferences();
        SVNLightweightDecorator.refresh();
        SVNUIPlugin.getPlugin().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore store = this.getPreferenceStore();
        this.fileTextFormat.setText(store.getDefaultString("pref_filetext_decoration"));
        this.folderTextFormat.setText(store.getDefaultString("pref_foldertext_decoration"));
        this.projectTextFormat.setText(store.getDefaultString("pref_projecttext_decoration"));
        this.addedFlag.setText(store.getDefaultString("pref_added_flag"));
        this.dirtyFlag.setText(store.getDefaultString("pref_dirty_flag"));
        this.externalFlag.setText(store.getDefaultString("pref_external_flag"));
        this.imageShowDirty.setSelection(store.getDefaultBoolean("pref_show_overlaydirty"));
        this.imageShowAdded.setSelection(store.getDefaultBoolean("pref_show_added"));
        this.imageShowHasRemote.setSelection(store.getDefaultBoolean("pref_show_hasremote"));
        this.imageShowNewResource.setSelection(store.getDefaultBoolean("pref_show_newresource"));
        this.imageShowExternal.setSelection(store.getDefaultBoolean("pref_show_external"));
        this.showDirty.setSelection(store.getDefaultBoolean("pref_calculate_dirty"));
        this.enableFontDecorators.setSelection(store.getDefaultBoolean("pref_use_font_decorators"));
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return SVNUIPlugin.getPlugin().getPreferenceStore();
    }

    public void dispose() {
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener((IPropertyChangeListener)fThemeListener);
        super.dispose();
    }

    private void addVariables(Text target, Map bindings) {
        final ArrayList<StringPair> variables = new ArrayList<StringPair>(bindings.size());
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return String.valueOf(((StringPair)element).s1) + " - " + ((StringPair)element).s2;
            }
        };
        IStructuredContentProvider contentsProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return variables.toArray(new StringPair[variables.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        Iterator it = bindings.keySet().iterator();
        while (it.hasNext()) {
            StringPair variable = new StringPair();
            variable.s1 = (String)it.next();
            variable.s2 = (String)bindings.get(variable.s1);
            variables.add(variable);
        }
        ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), (Object)this, contentsProvider, (ILabelProvider)labelProvider, Policy.bind("SVNDecoratorPreferencesPage.selectVariablesToAdd"));
        dialog.setTitle(Policy.bind("SVNDecoratorPreferencesPage.AddVariables"));
        if (dialog.open() != 0) {
            return;
        }
        Object[] result = dialog.getResult();
        int i = 0;
        while (i < result.length) {
            target.insert("{" + ((StringPair)result[i]).s1 + "}");
            ++i;
        }
    }

    private Map getFolderBindingDescriptions() {
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put("name", Policy.bind("SVNDecoratorPreferencesPage.nameResourceVariable"));
        bindings.put("revision", Policy.bind("SVNDecoratorPreferencesPage.revisionResourceVariable"));
        bindings.put("dirty_flag", Policy.bind("SVNDecoratorPreferencesPage.flagDirtyVariable"));
        bindings.put("added_flag", Policy.bind("SVNDecoratorPreferencesPage.flagAddedVariable"));
        bindings.put("external_flag", Policy.bind("SVNDecoratorPreferencesPage.flagExternalVariable"));
        bindings.put("author", Policy.bind("SVNDecoratorPreferencesPage.authorVariable"));
        bindings.put("date", Policy.bind("SVNDecoratorPreferencesPage.dateVariable"));
        return bindings;
    }

    private Map getFileBindingDescriptions() {
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put("name", Policy.bind("SVNDecoratorPreferencesPage.nameResourceVariable"));
        bindings.put("revision", Policy.bind("SVNDecoratorPreferencesPage.revisionResourceVariable"));
        bindings.put("dirty_flag", Policy.bind("SVNDecoratorPreferencesPage.flagDirtyVariable"));
        bindings.put("added_flag", Policy.bind("SVNDecoratorPreferencesPage.flagAddedVariable"));
        bindings.put("author", Policy.bind("SVNDecoratorPreferencesPage.authorVariable"));
        bindings.put("date", Policy.bind("SVNDecoratorPreferencesPage.dateVariable"));
        return bindings;
    }

    private Map getProjectBindingDescriptions() {
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put("name", Policy.bind("SVNDecoratorPreferencesPage.nameResourceVariable"));
        bindings.put("dirty_flag", Policy.bind("SVNDecoratorPreferencesPage.flagDirtyVariable"));
        bindings.put("url", Policy.bind("SVNDecoratorPreferencesPage.remoteLocationVariable"));
        bindings.put("url_short", Policy.bind("SVNDecoratorPreferencesPage.remoteLocationVariableShort"));
        bindings.put("label", Policy.bind("SVNDecoratorPreferencesPage.remoteLocationLabel"));
        bindings.put("revision", Policy.bind("SVNDecoratorPreferencesPage.revisionResourceVariable"));
        return bindings;
    }

    class StringPair {
        String s1;
        String s2;

        StringPair() {
        }
    }

    class TextPair {
        Text t1;
        Text t2;

        TextPair(Text t1, Text t2) {
            this.t1 = t1;
            this.t2 = t2;
        }
    }

    private static class PreviewFile {
        public final String name;
        public final int type;
        public final boolean added;
        public final boolean dirty;
        public final boolean hasRemote;
        public final boolean ignored;
        public final boolean newResource;
        public final boolean external;
        public Collection children;

        public PreviewFile(String name, int type, boolean added, boolean newResource, boolean dirty, boolean ignored, boolean hasRemote, boolean external, String mode, String tag) {
            this.name = name;
            this.type = type;
            this.added = added;
            this.ignored = ignored;
            this.dirty = dirty;
            this.hasRemote = hasRemote;
            this.newResource = newResource;
            this.external = external;
            this.children = Collections.EMPTY_LIST;
        }
    }

    public class Preview
    extends LabelProvider
    implements Observer,
    ITreeContentProvider {
        private final ResourceManager fImageCache;
        private final TreeViewer fViewer;

        public Preview(Composite composite) {
            SWTUtils.createLabel(composite, Policy.bind("SVNDecoratorPreferencesPage.preview"));
            this.fImageCache = new LocalResourceManager(JFaceResources.getResources());
            this.fViewer = new TreeViewer(composite);
            GridData data = SWTUtils.createHVFillGridData();
            data.heightHint = 150;
            this.fViewer.getControl().setLayoutData((Object)data);
            this.fViewer.setContentProvider((IContentProvider)this);
            this.fViewer.setLabelProvider((IBaseLabelProvider)this);
            this.fViewer.setInput((Object)ROOT);
            this.fViewer.expandAll();
        }

        public void refresh() {
            this.fViewer.refresh(true);
            this.setColorsAndFonts();
        }

        public void setColorsAndFonts() {
            TreeItem[] items = this.fViewer.getTree().getItems();
            this.setColorsAndFonts(items);
        }

        private void setColorsAndFonts(TreeItem[] items) {
            int i = 0;
            while (i < items.length) {
                if (SVNDecoratorPreferencesPage.this.enableFontDecorators.getSelection()) {
                    Color backGroundColor = this.getBackground(items[i].getData());
                    items[i].setBackground(backGroundColor);
                    Color foreGroundColor = this.getForeground(items[i].getData());
                    items[i].setForeground(foreGroundColor);
                    Font font = this.getFont(items[i].getData());
                    items[i].setFont(font);
                } else {
                    items[i].setBackground(null);
                    items[i].setForeground(null);
                    items[i].setFont(null);
                }
                this.setColorsAndFonts(items[i].getItems());
                ++i;
            }
        }

        public void update(Observable o, Object arg) {
            this.refresh();
        }

        public Object[] getChildren(Object parentElement) {
            return ((PreviewFile)parentElement).children.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return !((PreviewFile)element).children.isEmpty();
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }

        public void dispose() {
            this.fImageCache.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Color getBackground(Object element) {
            ITheme current = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
            if (((PreviewFile)element).ignored) {
                return current.getColorRegistry().get("svn_ignored_resource_background_color");
            }
            if (((PreviewFile)element).dirty) {
                return current.getColorRegistry().get("svn_outgoing_change_background_color");
            }
            return null;
        }

        public Color getForeground(Object element) {
            ITheme current = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
            if (((PreviewFile)element).ignored) {
                return current.getColorRegistry().get("svn_ignored_resource_foreground_color");
            }
            if (((PreviewFile)element).dirty) {
                return current.getColorRegistry().get("svn_outgoing_change_foreground_color");
            }
            return null;
        }

        public Font getFont(Object element) {
            ITheme current = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
            if (((PreviewFile)element).ignored) {
                return current.getFontRegistry().get("svn_ignored_resource_font");
            }
            if (((PreviewFile)element).dirty) {
                return current.getFontRegistry().get("svn_outgoing_change_font");
            }
            return null;
        }

        public String getText(Object element) {
            PreviewFile previewFile = (PreviewFile)element;
            HashMap<String, String> bindings = new HashMap<String, String>();
            bindings.put("revision", "74");
            bindings.put("author", "cchab");
            bindings.put("date", DateFormat.getInstance().format(new Date()));
            bindings.put("url", "http://localhost:8080/svn/repos/trunk/project1");
            bindings.put("url_short", "trunk/project1");
            bindings.put("label", "label");
            if (previewFile.dirty) {
                bindings.put("dirty_flag", SVNDecoratorPreferencesPage.this.dirtyFlag.getText());
            }
            if (previewFile.added) {
                bindings.put("added_flag", SVNDecoratorPreferencesPage.this.addedFlag.getText());
            }
            if (previewFile.external) {
                bindings.put("external_flag", SVNDecoratorPreferencesPage.this.externalFlag.getText());
            }
            if (previewFile.type == 1) {
                return SVNDecoratorConfiguration.decorate(previewFile.name, SVNDecoratorPreferencesPage.this.fileTextFormat.getText(), bindings);
            }
            if (previewFile.type == 2) {
                return SVNDecoratorConfiguration.decorate(previewFile.name, SVNDecoratorPreferencesPage.this.folderTextFormat.getText(), bindings);
            }
            if (previewFile.type == 4) {
                return SVNDecoratorConfiguration.decorate(previewFile.name, SVNDecoratorPreferencesPage.this.projectTextFormat.getText(), bindings);
            }
            return previewFile.name;
        }

        public ImageDescriptor getOverlay(Object element) {
            PreviewFile previewFile = (PreviewFile)element;
            if (SVNDecoratorPreferencesPage.this.imageShowNewResource.getSelection() && previewFile.newResource) {
                return newResource;
            }
            if (SVNDecoratorPreferencesPage.this.imageShowAdded.getSelection() && previewFile.added) {
                return added;
            }
            if (SVNDecoratorPreferencesPage.this.imageShowDirty.getSelection() && previewFile.dirty) {
                return dirty;
            }
            if (SVNDecoratorPreferencesPage.this.imageShowExternal.getSelection() && previewFile.external) {
                return external;
            }
            if (SVNDecoratorPreferencesPage.this.imageShowHasRemote.getSelection() && previewFile.hasRemote) {
                return checkedIn;
            }
            return null;
        }

        public Image getImage(Object element) {
            String s;
            switch (((PreviewFile)element).type) {
                case 4: {
                    s = "IMG_OBJ_PROJECT";
                    break;
                }
                case 2: {
                    s = "IMG_OBJ_FOLDER";
                    break;
                }
                default: {
                    s = "IMG_OBJ_FILE";
                }
            }
            Image baseImage = PlatformUI.getWorkbench().getSharedImages().getImage(s);
            ImageDescriptor overlay = this.getOverlay(element);
            if (overlay == null) {
                return baseImage;
            }
            try {
                return this.fImageCache.createImage((ImageDescriptor)new OverlayIcon(baseImage, new ImageDescriptor[]{overlay}, new int[]{3}, new Point(baseImage.getBounds().width, baseImage.getBounds().height)));
            }
            catch (Exception e) {
                SVNUIPlugin.log(e.getMessage());
                return null;
            }
        }
    }

    private static class ThemeListener
    implements IPropertyChangeListener {
        private final Preview preview;

        ThemeListener(Preview preview) {
            this.preview = preview;
        }

        public void propertyChange(PropertyChangeEvent event) {
            this.preview.refresh();
        }
    }
}

