/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.history.Alias;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.comments.CommitCommentArea;
import org.tigris.subversion.subclipse.ui.dialogs.BranchTagPropertyUpdateDialog;
import org.tigris.subversion.subclipse.ui.dialogs.ChooseUrlDialog;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.settings.CommentProperties;
import org.tigris.subversion.subclipse.ui.settings.ProjectProperties;
import org.tigris.subversion.subclipse.ui.util.UrlCombo;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class BranchTagDialog
extends TrayDialog {
    private static final int URL_WIDTH_HINT = 450;
    private static final int REVISION_WIDTH_HINT = 40;
    private IResource resource;
    private ISVNRemoteResource remoteResource;
    private ISVNLocalResource svnResource;
    private UrlCombo toUrlCombo;
    private Button serverButton;
    private Button revisionButton;
    private Text revisionText;
    private Button logButton;
    private Button workingCopyButton;
    private CommitCommentArea commitCommentArea;
    private SVNRevision revision;
    private SVNUrl url;
    private SVNUrl toUrl;
    private boolean createOnServer;
    private boolean specificRevision;
    private String comment;
    private Text issueText;
    private String issue;
    private Button okButton;
    private CommentProperties commentProperties;
    private ProjectProperties projectProperties;
    private long revisionNumber = 0L;
    private Alias newAlias;
    private Button switchAfterBranchTagCheckBox;
    private boolean switchAfterBranchTag;
    protected static final int LABEL_WIDTH_HINT = 400;

    public void setRevisionNumber(long revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    public BranchTagDialog(Shell parentShell, IResource resource) {
        super(parentShell);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10);
        try {
            this.commentProperties = CommentProperties.getCommentProperties(resource);
            this.projectProperties = ProjectProperties.getProjectProperties(resource);
        }
        catch (SVNException sVNException) {}
        this.commitCommentArea = new CommitCommentArea((Dialog)this, null, Policy.bind("BranchTagDialog.enterComment"), this.commentProperties);
        if (this.commentProperties != null && this.commentProperties.getMinimumLogMessageSize() != 0) {
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    BranchTagDialog.this.setOkButtonStatus();
                }
            };
            this.commitCommentArea.setModifyListener(modifyListener);
        }
        this.resource = resource;
    }

    public BranchTagDialog(Shell parentShell, ISVNRemoteResource remoteResource) {
        super(parentShell);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10);
        this.commitCommentArea = new CommitCommentArea((Dialog)this, null, Policy.bind("BranchTagDialog.enterComment"), this.commentProperties);
        this.remoteResource = remoteResource;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Policy.bind("BranchTagDialog.title"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite top = new Composite(composite, 0);
        top.setLayout((Layout)new GridLayout());
        top.setLayoutData((Object)new GridData(1808));
        Group repositoryGroup = new Group(top, 0);
        repositoryGroup.setText(Policy.bind("BranchTagDialog.repository"));
        repositoryGroup.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        repositoryGroup.setLayoutData((Object)data);
        Label fromUrlLabel = new Label((Composite)repositoryGroup, 0);
        if (this.resource == null) {
            fromUrlLabel.setText(Policy.bind("BranchTagDialog.fromUrl"));
        } else {
            fromUrlLabel.setText(Policy.bind("BranchTagDialog.url"));
        }
        Text urlText = new Text((Composite)repositoryGroup, 2048);
        data = new GridData();
        data.widthHint = 450;
        urlText.setLayoutData((Object)data);
        if (this.resource == null) {
            this.url = this.remoteResource.getUrl();
            urlText.setText(this.url.toString());
        } else {
            this.svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource);
            try {
                this.url = this.svnResource.getStatus().getUrl();
                if (this.url != null) {
                    urlText.setText(this.svnResource.getStatus().getUrlString());
                }
            }
            catch (SVNException sVNException) {}
        }
        urlText.setEditable(false);
        Label toUrlLabel = new Label((Composite)repositoryGroup, 0);
        toUrlLabel.setText(Policy.bind("BranchTagDialog.toUrl"));
        Composite urlComposite = new Composite((Composite)repositoryGroup, 0);
        GridLayout urlLayout = new GridLayout();
        urlLayout.numColumns = 2;
        urlLayout.marginWidth = 0;
        urlLayout.marginHeight = 0;
        urlComposite.setLayout((Layout)urlLayout);
        data = new GridData(1808);
        urlComposite.setLayoutData((Object)data);
        this.toUrlCombo = this.resource == null ? new UrlCombo(urlComposite, "repositoryBrowser") : new UrlCombo(urlComposite, this.resource.getProject().getName());
        this.toUrlCombo.setText(urlText.getText());
        Button browseButton = new Button(urlComposite, 8);
        browseButton.setText(Policy.bind("SwitchDialog.browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseUrlDialog dialog = new ChooseUrlDialog(BranchTagDialog.this.getShell(), BranchTagDialog.this.resource);
                if (dialog.open() == 0 && dialog.getUrl() != null) {
                    BranchTagDialog.this.toUrlCombo.setText(dialog.getUrl());
                }
            }
        });
        Group serverComposite = new Group((Composite)repositoryGroup, 0);
        serverComposite.setText(Policy.bind("BranchTagDialog.createCopy"));
        GridLayout serverLayout = new GridLayout();
        serverLayout.numColumns = 3;
        serverComposite.setLayout((Layout)serverLayout);
        data = new GridData(1808);
        serverComposite.setLayoutData((Object)data);
        this.serverButton = new Button((Composite)serverComposite, 16);
        this.serverButton.setText(Policy.bind("BranchTagDialog.head"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.serverButton.setLayoutData((Object)data);
        this.revisionButton = new Button((Composite)serverComposite, 16);
        this.revisionButton.setText(Policy.bind("BranchTagDialog.revision"));
        this.revisionText = new Text((Composite)serverComposite, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.revisionText.setLayoutData((Object)data);
        if (this.revisionNumber == 0L) {
            this.revisionText.setEnabled(false);
        } else {
            this.revisionText.setText("" + this.revisionNumber);
        }
        this.revisionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BranchTagDialog.this.setOkButtonStatus();
            }
        });
        this.logButton = new Button((Composite)serverComposite, 8);
        this.logButton.setText(Policy.bind("MergeDialog.showLog"));
        if (this.revisionNumber == 0L) {
            this.logButton.setEnabled(false);
        }
        this.logButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BranchTagDialog.this.showLog();
            }
        });
        this.workingCopyButton = new Button((Composite)serverComposite, 16);
        this.workingCopyButton.setText(Policy.bind("BranchTagDialog.working"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.workingCopyButton.setLayoutData((Object)data);
        if (this.resource == null) {
            this.workingCopyButton.setVisible(false);
        }
        if (this.revisionNumber == 0L) {
            this.serverButton.setSelection(true);
        } else {
            this.revisionButton.setSelection(true);
        }
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BranchTagDialog.this.revisionText.setEnabled(BranchTagDialog.this.revisionButton.getSelection());
                BranchTagDialog.this.logButton.setEnabled(BranchTagDialog.this.revisionButton.getSelection());
                if (BranchTagDialog.this.revisionButton.getSelection()) {
                    BranchTagDialog.this.revisionText.setFocus();
                }
                BranchTagDialog.this.setOkButtonStatus();
            }
        };
        this.serverButton.addSelectionListener((SelectionListener)selectionListener);
        this.revisionButton.addSelectionListener((SelectionListener)selectionListener);
        this.workingCopyButton.addSelectionListener((SelectionListener)selectionListener);
        if (this.projectProperties != null) {
            this.addBugtrackingArea(top);
        }
        this.commitCommentArea.createArea(composite);
        this.commitCommentArea.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty() == "OkRequested") {
                    BranchTagDialog.this.okPressed();
                }
            }
        });
        this.toUrlCombo.getCombo().setFocus();
        if (this.resource != null) {
            this.switchAfterBranchTagCheckBox = new Button(composite, 32);
            this.switchAfterBranchTagCheckBox.setText(Policy.bind("BranchTagDialog.switchAfterTagBranch"));
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.branch_tag_dialog_context");
        return composite;
    }

    protected void showLog() {
        ISVNRemoteResource remoteResource = null;
        if (this.resource == null) {
            remoteResource = this.remoteResource;
        } else {
            try {
                remoteResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource).getRepository().getRemoteFile(this.url);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)e.toString());
                return;
            }
        }
        if (remoteResource == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)(String.valueOf(Policy.bind("MergeDialog.urlError")) + " " + this.toUrlCombo.getText()));
            return;
        }
        HistoryDialog dialog = new HistoryDialog(this.getShell(), remoteResource);
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        this.revisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
        this.setOkButtonStatus();
    }

    private void addBugtrackingArea(Composite composite) {
        Composite bugtrackingComposite = new Composite(composite, 0);
        GridLayout bugtrackingLayout = new GridLayout();
        bugtrackingLayout.numColumns = 2;
        bugtrackingComposite.setLayout((Layout)bugtrackingLayout);
        Label label = new Label(bugtrackingComposite, 0);
        label.setText(this.projectProperties.getLabel());
        this.issueText = new Text(bugtrackingComposite, 2048);
        GridData data = new GridData();
        data.widthHint = 150;
        this.issueText.setLayoutData((Object)data);
    }

    protected void okPressed() {
        if (this.projectProperties != null) {
            String issueError;
            this.issue = this.issueText.getText().trim();
            if (this.projectProperties.isWarnIfNoIssue() && this.issueText.getText().trim().length() == 0 && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("BranchTagDialog.title"), (String)Policy.bind("BranchTagDialog.0", this.projectProperties.getLabel()))) {
                this.issueText.setFocus();
                return;
            }
            if (this.issueText.getText().trim().length() > 0 && (issueError = this.projectProperties.validateIssue(this.issueText.getText().trim())) != null) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("BranchTagDialog.title"), (String)issueError);
                this.issueText.selectAll();
                this.issueText.setFocus();
                return;
            }
        }
        this.toUrlCombo.saveUrl();
        this.createOnServer = !this.workingCopyButton.getSelection();
        this.specificRevision = this.revisionButton.getSelection();
        if (this.switchAfterBranchTagCheckBox != null) {
            this.switchAfterBranchTag = this.switchAfterBranchTagCheckBox.getSelection();
        }
        this.comment = this.commitCommentArea.getComment();
        if (this.serverButton.getSelection()) {
            this.revision = SVNRevision.HEAD;
        }
        try {
            this.toUrl = new SVNUrl(this.toUrlCombo.getText());
            if (this.revisionButton.getSelection()) {
                this.revision = SVNRevision.getRevision((String)this.revisionText.getText().trim());
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("BranchTagDialog.title"), (String)e.getMessage());
            return;
        }
        if (this.resource != null) {
            this.updateTagsProperty(this.toUrl);
        }
        super.okPressed();
    }

    private void updateTagsProperty(SVNUrl toUrl) {
        try {
            ISVNProperty property = null;
            property = this.svnResource.getSvnProperty("subclipse:tags");
            if (property == null) {
                return;
            }
            this.newAlias = new Alias();
            this.newAlias.setBranch(toUrl.toString().toUpperCase().indexOf("TAGS") == -1);
            String relativePath = toUrl.toString().substring(this.svnResource.getRepository().getUrl().toString().length());
            this.newAlias.setRelativePath(relativePath);
            SVNRevision revision = null;
            if (this.revisionButton.getSelection()) {
                revision = SVNRevision.getRevision((String)this.revisionText.getText().trim());
            } else {
                ISVNClientAdapter svnClient = this.svnResource.getRepository().getSVNClient();
                ISVNInfo svnInfo = svnClient.getInfo(this.url);
                revision = SVNRevision.getRevision((String)svnInfo.getRevision().toString());
            }
            this.newAlias.setRevision(Integer.parseInt(revision.toString()));
            this.newAlias.setName(toUrl.getLastPathSegment());
            BranchTagPropertyUpdateDialog dialog = new BranchTagPropertyUpdateDialog(this.getShell(), this.resource, this.newAlias);
            this.newAlias = dialog.open() == 0 ? dialog.getNewAlias() : null;
        }
        catch (Exception exception) {}
    }

    private void setOkButtonStatus() {
        if (this.commentProperties != null && this.commentProperties.getMinimumLogMessageSize() != 0 && this.commitCommentArea.getComment().trim().length() < this.commentProperties.getMinimumLogMessageSize()) {
            this.okButton.setEnabled(false);
            return;
        }
        if (this.revisionButton.getSelection() && this.revisionText.getText().trim().length() == 0) {
            this.okButton.setEnabled(false);
            return;
        }
        this.okButton.setEnabled(true);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.okButton = button;
            if (this.commentProperties != null && this.commentProperties.getMinimumLogMessageSize() != 0) {
                this.okButton.setEnabled(false);
            }
        }
        return button;
    }

    protected Label createWrappingLabel(Composite parent) {
        Label label = new Label(parent, 16448);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.horizontalIndent = 0;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 400;
        label.setLayoutData((Object)data);
        return label;
    }

    public String getComment() {
        if (this.projectProperties != null && this.issue != null && this.issue.length() > 0) {
            if (this.projectProperties.isAppend()) {
                return String.valueOf(this.comment) + "\n" + this.projectProperties.getResolvedMessage(this.issue) + "\n";
            }
            return String.valueOf(this.projectProperties.getResolvedMessage(this.issue)) + "\n" + this.comment;
        }
        return this.comment;
    }

    public boolean isCreateOnServer() {
        return this.createOnServer;
    }

    public boolean isSpecificRevision() {
        return this.specificRevision;
    }

    public SVNUrl getToUrl() {
        return this.toUrl;
    }

    public SVNUrl getUrl() {
        return this.url;
    }

    public SVNRevision getRevision() {
        return this.revision;
    }

    public Alias getNewAlias() {
        return this.newAlias;
    }

    public boolean switchAfterTagBranch() {
        return this.switchAfterBranchTag;
    }
}

