/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.decorator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IMarkerResolution;
import org.tigris.subversion.subclipse.core.ISVNLocalFile;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.operations.ResolveOperation;

public class AcceptMineResolution
implements IMarkerResolution {
    public String getLabel() {
        return Policy.bind("AcceptMine.label");
    }

    public void run(IMarker marker) {
        try {
            IFile file = (IFile)marker.getResource();
            ISVNLocalFile svnFile = (ISVNLocalFile)SVNWorkspaceRoot.getSVNResourceFor((IResource)file);
            File mine = svnFile.getStatus().getConflictWorking();
            if (mine == null) {
                return;
            }
            file.setContents((InputStream)new FileInputStream(mine), true, true, (IProgressMonitor)new NullProgressMonitor());
            new ResolveOperation(null, new IResource[]{marker.getResource()}).run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof SVNException) {
                SVNUIPlugin.log((TeamException)((Object)((SVNException)e.getTargetException())));
            } else {
                SVNUIPlugin.log(4, e.getMessage(), e);
            }
        }
        catch (InterruptedException e) {
            SVNUIPlugin.log(4, e.getMessage(), e);
        }
        catch (CoreException e) {
            SVNUIPlugin.log(e);
        }
        catch (FileNotFoundException e) {
            SVNUIPlugin.log(4, e.getMessage(), e);
        }
    }
}

