/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.console;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.FileEditorInput;

public class PathMatcher
implements IPatternMatchListenerDelegate {
    private static Pattern[] PATTERNS = new Pattern[]{Pattern.compile(".*\\s+[SAUCDGMR]\\s+([^\r\n]+)"), Pattern.compile(".*\\s+Sending\\s+([^\r\n]+)"), Pattern.compile(".*\\s+Adding\\s+([^\r\n]+)"), Pattern.compile(".*\\s+Deleting\\s+([^\r\n]+)"), Pattern.compile(".*\\s+Replacing\\s+([^\r\n]+)"), Pattern.compile(".*\\s+Reverted\\s+([^\r\n]+)")};
    private TextConsole fConsole;

    public void connect(TextConsole console) {
        this.fConsole = console;
    }

    public void disconnect() {
        this.fConsole = null;
    }

    public void matchFound(PatternMatchEvent event) {
        if (this.fConsole != null) {
            String path;
            int offset = event.getOffset();
            int length = event.getLength();
            try {
                path = this.fConsole.getDocument().get(offset, length);
                if (path == null) {
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            int start = 0;
            int i = 0;
            while (i < PATTERNS.length) {
                Pattern pattern = PATTERNS[i];
                Matcher matcher = pattern.matcher(path);
                while (matcher.find(start)) {
                    length = matcher.end(1) - matcher.start(1);
                    String link = path.substring(matcher.start(1), matcher.end(1));
                    if (link != null) {
                        try {
                            this.fConsole.addHyperlink((IHyperlink)new FileHyperlink(link), offset + matcher.start(1), length);
                        }
                        catch (BadLocationException badLocationException) {}
                        return;
                    }
                    start = matcher.end();
                }
                ++i;
            }
        }
    }

    private static class FileHyperlink
    implements IHyperlink {
        private String myPath;

        public FileHyperlink(String path) {
            this.myPath = path;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            IFile file;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null || window.getActivePage() == null) {
                return;
            }
            IWorkbenchPage page = window.getActivePage();
            if (ResourcesPlugin.getWorkspace().getRoot() == null) {
                return;
            }
            IPath path = Path.fromOSString((String)this.myPath);
            if (!path.isAbsolute()) {
                path = path.makeAbsolute().setDevice(ResourcesPlugin.getWorkspace().getRoot().getLocation().getDevice());
            }
            if (!((file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path)) != null && file.exists() || path == null || path.isAbsolute() || path.segmentCount() <= 1)) {
                path = path.removeFirstSegments(1);
                file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            }
            if (file == null || !file.exists()) {
                return;
            }
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            if (registry == null) {
                return;
            }
            IEditorDescriptor descriptor = null;
            try {
                IContentDescription contentDescription = file.getContentDescription();
                descriptor = registry.getDefaultEditor(path.lastSegment(), contentDescription != null ? contentDescription.getContentType() : null);
            }
            catch (CoreException coreException) {}
            if (descriptor == null) {
                descriptor = registry.findEditor("org.eclipse.ui.systemExternalEditor");
            }
            if (descriptor == null) {
                return;
            }
            FileEditorInput input = new FileEditorInput(file);
            try {
                page.openEditor((IEditorInput)input, descriptor.getId());
            }
            catch (PartInitException partInitException) {}
        }
    }
}

