/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.compare.ResourceEditionNode;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalCompareInput;

public final class RevisionAwareDifferencer
extends Differencer {
    private static final int NODE_EQUAL = 0;
    private static final int NODE_NOT_EQUAL = 1;
    private static final int NODE_UNKNOWN = 2;

    protected boolean contentsEqual(Object input1, Object input2) {
        int compare = input1 instanceof SVNLocalCompareInput.SVNLocalResourceNode ? this.compareStatusAndRevisions(input1, input2) : this.compareEditions(input1, input2);
        if (compare == 0) {
            return true;
        }
        if (compare == 1) {
            return false;
        }
        return super.contentsEqual(input1, input2);
    }

    protected void updateProgress(IProgressMonitor progressMonitor, Object node) {
        if (node instanceof ITypedElement) {
            ITypedElement element = (ITypedElement)node;
            progressMonitor.subTask(Policy.bind("CompareEditorInput.fileProgress", new String[]{element.getName()}));
            progressMonitor.worked(1);
        }
    }

    protected int compareStatusAndRevisions(Object left, Object right) {
        LocalResourceStatus localStatus;
        ISVNRemoteResource edition;
        ISVNLocalResource localResource;
        block10: {
            String rightLocation;
            localResource = null;
            if (left instanceof SVNLocalCompareInput.SVNLocalResourceNode) {
                localResource = ((SVNLocalCompareInput.SVNLocalResourceNode)((Object)left)).getLocalResource();
            }
            edition = null;
            if (right instanceof ResourceEditionNode) {
                edition = ((ResourceEditionNode)right).getRemoteResource();
            }
            if (localResource == null || edition == null) {
                return 2;
            }
            if (localResource.isFolder() && edition.isContainer()) {
                return 0;
            }
            if (localResource.isFolder() != edition.isContainer()) {
                return 1;
            }
            String leftLocation = localResource.getRepository().getLocation();
            if (!leftLocation.equals(rightLocation = edition.getRepository().getLocation())) {
                return 2;
            }
            localStatus = null;
            try {
                localStatus = localResource.getStatus();
                if (localStatus != null) break block10;
                return 2;
            }
            catch (SVNException sVNException) {
                return 2;
            }
        }
        if (!localResource.isDirty() && localResource.getUrl().equals((Object)edition.getUrl()) && localStatus.getLastChangedRevision().equals((Object)edition.getLastChangedRevision())) {
            return 0;
        }
        return 2;
    }

    protected int compareEditions(Object left, Object right) {
        String rightLocation;
        ISVNRemoteResource leftEdition = null;
        if (left instanceof ResourceEditionNode) {
            leftEdition = ((ResourceEditionNode)left).getRemoteResource();
        }
        ISVNRemoteResource rightEdition = null;
        if (right instanceof ResourceEditionNode) {
            rightEdition = ((ResourceEditionNode)right).getRemoteResource();
        }
        if (leftEdition == null || rightEdition == null) {
            return 2;
        }
        if (leftEdition.isContainer() && rightEdition.isContainer()) {
            return 0;
        }
        if (leftEdition.isContainer() != rightEdition.isContainer()) {
            return 1;
        }
        String leftLocation = leftEdition.getRepository().getLocation();
        if (!leftLocation.equals(rightLocation = rightEdition.getRepository().getLocation())) {
            return 2;
        }
        if (leftEdition.getUrl().equals((Object)rightEdition.getUrl()) && leftEdition.getLastChangedRevision().equals((Object)rightEdition.getLastChangedRevision())) {
            return 0;
        }
        return 2;
    }
}

