/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.formatter;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.formatter.CodeFormatter;
import org.rubypeople.rdt.core.formatter.DefaultCodeFormatterConstants;
import org.rubypeople.rdt.core.formatter.Indents;
import org.rubypeople.rdt.internal.formatter.AbstractBlockMarker;
import org.rubypeople.rdt.internal.formatter.BeginBlockMarker;
import org.rubypeople.rdt.internal.formatter.DefaultCodeFormatterOptions;
import org.rubypeople.rdt.internal.formatter.EndBlockMarker;
import org.rubypeople.rdt.internal.formatter.FixLengthMarker;
import org.rubypeople.rdt.internal.formatter.IndentationState;
import org.rubypeople.rdt.internal.formatter.MidBlockMarker;
import org.rubypeople.rdt.internal.formatter.NeutralMarker;
import org.rubypeople.rdt.internal.formatter.NoFormattingMarker;

public class OldCodeFormatter
extends CodeFormatter {
    private static final String BLOCK_BEGIN_RE = "(class|module|def|if|unless|case|while|until|for|begin|do)";
    private static final String BLOCK_MID_RE = "(else|elsif|when|rescue|ensure)";
    private static final String BLOCK_END_RE = "(end)";
    private static final String DELIMITER_RE = "[?$/(){}#\\`.:\\]\\[]";
    private static final String[] LITERAL_BEGIN_LITERALS = new String[]{"\"", "'", "=begin", "%[Qqrxw]?.", "/", "<<[\\-]?[']?[a-zA-Z_]+[']?"};
    private static final String[] LITERAL_END_RES = new String[]{"[^\\\\](\\\\\\\\)*\"", "[^\\\\](\\\\\\\\)*'", "=end", "", "", ""};
    private final int BLOCK_BEGIN_PAREN = 2;
    private final int BLOCK_MID_PAREN = 5;
    private final int BLOCK_END_PAREN = 8;
    private final int LITERAL_BEGIN_PAREN = 10;
    private static Pattern MODIFIER_RE;
    private static Pattern OPERATOR_RE;
    private static Pattern NON_BLOCK_DO_RE;
    private static String LITERAL_BEGIN_RE;
    private static Pattern[] LITERAL_END_RES_COMPILED;
    private DefaultCodeFormatterOptions preferences;
    private Map options;

    static {
        LITERAL_END_RES_COMPILED = new Pattern[LITERAL_END_RES.length];
        int n = 0;
        while (n < LITERAL_END_RES.length) {
            try {
                OldCodeFormatter.LITERAL_END_RES_COMPILED[n] = Pattern.compile(LITERAL_END_RES[n]);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                System.out.println(patternSyntaxException);
            }
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n2 = 0;
        while (n2 < LITERAL_BEGIN_LITERALS.length) {
            stringBuffer.append(LITERAL_BEGIN_LITERALS[n2]);
            if (n2 < LITERAL_BEGIN_LITERALS.length - 1) {
                stringBuffer.append("|");
            }
            ++n2;
        }
        stringBuffer.append(")");
        LITERAL_BEGIN_RE = stringBuffer.toString();
        try {
            MODIFIER_RE = Pattern.compile("if|unless|while|until|rescue");
            OPERATOR_RE = Pattern.compile("[\\-,.+*/%&|\\^~=<>:]");
            NON_BLOCK_DO_RE = Pattern.compile("(^|[\\s])(while|until|for|rescue)[\\s]");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            System.out.println(patternSyntaxException);
        }
    }

    public OldCodeFormatter() {
        this(new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getRubyConventionsSettings()), null);
    }

    public OldCodeFormatter(DefaultCodeFormatterOptions defaultCodeFormatterOptions) {
        this(defaultCodeFormatterOptions, null);
    }

    public OldCodeFormatter(DefaultCodeFormatterOptions defaultCodeFormatterOptions, Map map) {
        if (map != null) {
            this.options = map;
            this.preferences = new DefaultCodeFormatterOptions(map);
        } else {
            this.options = RubyCore.getOptions();
            this.preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getRubyConventionsSettings());
        }
        if (defaultCodeFormatterOptions != null) {
            this.preferences.set(defaultCodeFormatterOptions.getMap());
        }
    }

    public OldCodeFormatter(Map map) {
        this(null, map);
    }

    public synchronized String formatString(String string) {
        AbstractBlockMarker abstractBlockMarker = this.createBlockMarkerList(string);
        if (this.isDebug()) {
            abstractBlockMarker.print();
        }
        int n = Indents.measureIndentUnits(string, this.preferences.tab_size, this.preferences.indentation_size);
        try {
            return this.formatString(string, abstractBlockMarker, n);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return string;
        }
    }

    private boolean isDebug() {
        String string = Platform.getDebugOption((String)"org.rubypeople.rdt.core/codeformatter");
        boolean bl = string == null ? false : string.equalsIgnoreCase("true");
        return bl;
    }

    protected String formatString(String string, AbstractBlockMarker abstractBlockMarker, int n) throws PatternSyntaxException {
        Pattern pattern = Pattern.compile("\n");
        String[] stringArray = pattern.split(string);
        IndentationState indentationState = null;
        StringBuffer stringBuffer = new StringBuffer();
        Pattern pattern2 = Pattern.compile("^[\t ]*");
        int n2 = 0;
        while (n2 < stringArray.length) {
            Matcher matcher = pattern2.matcher(stringArray[n2]);
            matcher.find();
            int n3 = matcher.end(0);
            if (indentationState == null) {
                indentationState = new IndentationState(string, n3, n);
            }
            indentationState.incPos(n3);
            String string2 = stringArray[n2].substring(n3);
            AbstractBlockMarker abstractBlockMarker2 = this.findNextBlockMarker(abstractBlockMarker, indentationState.getPos(), indentationState);
            if (abstractBlockMarker2 != null) {
                abstractBlockMarker2.indentBeforePrint(indentationState);
                abstractBlockMarker2.appendIndentedLine(stringBuffer, indentationState, stringArray[n2], string2, this.options);
                abstractBlockMarker2.indentAfterPrint(indentationState);
                abstractBlockMarker = abstractBlockMarker2;
            } else {
                abstractBlockMarker.appendIndentedLine(stringBuffer, indentationState, stringArray[n2], string2, this.options);
            }
            if (n2 != stringArray.length - 1) {
                stringBuffer.append("\n");
            }
            indentationState.incPos(string2.length() + 1);
            ++n2;
        }
        if (string.lastIndexOf("\n") == string.length() - 1) {
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private AbstractBlockMarker findNextBlockMarker(AbstractBlockMarker abstractBlockMarker, int n, IndentationState indentationState) {
        AbstractBlockMarker abstractBlockMarker2 = abstractBlockMarker;
        while (abstractBlockMarker.getNext() != null && abstractBlockMarker.getNext().getPos() <= n) {
            if (abstractBlockMarker != abstractBlockMarker2) {
                abstractBlockMarker.indentBeforePrint(indentationState);
                abstractBlockMarker.indentAfterPrint(indentationState);
            }
            abstractBlockMarker = abstractBlockMarker.getNext();
        }
        return abstractBlockMarker2 == abstractBlockMarker ? null : abstractBlockMarker;
    }

    protected AbstractBlockMarker createBlockMarkerList(String string) {
        Pattern pattern = null;
        try {
            pattern = Pattern.compile("(^|[\\s]|;)(class|module|def|if|unless|case|while|until|for|begin|do)($|[\\s]|[?$/(){}#\\`.:\\]\\[])|(^|[\\s])(else|elsif|when|rescue|ensure)($|[\\s]|[?$/(){}#\\`.:\\]\\[])|(^|[\\s]|;)(end)($|[\\s]|;)|" + LITERAL_BEGIN_RE + "|" + DELIMITER_RE);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            System.out.println(patternSyntaxException);
        }
        int n = 0;
        AbstractBlockMarker abstractBlockMarker = new NeutralMarker("start", 0);
        NeutralMarker neutralMarker = abstractBlockMarker;
        Matcher matcher = pattern.matcher(string);
        while (n != -1 && matcher.find(n)) {
            String string2;
            AbstractBlockMarker abstractBlockMarker2 = null;
            if (matcher.group(2) != null) {
                n = matcher.end(2);
                string2 = matcher.group(2);
                if (MODIFIER_RE.matcher(string2).matches() && !this.isRubyExprBegin(string, matcher.start(2), "modifier") || string2.equals("do") && this.isNonBlockDo(string, matcher.start(2))) continue;
                abstractBlockMarker2 = new BeginBlockMarker(matcher.group(2), matcher.start(2));
            } else if (matcher.group(5) != null) {
                n = matcher.end(5);
                abstractBlockMarker2 = new MidBlockMarker(matcher.group(5), matcher.start(5));
            } else if (matcher.group(8) != null) {
                n = matcher.end(8);
                abstractBlockMarker2 = new EndBlockMarker(matcher.group(8), matcher.start(8));
            } else if (matcher.group(10) != null) {
                block34: {
                    int n2;
                    n = matcher.end(10);
                    string2 = matcher.group(10);
                    if (string2.startsWith("%")) {
                        boolean bl;
                        n2 = string2.charAt(string2.length() - 1);
                        boolean bl2 = bl = string2.charAt(1) != 'q';
                        n = n2 == 91 ? this.forwardString(string, n, '[', ']', bl) : (n2 == 40 ? this.forwardString(string, n, '(', ')', bl) : (n2 == 123 ? this.forwardString(string, n, '{', '}', bl) : (n2 == 60 ? this.forwardString(string, n, '<', '>', bl) : string.indexOf(n2, n))));
                    } else if (string2.startsWith("/")) {
                        int n3;
                        n2 = this.forwardString(string, n, ' ', "/", true);
                        if (n2 == n || (n3 = string.indexOf("\n", n)) != -1 && n2 > n3) continue;
                        n = n2;
                    } else if (string2.startsWith("'")) {
                        if (n > 1 && string.charAt(n - 2) == '$') continue;
                        n = this.forwardString(string, n, ' ', "'", true);
                    } else {
                        if (string2.startsWith("<<")) {
                            boolean bl;
                            n2 = 2;
                            int n4 = string2.length();
                            boolean bl3 = bl = string2.charAt(n2) == '-';
                            if (bl) {
                                ++n2;
                            }
                            if (n2 < string2.length() - 1 && string2.charAt(n2) == '\'') {
                                ++n2;
                                --n4;
                            }
                            String string3 = String.valueOf(bl ? "" : "\n") + string2.substring(n2, n4);
                            try {
                                Pattern pattern2 = Pattern.compile(string3);
                                Matcher matcher2 = pattern2.matcher(string);
                                n = matcher2.find(n) ? matcher2.end(0) : -1;
                                break block34;
                            }
                            catch (PatternSyntaxException patternSyntaxException) {
                                continue;
                            }
                        }
                        n2 = 0;
                        while (n2 < LITERAL_BEGIN_LITERALS.length) {
                            if (LITERAL_BEGIN_LITERALS[n2].equals(string2)) {
                                Pattern pattern3 = LITERAL_END_RES_COMPILED[n2];
                                n = -1;
                                Matcher matcher3 = pattern3.matcher(string);
                                if (!matcher3.find(matcher.end(10) - 1)) break;
                                n = matcher3.end(0);
                                break;
                            }
                            ++n2;
                        }
                    }
                }
                abstractBlockMarker2 = new NoFormattingMarker(string2, matcher.start(10));
                if (n != -1) {
                    abstractBlockMarker.setNext(abstractBlockMarker2);
                    abstractBlockMarker = abstractBlockMarker2;
                    abstractBlockMarker2 = new NeutralMarker("", n);
                }
            } else {
                string2 = matcher.group(0);
                if (string2.equals("#")) {
                    n = string.indexOf("\n", matcher.end(0));
                    continue;
                }
                if (string2.equals("{")) {
                    abstractBlockMarker2 = new BeginBlockMarker("{", matcher.start(0));
                } else if (string2.equals("}")) {
                    abstractBlockMarker2 = new EndBlockMarker("}", matcher.start(0));
                } else if (string2.equals("(")) {
                    abstractBlockMarker2 = new FixLengthMarker("(", matcher.start(0));
                } else if (string2.equals(")")) {
                    abstractBlockMarker2 = new NeutralMarker(")", matcher.start(0));
                }
                n = matcher.end(0);
            }
            if (abstractBlockMarker2 == null) continue;
            if (abstractBlockMarker != null) {
                abstractBlockMarker.setNext(abstractBlockMarker2);
            }
            abstractBlockMarker = abstractBlockMarker2;
        }
        return neutralMarker;
    }

    protected int forwardString(String string, int n, char c, char c2, boolean bl) {
        return this.forwardString(string, n, c, "\\" + c + "\\" + c2, bl);
    }

    protected int forwardString(String string, int n, char c, String string2, boolean bl) {
        int n2 = 1;
        try {
            Pattern pattern = Pattern.compile(bl ? "[" + string2 + "]|(#\\{)" : "[" + string2 + "]");
            Matcher matcher = pattern.matcher(string);
            while (matcher.find(n) && n2 > 0) {
                if (matcher.group(1) != null) {
                    n = this.forwardString(string, matcher.end(1), '{', "\\{\\}", bl);
                    continue;
                }
                n = matcher.end(0);
                if (n > 2 && string.charAt(n - 2) == '\\' && string.charAt(n - 3) != '\\') continue;
                if (matcher.group(0).charAt(0) == c) {
                    ++n2;
                    continue;
                }
                --n2;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            patternSyntaxException.printStackTrace();
        }
        return n;
    }

    protected int skipCharsBackward(String string, int n) {
        do {
            if (n == 0) {
                return 0;
            }
            if (string.charAt(n - 1) != '\n') continue;
            return n;
        } while (string.charAt(--n) == '\t' || string.charAt(n) == ' ');
        return n;
    }

    /*
     * Unable to fully structure code
     */
    protected int backToIndentation(String var1_1, int var2_2) {
        while (true) {
            if (var2_2 == 0) {
                return 0;
            }
            if (var1_1.charAt(var2_2 - 1) == '\n') ** GOTO lbl-1000
            --var2_2;
        }
        while (++var2_2 != var1_1.length()) lbl-1000:
        // 2 sources

        {
            if (var1_1.charAt(var2_2) == '\t' || var1_1.charAt(var2_2) == ' ') continue;
        }
        return var2_2;
    }

    protected int posOfLineStart(String string, int n) {
        while (true) {
            if (n == 0) {
                return 0;
            }
            if (string.charAt(n - 1) == '\n') break;
            --n;
        }
        return n;
    }

    protected boolean matchREBackward(String string, Pattern pattern) {
        int n = string.length() - 1;
        while (n >= 0) {
            if (string.charAt(n) == ';') {
                return false;
            }
            if (pattern.matcher(string).find(n)) {
                return true;
            }
            --n;
        }
        return false;
    }

    protected boolean isRubyExprBegin(String string, int n, String string2) {
        int n2 = this.skipCharsBackward(string, n);
        if (n2 == 0 || string.charAt(n2 - 1) == '\n') {
            return true;
        }
        char c = string.charAt(n2);
        if (c == ';') {
            return true;
        }
        String string3 = "" + c;
        return OPERATOR_RE.matcher(string3).matches();
    }

    protected boolean isNonBlockDo(String string, int n) {
        int n2 = this.posOfLineStart(string, n);
        return this.matchREBackward(string.substring(n2, n), NON_BLOCK_DO_RE);
    }

    public TextEdit format(int n, String string, int n2, int n3, int n4, String string2) {
        String string3 = this.formatString(string.substring(n2, n3), n4);
        return new ReplaceEdit(n2, n3, string3);
    }

    private String formatString(String string, int n) {
        AbstractBlockMarker abstractBlockMarker = this.createBlockMarkerList(string);
        if (this.isDebug()) {
            abstractBlockMarker.print();
        }
        try {
            return this.formatString(string, abstractBlockMarker, n);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return string;
        }
    }
}

