/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IProblemRequestor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.core.parser.IProblem;
import org.rubypeople.rdt.internal.core.DeltaProcessingState;
import org.rubypeople.rdt.internal.core.DeltaProcessor;
import org.rubypeople.rdt.internal.core.ReconcileWorkingCopyOperation;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyElementInfo;
import org.rubypeople.rdt.internal.core.RubyModel;
import org.rubypeople.rdt.internal.core.RubyModelCache;
import org.rubypeople.rdt.internal.core.RubyModelOperation;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.buffer.BufferManager;
import org.rubypeople.rdt.internal.core.builder.RubyBuilder;
import org.rubypeople.rdt.internal.core.util.Util;

public class RubyModelManager
implements IContentTypeManager.IContentTypeChangeListener {
    private static final String BUFFER_MANAGER_DEBUG = "org.rubypeople.rdt.core/debug/buffermanager";
    private static final String RUBYMODEL_DEBUG = "org.rubypeople.rdt.core/debug/rubymodel";
    private static final String DELTA_DEBUG = "org.rubypeople.rdt.core/debug/rubydelta";
    private static final String DELTA_DEBUG_VERBOSE = "org.rubypeople.rdt.core/debug/rubydelta/verbose";
    private static final String POST_ACTION_DEBUG = "org.rubypeople.rdt.core/debug/postaction";
    private static final String BUILDER_DEBUG = "org.rubypeople.rdt.core/debug/builder";
    private static final String ENABLE_NEW_FORMATTER = "org.rubypeople.rdt.core/formatter/enable_new";
    public static final String DELTA_LISTENER_PERF = "org.rubypeople.rdt.core/perf/rubydeltalistener";
    public static final String RECONCILE_PERF = "org.rubypeople.rdt.core/perf/reconcile";
    private static final RubyModelManager MANAGER = new RubyModelManager();
    public DeltaProcessingState deltaState = new DeltaProcessingState();
    final RubyModel rubyModel = new RubyModel();
    private ThreadLocal temporaryCache = new ThreadLocal();
    protected Map elementsOutOfSynchWithBuffers = new HashMap(11);
    private ThreadLocal classpathsBeingResolved = new ThreadLocal();
    protected RubyModelCache cache = new RubyModelCache();
    protected Map perProjectInfos = new HashMap(5);
    protected Map perWorkingCopyInfos = new HashMap(5);
    private static boolean verbose = false;
    public static boolean CP_RESOLVE_VERBOSE = false;
    HashSet optionNames = new HashSet(20);
    Hashtable optionsCache;
    public final IEclipsePreferences[] preferencesLookup = new IEclipsePreferences[2];
    static final int PREF_INSTANCE = 0;
    static final int PREF_DEFAULT = 1;

    private RubyModelManager() {
    }

    public static final RubyModelManager getRubyModelManager() {
        return MANAGER;
    }

    public void initializePreferences() {
        this.preferencesLookup[0] = new InstanceScope().getNode("org.rubypeople.rdt.core");
        this.preferencesLookup[1] = new DefaultScope().getNode("org.rubypeople.rdt.core");
        Object object = new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent nodeChangeEvent) {
            }

            public void removed(IEclipsePreferences.NodeChangeEvent nodeChangeEvent) {
                if (nodeChangeEvent.getChild() == RubyModelManager.this.preferencesLookup[0]) {
                    RubyModelManager.this.preferencesLookup[0] = new InstanceScope().getNode("org.rubypeople.rdt.core");
                    RubyModelManager.this.preferencesLookup[0].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new EclipsePreferencesListener());
                }
            }
        };
        ((IEclipsePreferences)this.preferencesLookup[0].parent()).addNodeChangeListener(object);
        this.preferencesLookup[0].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new EclipsePreferencesListener());
        object = new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent nodeChangeEvent) {
            }

            public void removed(IEclipsePreferences.NodeChangeEvent nodeChangeEvent) {
                if (nodeChangeEvent.getChild() == RubyModelManager.this.preferencesLookup[1]) {
                    RubyModelManager.this.preferencesLookup[1] = new DefaultScope().getNode("org.rubypeople.rdt.core");
                }
            }
        };
        ((IEclipsePreferences)this.preferencesLookup[1].parent()).addNodeChangeListener(object);
    }

    public synchronized Object getInfo(IRubyElement iRubyElement) {
        Object v;
        HashMap hashMap = (HashMap)this.temporaryCache.get();
        if (hashMap != null && (v = hashMap.get(iRubyElement)) != null) {
            return v;
        }
        return this.cache.getInfo(iRubyElement);
    }

    public synchronized Object removeInfoAndChildren(RubyElement rubyElement) throws RubyModelException {
        Object object = this.cache.peekAtInfo(rubyElement);
        if (object != null) {
            rubyElement.closing(object);
            if (rubyElement instanceof IParent && object instanceof RubyElementInfo) {
                IRubyElement[] iRubyElementArray = ((RubyElementInfo)object).getChildren();
                int n = 0;
                int n2 = iRubyElementArray.length;
                while (n < n2) {
                    RubyElement rubyElement2 = (RubyElement)iRubyElementArray[n];
                    rubyElement2.close();
                    ++n;
                }
            }
            this.cache.removeInfo(rubyElement);
            return object;
        }
        return null;
    }

    protected synchronized Object peekAtInfo(IRubyElement iRubyElement) {
        Object v;
        HashMap hashMap = (HashMap)this.temporaryCache.get();
        if (hashMap != null && (v = hashMap.get(iRubyElement)) != null) {
            return v;
        }
        return this.cache.peekAtInfo(iRubyElement);
    }

    protected synchronized void putInfos(IRubyElement iRubyElement, Map map) {
        IRubyElement[] iRubyElementArray;
        Object object = this.cache.peekAtInfo(iRubyElement);
        if (iRubyElement instanceof IParent && object instanceof RubyElementInfo) {
            iRubyElementArray = ((RubyElementInfo)object).getChildren();
            int n = 0;
            int n2 = iRubyElementArray.length;
            while (n < n2) {
                RubyElement rubyElement = (RubyElement)iRubyElementArray[n];
                try {
                    rubyElement.close();
                }
                catch (RubyModelException rubyModelException) {}
                ++n;
            }
        }
        iRubyElementArray = map.keySet().iterator();
        while (iRubyElementArray.hasNext()) {
            IRubyElement iRubyElement2 = (IRubyElement)iRubyElementArray.next();
            Object v = map.get(iRubyElement2);
            this.cache.putInfo(iRubyElement2, v);
        }
    }

    public HashMap getTemporaryCache() {
        HashMap hashMap = (HashMap)this.temporaryCache.get();
        if (hashMap == null) {
            hashMap = new HashMap();
            this.temporaryCache.set(hashMap);
        }
        return hashMap;
    }

    public boolean hasTemporaryCache() {
        return this.temporaryCache.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProjectOptions(RubyProject rubyProject) {
        Map map = this.perProjectInfos;
        synchronized (map) {
            IProject iProject = rubyProject.getProject();
            PerProjectInfo perProjectInfo = (PerProjectInfo)this.perProjectInfos.get(iProject);
            if (perProjectInfo != null) {
                perProjectInfo.options = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProjectPreferences(RubyProject rubyProject) {
        Map map = this.perProjectInfos;
        synchronized (map) {
            IProject iProject = rubyProject.getProject();
            PerProjectInfo perProjectInfo = (PerProjectInfo)this.perProjectInfos.get(iProject);
            if (perProjectInfo != null) {
                perProjectInfo.preferences = null;
            }
        }
    }

    public void resetTemporaryCache() {
        this.temporaryCache.set(null);
    }

    public final RubyModel getRubyModel() {
        return this.rubyModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerWorkingCopyInfo getPerWorkingCopyInfo(RubyScript rubyScript, boolean bl, boolean bl2, IProblemRequestor iProblemRequestor) {
        Map map = this.perWorkingCopyInfos;
        synchronized (map) {
            PerWorkingCopyInfo perWorkingCopyInfo;
            WorkingCopyOwner workingCopyOwner = rubyScript.owner;
            HashMap<RubyScript, PerWorkingCopyInfo> hashMap = (HashMap<RubyScript, PerWorkingCopyInfo>)this.perWorkingCopyInfos.get(workingCopyOwner);
            if (hashMap == null && bl) {
                hashMap = new HashMap<RubyScript, PerWorkingCopyInfo>();
                this.perWorkingCopyInfos.put(workingCopyOwner, hashMap);
            }
            PerWorkingCopyInfo perWorkingCopyInfo2 = perWorkingCopyInfo = hashMap == null ? null : (PerWorkingCopyInfo)hashMap.get(rubyScript);
            if (perWorkingCopyInfo == null && bl) {
                perWorkingCopyInfo = new PerWorkingCopyInfo(rubyScript, iProblemRequestor);
                hashMap.put(rubyScript, perWorkingCopyInfo);
            }
            if (perWorkingCopyInfo != null && bl2) {
                ++perWorkingCopyInfo.useCount;
            }
            return perWorkingCopyInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int discardPerWorkingCopyInfo(RubyScript rubyScript) throws RubyModelException {
        PerWorkingCopyInfo perWorkingCopyInfo = null;
        Map map = this.perWorkingCopyInfos;
        synchronized (map) {
            Map map2;
            WorkingCopyOwner workingCopyOwner;
            block9: {
                block8: {
                    workingCopyOwner = rubyScript.owner;
                    map2 = (Map)this.perWorkingCopyInfos.get(workingCopyOwner);
                    if (map2 != null) break block8;
                    return -1;
                }
                perWorkingCopyInfo = (PerWorkingCopyInfo)map2.get(rubyScript);
                if (perWorkingCopyInfo != null) break block9;
                return -1;
            }
            if (--perWorkingCopyInfo.useCount == 0) {
                map2.remove(rubyScript);
                if (map2.isEmpty()) {
                    this.perWorkingCopyInfos.remove(workingCopyOwner);
                }
            }
        }
        if (perWorkingCopyInfo.useCount == 0) {
            this.removeInfoAndChildren(rubyScript);
            rubyScript.closeBuffer();
        }
        return perWorkingCopyInfo.useCount;
    }

    protected Map getElementsOutOfSynchWithBuffers() {
        return this.elementsOutOfSynchWithBuffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerProjectInfo getPerProjectInfo(IProject iProject, boolean bl) {
        Map map = this.perProjectInfos;
        synchronized (map) {
            PerProjectInfo perProjectInfo = (PerProjectInfo)this.perProjectInfos.get(iProject);
            if (perProjectInfo == null && bl) {
                perProjectInfo = new PerProjectInfo(iProject);
                this.perProjectInfos.put(iProject, perProjectInfo);
            }
            return perProjectInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePerProjectInfo(RubyProject rubyProject) {
        Map map = this.perProjectInfos;
        synchronized (map) {
            IProject iProject = rubyProject.getProject();
            PerProjectInfo perProjectInfo = (PerProjectInfo)this.perProjectInfos.get(iProject);
            if (perProjectInfo != null) {
                this.perProjectInfos.remove(iProject);
            }
        }
    }

    public boolean isLoadpathBeingResolved(IRubyProject iRubyProject) {
        return this.getLoadpathBeingResolved().contains(iRubyProject);
    }

    private HashSet getLoadpathBeingResolved() {
        HashSet hashSet = (HashSet)this.classpathsBeingResolved.get();
        if (hashSet == null) {
            hashSet = new HashSet();
            this.classpathsBeingResolved.set(hashSet);
        }
        return hashSet;
    }

    public PerProjectInfo getPerProjectInfoCheckExistence(IProject iProject) throws RubyModelException {
        PerProjectInfo perProjectInfo = this.getPerProjectInfo(iProject, false);
        if (perProjectInfo == null) {
            if (!RubyProject.hasRubyNature(iProject)) {
                throw ((RubyProject)RubyCore.create(iProject)).newNotPresentException();
            }
            perProjectInfo = this.getPerProjectInfo(iProject, true);
        }
        return perProjectInfo;
    }

    public void setLoadpathBeingResolved(IRubyProject iRubyProject, boolean bl) {
        if (bl) {
            this.getLoadpathBeingResolved().add(iRubyProject);
        } else {
            this.getLoadpathBeingResolved().remove(iRubyProject);
        }
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public String getOption(String string) {
        if ("org.rubypeople.rdt.core.encoding".equals(string)) {
            return RubyCore.getEncoding();
        }
        String string2 = string;
        if (this.optionNames.contains(string2)) {
            IPreferencesService iPreferencesService = Platform.getPreferencesService();
            String string3 = iPreferencesService.get(string, null, (Preferences[])this.preferencesLookup);
            return string3 == null ? null : string3.trim();
        }
        return null;
    }

    public Hashtable getOptions() {
        if (this.optionsCache != null) {
            return new Hashtable(this.optionsCache);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(10);
        IPreferencesService iPreferencesService = Platform.getPreferencesService();
        Iterator iterator = this.optionNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = iPreferencesService.get(string, null, (Preferences[])this.preferencesLookup);
            if (string2 == null) continue;
            hashtable.put(string, string2);
        }
        hashtable.put("org.rubypeople.rdt.core.encoding", RubyCore.getEncoding());
        this.optionsCache = new Hashtable(hashtable);
        return hashtable;
    }

    public DeltaProcessor getDeltaProcessor() {
        return this.deltaState.getDeltaProcessor();
    }

    public void startup() throws CoreException {
        try {
            this.configurePluginDebugOptions();
            RubyCore.getPlugin().getStateLocation();
            this.initializePreferences();
            Preferences.IPropertyChangeListener iPropertyChangeListener = new Preferences.IPropertyChangeListener(){

                public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
                    RubyModelManager.this.optionsCache = null;
                }
            };
            RubyCore.getPlugin().getPluginPreferences().addPropertyChangeListener(iPropertyChangeListener);
            Platform.getContentTypeManager().addContentTypeChangeListener((IContentTypeManager.IContentTypeChangeListener)this);
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            iWorkspace.addResourceChangeListener((IResourceChangeListener)this.deltaState, 31);
        }
        catch (RuntimeException runtimeException) {
            this.shutdown();
            throw runtimeException;
        }
    }

    public void shutdown() {
        RubyCore rubyCore = RubyCore.getRubyCore();
        rubyCore.savePluginPreferences();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        iWorkspace.removeResourceChangeListener((IResourceChangeListener)this.deltaState);
        iWorkspace.removeSaveParticipant((Plugin)rubyCore);
        try {
            Platform.getJobManager().join((Object)"org.rubypeople.rdt.core", null);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void configurePluginDebugOptions() {
        if (RubyCore.getPlugin().isDebugging()) {
            String string = Platform.getDebugOption((String)BUFFER_MANAGER_DEBUG);
            if (string != null) {
                BufferManager.VERBOSE = string.equalsIgnoreCase("true");
            }
            if ((string = Platform.getDebugOption((String)BUILDER_DEBUG)) != null) {
                RubyBuilder.DEBUG = string.equalsIgnoreCase("true");
            }
            if ((string = Platform.getDebugOption((String)DELTA_DEBUG)) != null) {
                DeltaProcessor.DEBUG = string.equalsIgnoreCase("true");
            }
            if ((string = Platform.getDebugOption((String)DELTA_DEBUG_VERBOSE)) != null) {
                DeltaProcessor.VERBOSE = string.equalsIgnoreCase("true");
            }
            if ((string = Platform.getDebugOption((String)RUBYMODEL_DEBUG)) != null) {
                verbose = string.equalsIgnoreCase("true");
            }
            if ((string = Platform.getDebugOption((String)POST_ACTION_DEBUG)) != null) {
                RubyModelOperation.POST_ACTION_VERBOSE = string.equalsIgnoreCase("true");
            }
            if (PerformanceStats.ENABLED) {
                DeltaProcessor.PERF = PerformanceStats.isEnabled((String)DELTA_LISTENER_PERF);
                ReconcileWorkingCopyOperation.PERF = PerformanceStats.isEnabled((String)RECONCILE_PERF);
            }
        }
    }

    public void contentTypeChanged(IContentTypeManager.ContentTypeChangeEvent contentTypeChangeEvent) {
        Util.resetRubyLikeExtensions();
    }

    public static IRubyElement create(IResource iResource, IRubyProject iRubyProject) {
        if (iResource == null) {
            return null;
        }
        int n = iResource.getType();
        switch (n) {
            case 4: {
                return RubyCore.create((IProject)iResource);
            }
            case 1: {
                return RubyModelManager.create((IFile)iResource, iRubyProject);
            }
            case 2: {
                return RubyModelManager.create((IResource)((IFolder)iResource), iRubyProject);
            }
            case 8: {
                return RubyCore.create((IWorkspaceRoot)iResource);
            }
        }
        return null;
    }

    public static IRubyElement create(IFile iFile, IRubyProject iRubyProject) {
        String string;
        if (iFile == null) {
            return null;
        }
        if (iRubyProject == null) {
            iRubyProject = RubyCore.create(iFile.getProject());
        }
        if (iFile.getFileExtension() != null && Util.isRubyLikeFileName(string = iFile.getName())) {
            return RubyModelManager.createRubyScriptFrom(iFile, iRubyProject);
        }
        return null;
    }

    public static IRubyElement createRubyScriptFrom(IFile iFile, IRubyProject iRubyProject) {
        if (iFile == null) {
            return null;
        }
        if (iRubyProject == null) {
            iRubyProject = RubyCore.create(iFile.getProject());
        }
        return iRubyProject.getRubyScript(iFile);
    }

    public static class EclipsePreferencesListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent) {
        }
    }

    public static class PerWorkingCopyInfo
    implements IProblemRequestor {
        int useCount = 0;
        IRubyScript workingCopy;
        private IProblemRequestor problemRequestor;

        public PerWorkingCopyInfo(IRubyScript iRubyScript, IProblemRequestor iProblemRequestor) {
            this.workingCopy = iRubyScript;
            this.problemRequestor = iProblemRequestor;
        }

        public IRubyScript getWorkingCopy() {
            return this.workingCopy;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Info for ");
            stringBuffer.append(((RubyElement)((Object)this.workingCopy)).toString());
            stringBuffer.append("\nUse count = ");
            stringBuffer.append(this.useCount);
            stringBuffer.append("\nProblem requestor:\n  ");
            stringBuffer.append(this.problemRequestor);
            return stringBuffer.toString();
        }

        public void acceptProblem(IProblem iProblem) {
            if (this.problemRequestor == null) {
                return;
            }
            this.problemRequestor.acceptProblem(iProblem);
        }

        public void beginReporting() {
            if (this.problemRequestor == null) {
                return;
            }
            this.problemRequestor.beginReporting();
        }

        public void endReporting() {
            if (this.problemRequestor == null) {
                return;
            }
            this.problemRequestor.endReporting();
        }

        public boolean isActive() {
            return this.problemRequestor != null && this.problemRequestor.isActive();
        }
    }

    public static class PerProjectInfo {
        public IProject project;
        public Object savedState = null;
        public boolean triedRead = false;
        public ILoadpathEntry[] rawClasspath;
        public ILoadpathEntry[] resolvedClasspath;
        public Map resolvedPathToRawEntries;
        public IPath outputLocation;
        public IEclipsePreferences preferences;
        public Hashtable options;

        public PerProjectInfo(IProject iProject) {
            this.project = iProject;
        }

        public synchronized void updateClasspathInformation(ILoadpathEntry[] iLoadpathEntryArray) {
            this.rawClasspath = iLoadpathEntryArray;
            this.resolvedClasspath = null;
            this.resolvedPathToRawEntries = null;
        }

        public String toString() {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Info for ");
            stringBuffer.append(this.project.getFullPath());
            stringBuffer.append("\nRaw classpath:\n");
            if (this.rawClasspath == null) {
                stringBuffer.append("  <null>\n");
            } else {
                int n2 = 0;
                n = this.rawClasspath.length;
                while (n2 < n) {
                    stringBuffer.append("  ");
                    stringBuffer.append(this.rawClasspath[n2]);
                    stringBuffer.append('\n');
                    ++n2;
                }
            }
            stringBuffer.append("Resolved classpath:\n");
            ILoadpathEntry[] iLoadpathEntryArray = this.resolvedClasspath;
            if (iLoadpathEntryArray == null) {
                stringBuffer.append("  <null>\n");
            } else {
                n = 0;
                int n3 = iLoadpathEntryArray.length;
                while (n < n3) {
                    stringBuffer.append("  ");
                    stringBuffer.append(iLoadpathEntryArray[n]);
                    stringBuffer.append('\n');
                    ++n;
                }
            }
            stringBuffer.append("Output location:\n  ");
            if (this.outputLocation == null) {
                stringBuffer.append("<null>");
            } else {
                stringBuffer.append(this.outputLocation);
            }
            return stringBuffer.toString();
        }
    }
}

