/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby;

import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.rubypeople.rdt.internal.corext.util.CodeFormatterUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;

public class RubyFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList fDocuments = new LinkedList();
    private final LinkedList fPartitions = new LinkedList();

    public void format() {
        super.format();
        IDocument iDocument = (IDocument)this.fDocuments.removeFirst();
        TypedPosition typedPosition = (TypedPosition)this.fPartitions.removeFirst();
        if (iDocument != null && typedPosition != null) {
            try {
                TextEdit textEdit = CodeFormatterUtil.format2(8, iDocument.get(), typedPosition.getOffset(), typedPosition.getLength(), 0, TextUtilities.getDefaultLineDelimiter((IDocument)iDocument), this.getPreferences());
                if (textEdit != null) {
                    Map map = null;
                    if (textEdit.getChildrenSize() > 20) {
                        map = TextUtilities.removeDocumentPartitioners((IDocument)iDocument);
                    }
                    textEdit.apply(iDocument);
                    if (map != null) {
                        TextUtilities.addDocumentPartitioners((IDocument)iDocument, (Map)map);
                    }
                }
            }
            catch (MalformedTreeException malformedTreeException) {
                RubyPlugin.log(malformedTreeException);
            }
            catch (BadLocationException badLocationException) {
                RubyPlugin.log(badLocationException);
            }
        }
    }

    public void formatterStarts(IFormattingContext iFormattingContext) {
        super.formatterStarts(iFormattingContext);
        this.fPartitions.addLast(iFormattingContext.getProperty((Object)"formatting.context.partition"));
        this.fDocuments.addLast(iFormattingContext.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        super.formatterStops();
        this.fPartitions.clear();
        this.fDocuments.clear();
    }
}

