/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.repository.sftp;

import fr.jayasoft.ivy.repository.Resource;
import fr.jayasoft.ivy.repository.sftp.SFTPRepository;
import java.io.IOException;
import java.io.InputStream;

public class SFTPResource
implements Resource {
    private SFTPRepository _repository;
    private String _path;
    private transient boolean _init = false;
    private transient boolean _exists;
    private transient long _lastModified;
    private transient long _contentLength;

    public SFTPResource(SFTPRepository repository, String path) {
        this._repository = repository;
        this._path = path;
    }

    public String getName() {
        return this._path;
    }

    public Resource clone(String cloneName) {
        return new SFTPResource(this._repository, cloneName);
    }

    public long getLastModified() {
        this.init();
        return this._lastModified;
    }

    public long getContentLength() {
        this.init();
        return this._contentLength;
    }

    public boolean exists() {
        this.init();
        return this._exists;
    }

    private void init() {
        if (!this._init) {
            Resource r = this._repository.resolveResource(this._path);
            this._contentLength = r.getContentLength();
            this._lastModified = r.getLastModified();
            this._exists = r.exists();
            this._init = true;
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean isLocal() {
        return false;
    }

    public InputStream openStream() throws IOException {
        return this._repository.openStream(this);
    }
}

