/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.EdgeTypes;
import edu.umd.cs.findbugs.ba.type.ExceptionSet;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.bcel.Repository;
import org.apache.bcel.generic.MethodGen;

public class PruneInfeasibleExceptionEdges
implements EdgeTypes {
    private static final boolean DEBUG = SystemProperties.getBoolean("cfg.prune.debug");
    private static final boolean STATS = SystemProperties.getBoolean("cfg.prune.stats");
    private static int numEdgesPruned = 0;
    private CFG cfg;
    private TypeDataflow typeDataflow;
    private boolean cfgModified;

    public PruneInfeasibleExceptionEdges(CFG cfg, MethodGen methodGen, TypeDataflow typeDataflow) {
        this.cfg = cfg;
        this.typeDataflow = typeDataflow;
    }

    public void execute() throws ClassNotFoundException {
        Edge edge;
        HashSet<Edge> deletedEdgeSet = new HashSet<Edge>();
        LinkedList<MarkedEdge> markedEdgeList = new LinkedList<MarkedEdge>();
        Iterator i = this.cfg.edgeIterator();
        while (i.hasNext()) {
            String className;
            edge = (Edge)i.next();
            if (!edge.isExceptionEdge()) continue;
            ExceptionSet exceptionSet = this.typeDataflow.getEdgeExceptionSet(edge);
            if (exceptionSet.isEmpty()) {
                deletedEdgeSet.add(edge);
                continue;
            }
            if (exceptionSet.isSingleton("java.lang.CloneNotSupportedException") && this.cfg.getMethodName().endsWith(".clone()") && Repository.implementationOf(className = this.cfg.getMethodGen().getClassName(), "java.lang.Cloneable")) {
                deletedEdgeSet.add(edge);
                continue;
            }
            boolean someChecked = exceptionSet.containsCheckedExceptions();
            boolean someExplicit = exceptionSet.containsExplicitExceptions();
            int flags = 0;
            if (someChecked) {
                flags |= 1;
            }
            if (someExplicit) {
                flags |= 2;
            }
            markedEdgeList.add(new MarkedEdge(edge, flags));
        }
        Iterator i$ = deletedEdgeSet.iterator();
        while (i$.hasNext()) {
            edge = (Edge)i$.next();
            this.cfg.removeEdge(edge);
            if (STATS) {
                ++numEdgesPruned;
            }
            this.cfgModified = true;
        }
        i$ = markedEdgeList.iterator();
        while (i$.hasNext()) {
            MarkedEdge markedEdge = (MarkedEdge)i$.next();
            markedEdge.apply();
        }
    }

    public boolean wasCFGModified() {
        return this.cfgModified;
    }

    static {
        if (STATS) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    System.err.println("Exception edges pruned: " + numEdgesPruned);
                }
            });
        }
    }

    private static class MarkedEdge {
        private Edge edge;
        private int flag;

        public MarkedEdge(Edge edge, int flag) {
            this.edge = edge;
            this.flag = flag;
        }

        public void apply() {
            int flags = this.edge.getFlags();
            this.edge.setFlags(flags |= this.flag);
        }
    }
}

