/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors.perl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IDocument;
import org.epic.core.model.ISourceElement;

public class SourceParser {
    public static final Pattern COMMENT_PATTERN = Pattern.compile("#.*?$", 40);
    public static final Pattern POD_PATTERN = Pattern.compile("^=[^c]?[^u]?[^t]?.*?$\\r?\\n?^.*?$*^=cut$\\r?\\n?", 40);
    public static final int DO_NOT_DELETE_COMMENT_POD = 0;
    public static final int DELETE_COMMENT = 1;
    public static final int DELETE_POD = 2;

    public static List getElements(IDocument document, String regexp, String preFix, String postFix, boolean deleteComments) {
        return SourceParser.getElements(document.get(), regexp, preFix, postFix, deleteComments);
    }

    public static List getElements(String text, String regexp, String preFix, String postFix, boolean deleteComments) {
        return SourceParser.getElements(text, regexp, preFix, postFix, deleteComments ? 3 : 0);
    }

    public static List getElements(String text, String regexp, String preFix, String postFix, int flags) {
        text = SourceParser.blankPODAndComments(text, (flags & 2) == 2, (flags & 1) == 1);
        Pattern p = Pattern.compile(regexp, 40);
        Matcher m = p.matcher(text);
        ArrayList<SourceElement> results = new ArrayList<SourceElement>();
        while (m.find()) {
            int end;
            int start;
            if (m.groupCount() > 0) {
                start = m.start(1);
                end = m.end(1);
            } else {
                start = m.start();
                end = m.end();
            }
            StringBuffer buf = new StringBuffer();
            buf.append(preFix);
            buf.append(text.substring(start, end));
            buf.append(postFix);
            results.add(new SourceElement(buf.toString(), start, end - start));
        }
        return results;
    }

    private static void blankCharRange(char[] text, int start, int end) {
        int i = start;
        while (i < end) {
            text[i] = 32;
            ++i;
        }
    }

    private static String blankPODAndComments(String text, boolean blankPOD, boolean blankComments) {
        Matcher m;
        if (!blankPOD && !blankComments) {
            return text;
        }
        char[] textChars = text.toCharArray();
        if (blankPOD) {
            m = POD_PATTERN.matcher(text);
            while (m.find()) {
                SourceParser.blankCharRange(textChars, m.start(), m.end());
            }
        }
        if (blankComments) {
            m = COMMENT_PATTERN.matcher(text);
            while (m.find()) {
                SourceParser.blankCharRange(textChars, m.start(), m.end());
            }
        }
        return String.valueOf(textChars);
    }

    private static class SourceElement
    implements ISourceElement {
        private final String name;
        private final int offset;
        private final int length;

        public SourceElement(String name, int offset, int length) {
            this.name = name;
            this.offset = offset;
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        public String getName() {
            return this.name;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

