/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.etl.PLExport;
import ca.sqlpower.architect.etl.PLUtils;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingWorker;
import ca.sqlpower.architect.swingui.PLExportXMLPanel;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.ProgressWatcher;
import ca.sqlpower.architect.swingui.QuickStartWizard;
import ca.sqlpower.architect.swingui.WizardDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;

public class ExportPLJobXMLAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(ExportPLJobXMLAction.class);
    protected ArchitectFrame architectFrame = ArchitectFrame.getMainInstance();
    protected PlayPen pp;
    protected PLExport plexp;
    protected JDialog d;
    protected JProgressBar plCreateTxProgressBar;
    protected JLabel plCreateTxLabel;

    public ExportPLJobXMLAction() {
        super("PL XML Script Export...", ASUtils.createIcon("PLTransExport", "PL XML Script Export", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 24)));
        this.putValue("ShortDescription", "PL XML Script Export");
    }

    public synchronized void setupDialog() {
        logger.debug((Object)"running setupDialog()");
        if (this.plexp == null) {
            throw new NullPointerException("setupDialog: plexp was null");
        }
        this.d = new JDialog((Frame)ArchitectFrame.getMainInstance(), "Export ETL Transactions to XML script");
        if (this.plexp.getFolderName() == null || this.plexp.getFolderName().trim().length() == 0) {
            this.plexp.setFolderName(PLUtils.toPLIdentifier(this.architectFrame.getProject().getName() + "_FOLDER"));
        }
        if (this.plexp.getJobId() == null || this.plexp.getJobId().trim().length() == 0) {
            this.plexp.setJobId(PLUtils.toPLIdentifier(this.architectFrame.getProject().getName() + "_JOB"));
        }
        JPanel plp = new JPanel(new BorderLayout(12, 12));
        plp.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        final PLExportXMLPanel plPanel = new PLExportXMLPanel();
        plPanel.setPLExport(this.plexp);
        plp.add((Component)plPanel, "Center");
        JPanel bottomPanel = new JPanel(new GridLayout(1, 2, 25, 0));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (!plPanel.applyChanges()) {
                    return;
                }
                try {
                    List<SQLTable> targetTables = ExportPLJobXMLAction.this.pp.getTables();
                    ExportTxProcess etp = new ExportTxProcess(ExportPLJobXMLAction.this.plexp, targetTables, ExportPLJobXMLAction.this.d, ExportPLJobXMLAction.this.plCreateTxProgressBar, ExportPLJobXMLAction.this.plCreateTxLabel);
                    new Thread(etp).start();
                }
                catch (ArchitectException e) {
                    e.printStackTrace();
                }
            }
        });
        buttonPanel.add(okButton);
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                plPanel.discardChanges();
                ExportPLJobXMLAction.this.d.setVisible(false);
            }
        };
        cancelAction.putValue("Name", "Cancel");
        ASUtils.makeJDialogCancellable(this.d, cancelAction);
        this.d.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton(cancelAction);
        buttonPanel.add(cancelButton);
        JPanel progressPanel = new JPanel(new FlowLayout(0));
        this.plCreateTxProgressBar = new JProgressBar();
        this.plCreateTxProgressBar.setStringPainted(true);
        progressPanel.add(this.plCreateTxProgressBar);
        this.plCreateTxLabel = new JLabel("Exporting PL Transactions...");
        progressPanel.add(this.plCreateTxLabel);
        progressPanel.setPreferredSize(progressPanel.getPreferredSize());
        this.plCreateTxProgressBar.setVisible(false);
        this.plCreateTxLabel.setVisible(false);
        bottomPanel.add(progressPanel);
        bottomPanel.add(buttonPanel);
        plp.add((Component)bottomPanel, "South");
        this.d.setContentPane(plp);
        this.d.pack();
        this.d.setLocationRelativeTo(ArchitectFrame.getMainInstance());
    }

    public void actionPerformed(ActionEvent e) {
        this.plexp = this.architectFrame.getProject().getPLExport();
        this.setupDialog();
        this.d.setVisible(true);
    }

    public void setPlayPen(PlayPen pp) {
        this.pp = pp;
    }

    public class ExportTxProcess
    extends ArchitectSwingWorker {
        PLExport plExport;
        final JDialog d;
        private Runnable nextProcess;
        List targetTables;

        public ExportTxProcess(PLExport plExport, List targetTables, JDialog parentDialog, JProgressBar progressBar, JLabel label) {
            this.plExport = plExport;
            this.targetTables = targetTables;
            this.d = parentDialog;
            label.setText("Exporting Meta Data...");
            new ProgressWatcher(progressBar, plExport, label);
        }

        public void doStuff() {
            if (this.isCanceled()) {
                return;
            }
            try {
                this.plExport.exportXML(this.targetTables);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ArchitectException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void cleanup() throws Exception {
            if (!(this.d instanceof WizardDialog)) {
                this.d.setVisible(false);
            } else {
                if (this.nextProcess != null) {
                    new Thread(this.nextProcess).start();
                }
                WizardDialog wd = (WizardDialog)this.d;
                ((QuickStartWizard)wd.getWizard()).UpdateTextArea();
            }
        }
    }
}

