/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class PlatformSpecificConnectionOptionPanel {
    private static Logger logger = Logger.getLogger(PlatformSpecificConnectionOptionPanel.class);
    private JDBCURLUpdater urlUpdater = new JDBCURLUpdater();
    private boolean updatingUrlFromFields = false;
    private boolean updatingFieldsFromUrl = false;
    private JTextField dbUrlField;
    private JPanel platformSpecificOptionPanel = new JPanel();
    private String template;

    public PlatformSpecificConnectionOptionPanel(JTextField dbUrlField) {
        this.platformSpecificOptionPanel.setLayout(new PlatformOptionsLayout());
        this.platformSpecificOptionPanel.setBorder(BorderFactory.createEmptyBorder());
        this.platformSpecificOptionPanel.add(new JLabel("(No options for current driver)"));
        this.dbUrlField = dbUrlField;
        dbUrlField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                PlatformSpecificConnectionOptionPanel.this.updateFieldsFromUrl();
            }

            public void removeUpdate(DocumentEvent e) {
                PlatformSpecificConnectionOptionPanel.this.updateFieldsFromUrl();
            }

            public void changedUpdate(DocumentEvent e) {
                PlatformSpecificConnectionOptionPanel.this.updateFieldsFromUrl();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUrlFromFields() {
        if (this.updatingFieldsFromUrl) {
            return;
        }
        if (this.template == null) {
            return;
        }
        try {
            this.updatingUrlFromFields = true;
            StringBuffer newUrl = new StringBuffer();
            Pattern p = Pattern.compile("<(.*?)>");
            Matcher m = p.matcher(this.template);
            while (m.find()) {
                String varName = m.group(1);
                if (varName.indexOf(58) != -1) {
                    varName = varName.substring(0, varName.indexOf(58));
                }
                String varValue = this.getPlatformSpecificFieldValue(varName);
                m.appendReplacement(newUrl, varValue);
            }
            m.appendTail(newUrl);
            this.dbUrlField.setText(newUrl.toString());
        }
        finally {
            this.updatingUrlFromFields = false;
        }
    }

    private String getPlatformSpecificFieldValue(String varName) {
        for (int i = 0; i < this.platformSpecificOptionPanel.getComponentCount(); ++i) {
            if (!(this.platformSpecificOptionPanel.getComponent(i) instanceof JLabel) || !((JLabel)this.platformSpecificOptionPanel.getComponent(i)).getText().equals(varName) || this.platformSpecificOptionPanel.getComponentCount() < i + 1) continue;
            return ((JTextField)this.platformSpecificOptionPanel.getComponent(i + 1)).getText();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFieldsFromUrl() {
        if (this.updatingUrlFromFields) {
            return;
        }
        try {
            this.updatingFieldsFromUrl = true;
            for (int i = 0; i < this.platformSpecificOptionPanel.getComponentCount(); ++i) {
                this.platformSpecificOptionPanel.getComponent(i).setEnabled(true);
            }
            logger.debug((Object)("Updating based on template " + this.template));
            if (this.template == null) {
                return;
            }
            String reTemplate = this.template.replaceAll("<.*?>", "(.*)");
            logger.debug((Object)("Regex of template is " + reTemplate));
            Pattern p = Pattern.compile(reTemplate);
            Matcher m = p.matcher(this.dbUrlField.getText());
            if (m.find()) {
                this.platformSpecificOptionPanel.setEnabled(true);
                for (int g = 1; g <= m.groupCount(); ++g) {
                    ((JTextField)this.platformSpecificOptionPanel.getComponent(2 * g - 1)).setText(m.group(g));
                }
            } else {
                for (int i = 0; i < this.platformSpecificOptionPanel.getComponentCount(); ++i) {
                    this.platformSpecificOptionPanel.getComponent(i).setEnabled(false);
                }
            }
        }
        finally {
            this.updatingFieldsFromUrl = false;
        }
    }

    private void createFieldsFromTemplate() {
        for (int i = 0; i < this.platformSpecificOptionPanel.getComponentCount(); ++i) {
            Component c = this.platformSpecificOptionPanel.getComponent(i);
            if (!(c instanceof JTextField)) continue;
            ((JTextField)c).getDocument().removeDocumentListener(this.urlUpdater);
        }
        this.platformSpecificOptionPanel.removeAll();
        if (this.template != null) {
            Pattern varPattern = Pattern.compile("<(.*?)>");
            Matcher varMatcher = varPattern.matcher(this.template);
            ArrayList<String> templateVars = new ArrayList<String>();
            while (varMatcher.find()) {
                templateVars.add(varMatcher.group(1));
            }
            for (String var : templateVars) {
                String def = "";
                if (var.indexOf(58) != -1) {
                    int i = var.indexOf(58);
                    def = var.substring(i + 1);
                    var = var.substring(0, i);
                }
                this.platformSpecificOptionPanel.add(new JLabel(var));
                JTextField field = new JTextField(def);
                this.platformSpecificOptionPanel.add(field);
                field.getDocument().addDocumentListener(this.urlUpdater);
            }
        } else {
            this.platformSpecificOptionPanel.add(new JLabel("Unknown driver class.  Fill in URL manually."));
        }
        this.platformSpecificOptionPanel.revalidate();
        this.platformSpecificOptionPanel.repaint();
    }

    public JPanel getPanel() {
        return this.platformSpecificOptionPanel;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
        this.createFieldsFromTemplate();
        this.updateUrlFromFields();
    }

    private static class PlatformOptionsLayout
    implements LayoutManager {
        int preLabelGap = 10;
        int gap = 5;

        private PlatformOptionsLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            int height = 0;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Component c = parent.getComponent(i);
                height = Math.max(height, c.getPreferredSize().height);
            }
            return new Dimension(parent.getWidth(), height);
        }

        public Dimension minimumLayoutSize(Container parent) {
            int height = 0;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Component c = parent.getComponent(i);
                height = Math.max(height, c.getMinimumSize().height);
            }
            return new Dimension(parent.getWidth(), height);
        }

        public void layoutContainer(Container parent) {
            int labelSize = 0;
            int labelCount = 0;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Component c = parent.getComponent(i);
                if (!(c instanceof JLabel)) continue;
                if (i > 0) {
                    labelSize += this.preLabelGap;
                }
                labelSize += c.getPreferredSize().width;
                ++labelCount;
            }
            int gapSize = this.gap * (parent.getComponentCount() - 1);
            int nonLabelWidth = 0;
            if (parent.getComponentCount() != labelCount) {
                nonLabelWidth = (parent.getWidth() - labelSize - gapSize) / (parent.getComponentCount() - labelCount);
            }
            if (nonLabelWidth < 20) {
                nonLabelWidth = 20;
            }
            int x = 0;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Component c = parent.getComponent(i);
                if (i > 0) {
                    x += this.gap;
                }
                if (c instanceof JLabel) {
                    if (i > 0) {
                        x += this.preLabelGap;
                    }
                    c.setBounds(x, 0, c.getPreferredSize().width, parent.getHeight());
                    x += c.getPreferredSize().width;
                    continue;
                }
                c.setBounds(x, 0, nonLabelWidth, parent.getHeight());
                x += nonLabelWidth;
            }
        }
    }

    private class JDBCURLUpdater
    implements DocumentListener {
        private JDBCURLUpdater() {
        }

        public void insertUpdate(DocumentEvent e) {
            PlatformSpecificConnectionOptionPanel.this.updateUrlFromFields();
        }

        public void removeUpdate(DocumentEvent e) {
            PlatformSpecificConnectionOptionPanel.this.updateUrlFromFields();
        }

        public void changedUpdate(DocumentEvent e) {
            PlatformSpecificConnectionOptionPanel.this.updateUrlFromFields();
        }
    }
}

