/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.etl.PLExport;
import ca.sqlpower.architect.etl.PLUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectPanel;
import ca.sqlpower.architect.swingui.DatabaseSelector;
import ca.sqlpower.architect.swingui.TextPanel;
import ca.sqlpower.architect.swingui.event.DatabaseComboBoxListener;
import ca.sqlpower.sql.SQL;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class PLExportPanel
extends JPanel
implements ArchitectPanel {
    private static final Logger logger = Logger.getLogger(PLExportPanel.class);
    protected PLExport plexp;
    protected DatabaseComboBoxListener dcl;
    protected DatabaseSelector target;
    protected DatabaseSelector repository;
    private JProgressBar progressBar;
    private JLabel label;
    protected JTextField plFolderName;
    protected JTextField plJobId;
    protected JTextField plJobDescription;
    protected JTextField plJobComment;
    private JCheckBox runPLEngine;
    protected Timer timer;
    protected String plDotIniPath;
    protected TextPanel mainForm;

    public PLExportPanel() {
        ArchitectFrame af = ArchitectFrame.getMainInstance();
        this.plDotIniPath = af.getUserSettings().getPlDotIniPath();
        this.progressBar = new JProgressBar();
        this.label = new JLabel();
        this.label.setText("Loading Database.....");
        this.progressBar.setVisible(false);
        this.label.setVisible(false);
        this.target = new DatabaseSelector(this.progressBar, this.label, this.getPanel());
        this.repository = new DatabaseSelector(this.progressBar, this.label, this.getPanel());
        this.plFolderName = new JTextField();
        this.plJobId = new JTextField();
        this.plJobDescription = new JTextField();
        this.plJobComment = new JTextField();
        this.runPLEngine = new JCheckBox("Run PL Engine?");
        FormLayout layout = new FormLayout("10dlu, 80dlu,10dlu, 5dlu,fill:100dlu:grow, 10dlu, 40dlu,30dlu", "4dlu, 20dlu, 1dlu, 20dlu, 1dlu, 20dlu, 4dlu, 20dlu,1dlu, 20dlu, 1dlu, 20dlu,4dlu, 20dlu, 1dlu, 20dlu, 1dlu, 20dlu, 1dlu, 20dlu,4dlu, 20dlu,4dlu, 20dlu");
        PanelBuilder pb = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        pb.add((Component)new JLabel("Target Connection"), cc.xy(2, 2, "r,c"));
        pb.add((Component)this.target.getConnectionsBox(), cc.xyw(4, 2, 2));
        pb.add((Component)this.target.getNewButton(), cc.xy(7, 2));
        pb.add((Component)new JLabel("Target Catalog"), cc.xy(2, 4, "r,c"));
        pb.add((Component)this.target.getCatalogBox(), cc.xyw(4, 4, 2));
        pb.add((Component)new JLabel("Target Schema"), cc.xy(2, 6, "r,c"));
        pb.add((Component)this.target.getSchemaBox(), cc.xyw(4, 6, 2));
        pb.add((Component)new JLabel("Repository Connection"), cc.xy(2, 8, "r,c"));
        pb.add((Component)this.repository.getConnectionsBox(), cc.xyw(4, 8, 2));
        pb.add((Component)this.repository.getNewButton(), cc.xy(7, 8));
        pb.add((Component)new JLabel("Repository Catalog"), cc.xy(2, 10, "r,c"));
        pb.add((Component)this.repository.getCatalogBox(), cc.xyw(4, 10, 2));
        pb.add((Component)new JLabel("Repository Schema"), cc.xy(2, 12, "r,c"));
        pb.add((Component)this.repository.getSchemaBox(), cc.xyw(4, 12, 2));
        pb.add((Component)new JLabel("PL Folder Name"), cc.xy(2, 14, "r,c"));
        pb.add((Component)this.plFolderName, cc.xyw(4, 14, 2));
        pb.add((Component)new JLabel("PL Job Id"), cc.xy(2, 16, "r,c"));
        pb.add((Component)this.plJobId, cc.xyw(4, 16, 2));
        pb.add((Component)new JLabel("PL Job Description"), cc.xy(2, 18, "r,c"));
        pb.add((Component)this.plJobDescription, cc.xyw(4, 18, 2));
        pb.add((Component)new JLabel("PL Job Comment"), cc.xy(2, 20, "r,c"));
        pb.add((Component)this.plJobComment, cc.xyw(4, 20, 2));
        pb.add((Component)this.runPLEngine, cc.xyw(4, 22, 2));
        pb.add((Component)this.label, cc.xy(2, 24, "r,c"));
        pb.add((Component)this.progressBar, cc.xyw(4, 24, 2));
        this.add(pb.getPanel());
    }

    public void setPLExport(PLExport plexp) {
        logger.debug((Object)("Got new PLExport Object.  Updating the GUI elements...." + plexp));
        this.plexp = plexp;
        this.target.getConnectionsBox().setSelectedItem(plexp.getTargetDataSource());
        this.repository.getConnectionsBox().setSelectedItem(plexp.getRepositoryDataSource());
        this.plFolderName.setText(plexp.getFolderName());
        this.plJobId.setText(plexp.getJobId());
        this.plJobDescription.setText(plexp.getJobDescription());
        this.plJobComment.setText(plexp.getJobComment());
    }

    public boolean applyChanges() {
        String plEngineSpec;
        logger.debug((Object)"Applying changes to the PLExport object");
        this.plexp.setTargetDataSource((ArchitectDataSource)this.target.getConnectionsBox().getSelectedItem());
        this.plexp.setRepositoryDataSource((ArchitectDataSource)this.repository.getConnectionsBox().getSelectedItem());
        if (this.target.getSchemaBox().isEnabled()) {
            this.plexp.setTargetSchema(this.target.getSchemaBox().getSelectedItem().toString());
        }
        if (this.repository.getSchemaBox().isEnabled()) {
            this.plexp.setRepositorySchema(this.repository.getSchemaBox().getSelectedItem().toString());
        }
        if (this.target.getCatalogBox().isEnabled()) {
            this.plexp.setTargetCatalog(this.target.getCatalogBox().getSelectedItem().toString());
        }
        if (this.repository.getCatalogBox().isEnabled()) {
            this.plexp.setRepositoryCatalog(this.repository.getCatalogBox().getSelectedItem().toString());
        }
        this.plJobId.setText(PLUtils.toPLIdentifier(this.plJobId.getText()));
        this.plexp.setJobId(this.plJobId.getText());
        this.plFolderName.setText(PLUtils.toPLIdentifier(this.plFolderName.getText()));
        this.plexp.setFolderName(this.plFolderName.getText());
        this.plexp.setJobDescription(this.plJobDescription.getText());
        this.plexp.setJobComment(this.plJobComment.getText());
        this.plexp.setRunPLEngine(this.runPLEngine.isSelected());
        if (this.plexp.getTargetDataSource() == null) {
            JOptionPane.showMessageDialog(this, "You have to select a Target database from the list.", "Error", 0);
            return false;
        }
        if (this.plexp.getRepositoryDataSource() == null) {
            JOptionPane.showMessageDialog(this, "You have to select a Repository database from the list.", "Error", 0);
            return false;
        }
        if (this.plexp.getJobId().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "You have to specify the PowerLoader Job ID.", "Error", 0);
            return false;
        }
        if (this.plexp.getRunPLEngine() && ((plEngineSpec = ArchitectFrame.getMainInstance().getUserSettings().getETLUserSettings().getString("ETLUserSettings.PROP_PL_ENGINE_PATH", "")) == null || plEngineSpec.length() == 0)) {
            JOptionPane.showMessageDialog(this, "Please specify the location of the PL Engine (powerloader_odbc.exe).");
            ArchitectFrame.getMainInstance().prefAction.showPreferencesDialog();
            return false;
        }
        String dupIdMessage = null;
        try {
            if (PLExportPanel.checkForDuplicateJobId(this.plexp)) {
                dupIdMessage = "There is already a job called \"" + this.plexp.getJobId() + "\".\n" + "Please choose a different job id.";
            }
        }
        catch (SQLException ex) {
            dupIdMessage = "There was a database error when checking for\nduplicate job id:\n\n" + ex.getMessage();
        }
        catch (ArchitectException ex) {
            dupIdMessage = "There was an application error when checking for\nduplicate job id:\n\n" + ex.getMessage();
        }
        if (dupIdMessage != null) {
            JOptionPane.showMessageDialog(this, dupIdMessage, "Error", 0);
            return false;
        }
        return true;
    }

    public void discardChanges() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForDuplicateJobId(PLExport plExport) throws SQLException, ArchitectException {
        SQLException se22;
        int count;
        Statement s;
        Connection con;
        block17: {
            SQLDatabase target = new SQLDatabase(plExport.getRepositoryDataSource());
            con = null;
            s = null;
            ResultSet rs = null;
            count = 0;
            try {
                con = target.getConnection();
                s = con.createStatement();
                rs = s.executeQuery("SELECT COUNT(*) FROM pl_job WHERE job_id = " + SQL.quote((String)plExport.getJobId().toUpperCase()));
                if (rs.next()) {
                    count = rs.getInt(1);
                }
                Object var7_6 = null;
                if (rs == null) break block17;
            }
            catch (Throwable throwable) {
                SQLException se22;
                Object var7_7 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException se22) {
                        logger.error((Object)"problem closing result set.", (Throwable)se22);
                    }
                }
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (SQLException se22) {
                        logger.error((Object)"problem closing statement.", (Throwable)se22);
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException se22) {
                        logger.error((Object)"problem closing connection.", (Throwable)se22);
                    }
                }
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException se22) {
                logger.error((Object)"problem closing result set.", (Throwable)se22);
            }
        }
        if (s != null) {
            try {
                s.close();
            }
            catch (SQLException se22) {
                logger.error((Object)"problem closing statement.", (Throwable)se22);
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException se22) {
                logger.error((Object)"problem closing connection.", (Throwable)se22);
            }
        }
        return count != 0;
    }

    public JPanel getPanel() {
        return this;
    }

    public class EditTargetListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
        }
    }

    public class EditRepositoryListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
        }
    }
}

