/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile;

import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ProfileColumn;
import ca.sqlpower.architect.profile.ProfileFormat;
import ca.sqlpower.architect.profile.ProfileResult;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.swingui.table.DateTableCellRenderer;
import ca.sqlpower.architect.swingui.table.DecimalTableCellRenderer;
import ca.sqlpower.architect.swingui.table.PercentTableCellRenderer;
import com.darwinsys.csv.CSVExport;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileCSVFormat
implements ProfileFormat {
    @Override
    public void format(OutputStream nout, List<ProfileResult> profileResult) throws Exception {
        PrintWriter out = new PrintWriter(nout);
        ProfileColumn[] columns = ProfileColumn.values();
        out.println(CSVExport.toString(Arrays.asList(columns)));
        Format dateFormat = new DateTableCellRenderer().getFormat();
        Format decFormat = new DecimalTableCellRenderer().getFormat();
        Format pctFormat = new PercentTableCellRenderer().getFormat();
        for (ProfileResult result : profileResult) {
            if (!(result instanceof ColumnProfileResult)) continue;
            SQLColumn c = (SQLColumn)result.getProfiledObject();
            SQLTable t = c.getParentTable();
            TableProfileResult tpr = ((ColumnProfileResult)result).getParentResult();
            ArrayList<Object> commonData = new ArrayList<Object>();
            block22: for (ProfileColumn pc : columns) {
                switch (pc) {
                    case DATABASE: {
                        commonData.add(t.getParentDatabase().getName());
                        continue block22;
                    }
                    case CATALOG: {
                        commonData.add(t.getCatalog() != null ? t.getCatalog().getName() : "");
                        continue block22;
                    }
                    case SCHEMA: {
                        commonData.add(t.getSchema() != null ? t.getSchema().getName() : "");
                        continue block22;
                    }
                    case TABLE: {
                        commonData.add(t.getName());
                        continue block22;
                    }
                    case COLUMN: {
                        commonData.add(c.getName());
                        continue block22;
                    }
                    case RUNDATE: {
                        Date date = new Date(tpr.getCreateStartTime());
                        commonData.add(dateFormat.format(date));
                        continue block22;
                    }
                    case RECORD_COUNT: {
                        commonData.add(tpr.getRowCount());
                        continue block22;
                    }
                    case DATA_TYPE: {
                        commonData.add(c.getType());
                        continue block22;
                    }
                    case NULL_COUNT: {
                        commonData.add(((ColumnProfileResult)result).getNullCount());
                        continue block22;
                    }
                    case PERCENT_NULL: {
                        if (tpr.getRowCount() == 0) {
                            commonData.add("n/a");
                            continue block22;
                        }
                        commonData.add(pctFormat.format((double)((ColumnProfileResult)result).getNullCount() / (double)tpr.getRowCount()));
                        continue block22;
                    }
                    case UNIQUE_COUNT: {
                        commonData.add(((ColumnProfileResult)result).getDistinctValueCount());
                        continue block22;
                    }
                    case PERCENT_UNIQUE: {
                        if (tpr.getRowCount() == 0) {
                            commonData.add("n/a");
                            continue block22;
                        }
                        commonData.add(pctFormat.format((double)((ColumnProfileResult)result).getDistinctValueCount() / (double)tpr.getRowCount()));
                        continue block22;
                    }
                    case MIN_LENGTH: {
                        commonData.add(((ColumnProfileResult)result).getMinLength());
                        continue block22;
                    }
                    case MAX_LENGTH: {
                        commonData.add(((ColumnProfileResult)result).getMaxLength());
                        continue block22;
                    }
                    case AVERAGE_LENGTH: {
                        commonData.add(decFormat.format(((ColumnProfileResult)result).getAvgLength()));
                        continue block22;
                    }
                    case MIN_VALUE: {
                        commonData.add(((ColumnProfileResult)result).getMinValue());
                        continue block22;
                    }
                    case MAX_VALUE: {
                        commonData.add(((ColumnProfileResult)result).getMaxValue());
                        continue block22;
                    }
                    case AVERAGE_VALUE: {
                        Object value = ((ColumnProfileResult)result).getAvgValue();
                        String formattedValue = value == null ? "" : (value instanceof Number ? decFormat.format(value) : value.toString());
                        commonData.add(formattedValue);
                        continue block22;
                    }
                    case TOP_VALUE: {
                        commonData.add("");
                        continue block22;
                    }
                    default: {
                        throw new IllegalStateException("Need code to handle this column!");
                    }
                }
            }
            out.println(CSVExport.toString(commonData));
        }
        out.close();
    }
}

