/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.jdbc;

import ca.sqlpower.architect.jdbc.ConnectionDecorator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class StatementDecorator
implements Statement {
    private Statement stmt;
    private ConnectionDecorator con;

    protected StatementDecorator(ConnectionDecorator connection, Statement statement) {
        this.con = connection;
        this.stmt = statement;
        this.con.incrementOpenStatements();
    }

    public void addBatch(String sql) throws SQLException {
        this.stmt.addBatch(sql);
    }

    public void cancel() throws SQLException {
        this.stmt.cancel();
    }

    public void clearBatch() throws SQLException {
        this.stmt.clearBatch();
    }

    public void clearWarnings() throws SQLException {
        this.stmt.clearWarnings();
    }

    public void close() throws SQLException {
        this.con.decrementOpenStatements();
        this.stmt.close();
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.stmt.execute(sql, autoGeneratedKeys);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.stmt.execute(sql, columnIndexes);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.stmt.execute(sql, columnNames);
    }

    public boolean execute(String sql) throws SQLException {
        return this.stmt.execute(sql);
    }

    public int[] executeBatch() throws SQLException {
        return this.stmt.executeBatch();
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return this.stmt.executeQuery(sql);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.stmt.executeUpdate(sql, autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.stmt.executeUpdate(sql, columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.stmt.executeUpdate(sql, columnNames);
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.stmt.executeUpdate(sql);
    }

    public Connection getConnection() throws SQLException {
        return this.con;
    }

    public int getFetchDirection() throws SQLException {
        return this.stmt.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.stmt.getFetchSize();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.stmt.getGeneratedKeys();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.stmt.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.stmt.getMaxRows();
    }

    public boolean getMoreResults() throws SQLException {
        return this.stmt.getMoreResults();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.stmt.getMoreResults(current);
    }

    public int getQueryTimeout() throws SQLException {
        return this.stmt.getQueryTimeout();
    }

    public ResultSet getResultSet() throws SQLException {
        return this.stmt.getResultSet();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.stmt.getResultSetConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        return this.stmt.getResultSetHoldability();
    }

    public int getResultSetType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    public int getUpdateCount() throws SQLException {
        return this.stmt.getUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.stmt.getWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.stmt.setCursorName(name);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.stmt.setEscapeProcessing(enable);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.stmt.setFetchDirection(direction);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.stmt.setFetchSize(rows);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.stmt.setMaxFieldSize(max);
    }

    public void setMaxRows(int max) throws SQLException {
        this.stmt.setMaxRows(max);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.stmt.setQueryTimeout(seconds);
    }
}

