/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.regex;

import java.awt.Color;
import java.awt.GridLayout;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public class REDemo
extends JPanel {
    private static final long serialVersionUID = 3257563988576317490L;
    protected Pattern pattern;
    protected Matcher matcher;
    protected JTextField patternTF;
    protected JTextField stringTF;
    protected JCheckBox compiledOK;
    protected JRadioButton match;
    protected JRadioButton find;
    protected JRadioButton findAll;
    protected JTextField matchesTF;
    protected JTextArea logTextArea;
    private static final Color[] Colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.CYAN, Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.WHITE};
    Object onlyHighlight;
    Highlighter highlighter;
    boolean matches;

    public static void main(String[] av) throws BadLocationException {
        JFrame f = new JFrame("REDemo");
        f.setDefaultCloseOperation(3);
        REDemo comp = new REDemo();
        f.setContentPane(comp);
        f.pack();
        f.setLocation(200, 200);
        f.setVisible(true);
    }

    public REDemo() throws BadLocationException {
        JPanel top = new JPanel();
        top.add(new JLabel("Pattern:", 4));
        this.patternTF = new JTextField(20);
        this.patternTF.getDocument().addDocumentListener(new PatternListener());
        top.add(this.patternTF);
        top.add(new JLabel("Syntax OK?"));
        this.compiledOK = new JCheckBox();
        top.add(this.compiledOK);
        ChangeListener cl = new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                REDemo.this.tryMatch();
            }
        };
        JPanel switchPane = new JPanel();
        ButtonGroup bg = new ButtonGroup();
        this.match = new JRadioButton("Match");
        this.match.setSelected(true);
        this.match.addChangeListener(cl);
        bg.add(this.match);
        switchPane.add(this.match);
        this.find = new JRadioButton("Find");
        this.find.addChangeListener(cl);
        bg.add(this.find);
        switchPane.add(this.find);
        this.findAll = new JRadioButton("Find All");
        this.findAll.addChangeListener(cl);
        bg.add(this.findAll);
        switchPane.add(this.findAll);
        bg.setSelected(this.find.getModel(), true);
        JPanel strPane = new JPanel();
        strPane.add(new JLabel("String:", 4));
        this.stringTF = new JTextField(20);
        this.stringTF.getDocument().addDocumentListener(new StringListener());
        this.highlighter = this.stringTF.getHighlighter();
        this.onlyHighlight = this.highlighter.addHighlight(0, 0, DefaultHighlighter.DefaultPainter);
        strPane.add(this.stringTF);
        strPane.add(new JLabel("Matches:"));
        this.matchesTF = new JTextField(3);
        strPane.add(this.matchesTF);
        this.setLayout(new GridLayout(0, 1, 5, 5));
        this.add(top);
        this.add(strPane);
        this.add(switchPane);
        this.logTextArea = new JTextArea(5, 40);
        this.add(this.logTextArea);
    }

    protected void setMatches(boolean b) {
        this.matches = b;
        if (b) {
            this.matchesTF.setText("Yes");
        } else {
            this.matchesTF.setText("No");
        }
    }

    boolean isMatch() {
        return this.matches;
    }

    protected void setMatches(int n) {
        this.matchesTF.setText(Integer.toString(n));
    }

    protected void tryAll() {
        this.tryCompile();
        String data = this.stringTF.getText();
        if (data != null && data.length() > 0) {
            this.tryMatch();
        }
    }

    protected void tryCompile() {
        this.pattern = null;
        try {
            this.pattern = Pattern.compile(this.patternTF.getText());
            this.matcher = this.pattern.matcher("");
            this.compiledOK.setSelected(true);
        }
        catch (PatternSyntaxException ex) {
            this.compiledOK.setSelected(false);
        }
    }

    protected boolean tryMatch() {
        if (this.pattern == null) {
            return false;
        }
        this.logTextArea.setText("");
        this.setMatches(false);
        this.setHighlightFromMatcher(null);
        int n = this.matcher.groupCount();
        this.matcher.reset(this.stringTF.getText());
        if (this.match.isSelected() && this.matcher.matches()) {
            this.setMatches(true);
            this.setHighlightFromMatcher(this.matcher);
            this.logTextArea.setText("");
            int i = 0;
            while (i <= this.matcher.groupCount()) {
                this.logTextArea.append(String.valueOf(i) + " " + this.matcher.group(i) + "\n");
                ++i;
            }
        } else if (this.find.isSelected() && this.matcher.find()) {
            this.setMatches(true);
            this.setHighlightFromMatcher(this.matcher);
            this.logTextArea.setText(this.matcher.group());
        } else if (this.findAll.isSelected()) {
            int i = 0;
            while (i < n) {
                this.matcher.find();
                this.logTextArea.append(String.valueOf(i) + ": " + this.matcher.group(i) + "\n");
                ++i;
            }
            if (i > 0) {
                this.setHighlightFromMatcher(this.matcher);
                this.setMatches(true);
                return true;
            }
        }
        return this.isMatch();
    }

    private void setHighlightFromMatcher(Matcher matcher) {
        int start;
        int end;
        if (matcher == null) {
            end = 0;
            start = 0;
        } else {
            start = matcher.start();
            end = matcher.end();
        }
        try {
            this.highlighter.changeHighlight(this.onlyHighlight, start, end);
        }
        catch (BadLocationException e) {
            System.err.println(e);
        }
    }

    public Color getColor(int n) {
        return Colors[n % Colors.length];
    }

    class PatternListener
    implements DocumentListener {
        PatternListener() {
        }

        public void changedUpdate(DocumentEvent ev) {
            REDemo.this.tryAll();
        }

        public void insertUpdate(DocumentEvent ev) {
            REDemo.this.tryAll();
        }

        public void removeUpdate(DocumentEvent ev) {
            REDemo.this.tryAll();
        }
    }

    class StringListener
    implements DocumentListener {
        StringListener() {
        }

        public void changedUpdate(DocumentEvent ev) {
            REDemo.this.tryMatch();
        }

        public void insertUpdate(DocumentEvent ev) {
            REDemo.this.tryMatch();
        }

        public void removeUpdate(DocumentEvent ev) {
            REDemo.this.tryMatch();
        }
    }
}

