/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.notepad;

import com.darwinsys.swingui.UtilGUI;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintServiceLookup;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.undo.UndoManager;

public class Notepad {
    private JFrame theFrame;
    private JTextArea ta;
    private UndoManager undoManager;
    private JFileChooser chooser;
    private String fileName;
    private static List<Notepad> windows = new ArrayList<Notepad>();
    private boolean isStandalone = true;
    private JMenu fm;
    private JMenu em;
    private JMenu hm;
    Action openAction = new OpenAction();
    Action newAction = new NewAction();
    private boolean doingSaveAs;
    Action saveAction = new SaveAction();
    Action saveAsAction = new SaveAsAction();
    Action closeAction = new CloseAction();
    Action printAction = new PrintAction();
    Action cutAction = new CutAction();
    Action undoAction = new UndoAction();
    Action copyAction = new CopyAction();
    Action pasteAction = new PasteAction();
    Action exitAction = new ExitAction();
    Action helpAboutAction = new HelpAboutAction();

    public Notepad() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Notepad(boolean isStandalone) {
        this.isStandalone = isStandalone;
        String prop = System.getProperty("STANDALONE");
        if (prop != null) {
            this.isStandalone = Boolean.parseBoolean(prop);
            System.out.println("Standalone set to " + this.isStandalone + "(" + prop + ")");
        }
        this.theFrame = new JFrame();
        this.theFrame.setDefaultCloseOperation(0);
        this.theFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Notepad.this.closeThisWindow();
            }
        });
        this.ta = new JTextArea(30, 70);
        this.undoManager = new UndoManager();
        this.ta.getDocument().addUndoableEditListener(this.undoManager);
        this.theFrame.setContentPane(new JScrollPane(this.ta));
        this.theFrame.pack();
        this.createMenus();
        UtilGUI.centre(this.theFrame);
        Point loc = this.theFrame.getLocation();
        List<Notepad> list = windows;
        synchronized (list) {
            int windowsCreated = windows.size();
            loc.x += windowsCreated * 20;
            loc.y += windowsCreated * 20;
            windows.add(this);
        }
        this.theFrame.setLocation(loc);
        this.theFrame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeThisWindow() {
        if (!this.userOKtoClose()) {
            return;
        }
        this.theFrame.setVisible(false);
        this.theFrame.dispose();
        List<Notepad> list = windows;
        synchronized (list) {
            windows.remove(this);
            if (windows.size() == 0 && this.isStandalone) {
                System.exit(0);
            }
        }
    }

    private void error(String message, Exception e) {
        JOptionPane.showMessageDialog(this.theFrame, String.valueOf(message) + "\n" + e);
        e.printStackTrace();
    }

    private void createMenus() {
        JMenuBar mb = new JMenuBar();
        this.theFrame.setJMenuBar(mb);
        this.fm = new JMenu("File");
        this.fm.add(this.openAction);
        this.fm.add(this.saveAction);
        this.fm.add(this.saveAsAction);
        this.fm.add(this.closeAction);
        this.fm.add(this.newAction);
        this.fm.addSeparator();
        this.fm.add(this.printAction);
        this.fm.addSeparator();
        this.fm.add(this.exitAction);
        this.exitAction.setEnabled(this.isStandalone);
        mb.add(this.fm);
        this.em = new JMenu("Edit");
        this.em.setMnemonic(69);
        this.em.add(this.cutAction);
        ((JMenuItem)this.em.getMenuComponent(0)).setMnemonic(88);
        this.em.add(this.copyAction);
        ((JMenuItem)this.em.getMenuComponent(1)).setMnemonic(67);
        this.em.add(this.pasteAction);
        this.em.add(this.undoAction);
        ((JMenuItem)this.em.getMenuComponent(3)).setMnemonic(90);
        this.em.addSeparator();
        JMenuItem mi = new JMenuItem("Search");
        mi.setEnabled(false);
        this.em.add(mi);
        mi = new JMenuItem("Replace");
        mi.setEnabled(false);
        this.em.add(mi);
        this.em.addSeparator();
        JMenu insertMenu = new JMenu("Insert");
        this.em.add(insertMenu);
        JMenuItem menuItem = new JMenuItem("Date");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Notepad.this.ta.insert(new Date().toString(), Notepad.this.ta.getCaretPosition());
            }
        });
        ((Container)insertMenu).add(menuItem);
        JMenuItem menuItem2 = new JMenuItem(".signature");
        menuItem2.setEnabled(false);
        ((Container)insertMenu).add(menuItem2);
        JMenuItem menuItem3 = new JMenuItem("File...");
        menuItem3.setEnabled(false);
        ((Container)insertMenu).add(menuItem3);
        mb.add(this.em);
        this.hm = new JMenu("Help");
        this.hm.add(this.helpAboutAction);
        this.helpAboutAction.setEnabled(this.isStandalone);
        mb.add(this.hm);
    }

    private boolean userOKtoClose() {
        return true;
    }

    public final void doPrint() throws IOException, PrintException {
        int i;
        System.out.println("Printing ");
        DocFlavor.CHAR_ARRAY flavor = DocFlavor.CHAR_ARRAY.TEXT_PLAIN;
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        Object[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
        switch (pservices.length) {
            case 0: {
                JOptionPane.showMessageDialog(this.theFrame, "Error: No PrintService Found", "Error", 0);
                return;
            }
            case 1: {
                i = 1;
                break;
            }
            default: {
                i = JOptionPane.showOptionDialog(this.theFrame, "Pick a printer", "Choice", 0, 3, null, pservices, pservices[0]);
            }
        }
        if (i < 0) {
            return;
        }
        DocPrintJob pj = pservices[i].createPrintJob();
        MyDocument doc = new MyDocument(flavor);
        pj.print(doc, aset);
    }

    public final void doLoad(File file) throws IOException {
        this.doLoad(file.getAbsolutePath());
    }

    /*
     * Unable to fully structure code
     */
    public final void doLoad(String fileName) throws IOException {
        is = null;
        try {
            is = new BufferedReader(new FileReader(fileName));
            if (true) ** GOTO lbl12
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this.theFrame, String.format("File %s not found, treating as New File", new Object[]{fileName}), "Not found", 2);
            this.setFileName(fileName);
            return;
        }
        do {
            this.ta.append(line);
            this.ta.append("\n");
lbl12:
            // 2 sources

        } while ((line = is.readLine()) != null);
        this.ta.setCaretPosition(0);
        is.close();
        this.setFileName(fileName);
    }

    public final void doSave(String fileName) throws IOException {
        this.doSave(new File(fileName));
    }

    public final void doSave(File file) throws IOException {
        String line;
        PrintWriter w = new PrintWriter(new FileWriter(file));
        BufferedReader is = new BufferedReader(new StringReader(this.ta.getText()));
        while ((line = is.readLine()) != null) {
            w.println(line);
        }
        w.close();
        this.setFileName(file.getAbsolutePath());
    }

    private void setFileName(String fileName) {
        this.fileName = fileName;
        this.theFrame.setTitle(fileName);
    }

    public JMenu getEditMenu() {
        return this.em;
    }

    public JMenu getFileMenu() {
        return this.fm;
    }

    public JMenu getHelpMenu() {
        return this.hm;
    }

    class OpenAction
    extends AbstractAction {
        OpenAction() {
            super("Open");
        }

        public void actionPerformed(ActionEvent e) {
            int returnVal;
            if (Notepad.this.chooser == null) {
                Notepad.this.chooser = new JFileChooser();
            }
            if ((returnVal = Notepad.this.chooser.showOpenDialog(Notepad.this.theFrame)) == 0) {
                File file = Notepad.this.chooser.getSelectedFile();
                try {
                    Notepad.this.doLoad(file.getAbsolutePath());
                }
                catch (IOException e1) {
                    Notepad.this.error("Can't open file", e1);
                }
            }
        }
    }

    static class NewAction
    extends AbstractAction {
        NewAction() {
            super("New");
        }

        public void actionPerformed(ActionEvent e) {
            new Notepad();
        }
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
            super("Save");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                int returnVal;
                if (Notepad.this.fileName != null && !Notepad.this.doingSaveAs) {
                    Notepad.this.doSave(Notepad.this.fileName);
                    return;
                }
                if (Notepad.this.chooser == null) {
                    Notepad.this.chooser = new JFileChooser();
                }
                if ((returnVal = Notepad.this.chooser.showOpenDialog(Notepad.this.theFrame)) == 0) {
                    File file = Notepad.this.chooser.getSelectedFile();
                    if (file.exists() && Notepad.this.doingSaveAs) {
                        int ret = JOptionPane.showConfirmDialog(Notepad.this.theFrame, "File already exists, overwrite?", "File Exists", 0);
                        System.err.println(ret);
                        if (ret != 0) {
                            return;
                        }
                    }
                    Notepad.this.doSave(file);
                }
            }
            catch (IOException e1) {
                Notepad.this.error("Can't save file", e1);
            }
        }
    }

    class SaveAsAction
    extends AbstractAction {
        SaveAsAction() {
            super("Save As");
        }

        public void actionPerformed(ActionEvent e) {
            Notepad.this.doingSaveAs = true;
            Notepad.this.saveAction.actionPerformed(e);
            Notepad.this.doingSaveAs = false;
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            super("Close");
        }

        public void actionPerformed(ActionEvent e) {
            Notepad.this.closeThisWindow();
        }
    }

    class PrintAction
    extends AbstractAction {
        PrintAction() {
            super("Print");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Notepad.this.doPrint();
            }
            catch (IOException e1) {
                Notepad.this.error("Print failure", e1);
            }
            catch (PrintException e1) {
                Notepad.this.error("Print failure", e1);
            }
        }
    }

    class CutAction
    extends AbstractAction {
        CutAction() {
            super("Cut");
        }

        public void actionPerformed(ActionEvent e) {
            Notepad.this.ta.cut();
        }
    }

    class UndoAction
    extends AbstractAction {
        UndoAction() {
            super("Undo");
        }

        public void actionPerformed(ActionEvent e) {
            Notepad.this.undoManager.undo();
        }
    }

    class CopyAction
    extends AbstractAction {
        CopyAction() {
            super("Copy");
        }

        public void actionPerformed(ActionEvent e) {
            Notepad.this.ta.copy();
        }
    }

    class PasteAction
    extends AbstractAction {
        PasteAction() {
            super("Paste");
        }

        public void actionPerformed(ActionEvent e) {
            Notepad.this.ta.paste();
        }
    }

    static class ExitAction
    extends AbstractAction {
        ExitAction() {
            super("Exit");
        }

        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    class HelpAboutAction
    extends AbstractAction {
        HelpAboutAction() {
            super("About");
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(Notepad.this.theFrame, "<html><font color='red'>Notepad 0.0</font> A simple text editor");
        }
    }

    final class MyDocument
    implements Doc {
        private DocFlavor flavor;

        public MyDocument(DocFlavor flavor) {
            this.flavor = flavor;
        }

        public DocFlavor getDocFlavor() {
            return this.flavor;
        }

        public Object getPrintData() throws IOException {
            return Notepad.this.ta.getText();
        }

        public DocAttributeSet getAttributes() {
            return null;
        }

        public Reader getReaderForText() throws IOException {
            return new StringReader(Notepad.this.ta.getText());
        }

        public InputStream getStreamForBytes() throws IOException {
            return null;
        }
    }
}

