/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.lang;

import com.darwinsys.lang.GetOpt;
import com.darwinsys.util.Debug;
import junit.framework.TestCase;

public class GetOptTestOldPattern
extends TestCase {
    private String goodArgChars = "o:h";
    private String[] goodArgs = new String[]{"-h", "-o", "outfile", "infile"};
    private String badArgChars = "f1o";
    private String[] badArgs = new String[]{"-h", "-o", "outfile", "infile"};

    protected void setUp() throws Exception {
        System.out.println("GetOptTest.setUp()");
    }

    public void testOldwayGood() {
        this.processUnixWay(this.goodArgChars, this.goodArgs, false);
    }

    public void testOldwayBadCharsGoodArgs() {
        this.processUnixWay(this.badArgChars, this.goodArgs, true);
    }

    public void testOldwayBadCharsBadArgs() {
        this.processUnixWay(this.badArgChars, this.badArgs, true);
    }

    void processUnixWay(String argChars, String[] args, boolean shouldFail) {
        char c;
        System.out.println("** START ** Getopt(" + argChars + ")");
        GetOpt getopt = new GetOpt(argChars);
        int errs = 0;
        while ((c = getopt.getopt(args)) != '\u0000') {
            if (c == '?') {
                System.out.print("Bad option");
                ++errs;
            } else {
                System.out.print("Found " + c);
                if (getopt.optarg() != null) {
                    System.out.print("; Option " + getopt.optarg());
                }
            }
            System.out.println();
        }
        GetOptTestOldPattern.assertTrue((args.length >= getopt.getOptInd() ? 1 : 0) != 0);
        int i = getopt.getOptInd();
        while (i < args.length) {
            Debug.printf("getopt", "%d %s%n", i, args[i]);
            String fileName = args[i];
            System.out.println("Filename-like arg " + fileName);
            GetOptTestOldPattern.assertFalse((boolean)fileName.startsWith("-"));
            ++i;
        }
    }

    public void testAllArgsDone() {
        GetOpt getopt = new GetOpt("tn:");
        String[] args = new String[]{"-n", "100", "-t"};
        GetOptTestOldPattern.assertTrue(('n' == getopt.getopt(args) ? 1 : 0) != 0);
        GetOptTestOldPattern.assertEquals((String)"100", (String)getopt.optarg);
        GetOptTestOldPattern.assertEquals((int)116, (int)getopt.getopt(args));
        GetOptTestOldPattern.assertNull((Object)getopt.optarg);
    }

    public void testEndOfListErrorHandling() {
        GetOpt getopt = new GetOpt("tn:");
        String[] badArgs = new String[]{"-t", "-n"};
        try {
            char c;
            while ((c = getopt.getopt(badArgs)) != '\u0000') {
                System.out.println("Found argument " + c);
            }
            GetOptTestOldPattern.fail((String)"Did not throw exception for -n option missing an argument");
        }
        catch (IllegalArgumentException e) {
            System.out.println("Caught expected IAE: " + e);
        }
    }
}

