"""
$RCSfile: TestXSLTProcessor.py,v $
Unit tests for ZopeXMLMethods product

Author: <a href="mailto:cstrong@arielpartners.com">Craeg Strong</a>
Release: 1.0
"""

__cvstag__  = '$Name:  $'[6:-2]
__date__    = '$Date: 2003/03/30 03:45:47 $'[6:-2]
__version__ = '$Revision: 1.22 $'[10:-2]

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

# Load fixture
from Testing import ZopeTestCase

ZopeTestCase.installProduct('ZopeXMLMethods')

# ZopeXMLMethods
from Products.ZopeXMLMethods.ProcessorChooser import ProcessorChooser

class XSLTProcessorTestCase(ZopeTestCase.ZopeTestCase):
    """

    XSLT Processor tests.  This is particularly useful if switching
    from one library to another, for example upgrading 4Suite or
    switching to Pyana or Saxon.

    """

    ################################################################
    # Fixture
    ################################################################

    def afterSetUp(self):
        '''Add object to default fixture'''
        prod               = self.folder.manage_addProduct['ZopeXMLMethods']

        self.chooser       = ProcessorChooser()

        # below is an example of how to test only a single processor...
        #self.processorList = ['4Suite-0.11.1']
        # ...for now, let's test them all
        self.processorList = self.chooser.processors()
        
        if len(self.processorList) == 0:
            raise Exception('Error: no supported XSLT Processors found')

    def afterClear(self):
        '''Clean up after myself'''
        try: del self.prod
        except AttributeError: pass

    ################################################################
    # Test Cases
    ################################################################

    def test_01(self):
        "Basic processor tests"

        xmlFile      = open('testfiles/simple.xml', 'rb')
        xmlContents  = xmlFile.read()
        xsltFile     = open('testfiles/simple.xsl','rb')
        xsltContents = xsltFile.read()

        print
        for name in self.processorList:
            print "Testing processor", name,
            processor = self.chooser.processorObject(name)
            result = processor.transformGuts(xmlContents, "", xsltContents,
                                             "", None, None, None)
            self.assertEquals(result, "Hello, world")
            print "...ok"

    def test_02(self):
        "Test for Invalid XML"

        xmlFile      = open('testfiles/invalid.xml', 'rb')
        xmlContents  = xmlFile.read()
        xsltFile     = open('testfiles/simple.xsl','rb')
        xsltContents = xsltFile.read()

        print
        for name in self.processorList:
            print "Testing processor", name,
            processor = self.chooser.processorObject(name)
            self.assertRaises(Exception, processor.transformGuts,
                              xmlContents, "", xsltContents,
                              "", None, None, None)
            print "...ok"            

    def test_03(self):
        "Test for non valid xslt transformer"

        xmlFile      = open('testfiles/simple.xml', 'rb')
        xmlContents  = xmlFile.read()
        xsltFile     = open('testfiles/invalid.xsl','rb')
        xsltContents = xsltFile.read()

        print
        for name in self.processorList:
            print "Testing processor", name,
            processor = self.chooser.processorObject(name)
            self.assertRaises(Exception, processor.transformGuts,
                              xmlContents, "", xsltContents,
                              "", None, None, None)
            print "...ok"                        

    def test_04(self):
        "Test that the processor handles parameters correctly"

        xmlFile      = open('testfiles/param.xml', 'rb')
        xmlContents  = xmlFile.read()
        xsltFile     = open('testfiles/param.xsl','rb')
        xsltContents = xsltFile.read()

        print
        for name in self.processorList:
            print "Testing processor", name,
            processor = self.chooser.processorObject(name)
            params = {}
            processor.addParam(params, "who", "world")
            processor.addParam(params, "message", "goodbye")

            result = processor.transformGuts(xmlContents, "", xsltContents,
                                             "", None, params, None)

            self.assertEquals(result, "Hello, world and goodbye")
            print "...ok"

    ################################################################
    # Test Runner Setup
    ################################################################

if __name__ == '__main__':
    framework(descriptions=1, verbosity=2)
else:
    # While framework.py provides its own test_suite() 
    # method the testrunner utility does not.
    import unittest
    def test_suite():
        suite = unittest.TestSuite()
        suite.addTest(unittest.makeSuite(XSLTProcessorTestCase))
        return suite
