/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad.actions;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.jgraph.GPGraphpad;
import org.jgraph.pad.actions.AbstractActionDefault;
import org.jgraph.pad.resources.Translator;

public class EditFindAgain
extends AbstractActionDefault {
    public EditFindAgain(GPGraphpad gPGraphpad) {
        super(gPGraphpad);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray;
        if (this.getCurrentDocument().getFindPattern() == null) {
            try {
                objectArray = JOptionPane.showInputDialog(Translator.getString("FindDialog"));
                if (objectArray != null && objectArray.length() > 0) {
                    this.getCurrentDocument().setFindPattern(objectArray.toLowerCase());
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception exception) {
                this.graphpad.error(exception.toString());
                this.getCurrentDocument().setFindPattern(null);
            }
        }
        if (this.getCurrentDocument().getFindPattern() != null) {
            objectArray = this.getCurrentGraph().getRoots();
            boolean bl = this.getCurrentDocument().getLastFound() == null;
            Object object = null;
            if (objectArray != null && objectArray.length > 0) {
                int n = 0;
                while (n < objectArray.length) {
                    String string;
                    if (bl && (string = this.getCurrentGraph().convertValueToString(objectArray[n])).toLowerCase().startsWith(this.getCurrentDocument().getFindPattern())) {
                        object = objectArray[n];
                        break;
                    }
                    bl = bl || objectArray[n] == this.getCurrentDocument().getLastFound();
                    ++n;
                }
            }
            this.getCurrentDocument().setLastFound(object);
            if (this.getCurrentDocument().getLastFound() != null) {
                this.getCurrentGraph().scrollCellToVisible(this.getCurrentDocument().getLastFound());
                this.getCurrentGraph().setSelectionCell(this.getCurrentDocument().getLastFound());
            } else {
                this.graphpad.error(Translator.getString("NoMatchDialog"));
            }
        }
    }
}

