C      $Id: x13f.fm4,v 1.11 2005/04/27 06:43:54 rlaboiss Exp $
C      Pie chart demo.
C
C      Copyright (C) 2004  Alan W. Irwin
C
C      This file is part of PLplot.
C
C      PLplot is free software; you can redistribute it and/or modify
C      it under the terms of the GNU General Library Public License as
C      published by the Free Software Foundation; either version 2 of the
C      License, or (at your option) any later version.
C
C      PLplot is distributed in the hope that it will be useful,
C      but WITHOUT ANY WARRANTY; without even the implied warranty of
C      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C      GNU Library General Public License for more details.
C
C      You should have received a copy of the GNU Library General Public
C      License along with PLplot; if not, write to the Free Software
C      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

      implicit none
      real*8 PI
      parameter (PI = 3.1415926535897932384d0)
      real*8 just, dx, dy, x(500), y(500), per(5)
      integer i, j, dthet, theta0, theta1, theta
      character*20 text(5)
      data text / 'Maurice', 'Geoffrey', 'Alan', 'Rafael', 'Vince'/

      integer PL_PARSE_FULL
      parameter(PL_PARSE_FULL = 1)
C      Process command-line arguments
      call plparseopts(PL_PARSE_FULL)

      per(1) = 10.d0
      per(2) = 32.d0
      per(3) = 12.d0
      per(4) = 30.d0
      per(5) = 16.d0

C      Ask user to specify the output device.

      call plinit()

      call plenv( 0.d0, 10.d0, 0.d0, 10.d0, 1, -2 )
      call plcol0(2)

C      n.b. all theta quantities scaled by 2*pi/500 to be integers to avoid
C      floating point logic problems.
      theta0 = 0
      dthet = 1

      do i = 0, 4
        j = 0
        x(j+1) = 5.d0
        y(j+1) = 5.d0
        j = j + 1
C        n.b. the theta quantities multiplied by 2*pi/500 afterward so
C        in fact per is interpreted as a percentage.
        theta1 = theta0 + 5*per(i+1)
        if (i .eq. 4) theta1 = 500
        do theta = theta0, theta1, dthet
          x(j+1) = 5 + 3*cos((2.d0*pi/500.d0)*theta)
          y(j+1) = 5 + 3*sin((2.d0*pi/500.d0)*theta)
          j = j + 1
        enddo

        call plcol0(i+1)
        call plpsty( mod(i+3, 8) + 1 )
        call plfill( j, x, y )
        call plcol0(1)
        call plline( j, x, y )

        just = (2.d0*pi/500.d0)*(theta0 + theta1) / 2.d0
        dx = 0.25d0 * cos(just)
        dy = 0.25d0 * sin(just)
        if ((theta0  + theta1) .lt. 250 .or.
     &      (theta0 + theta1) .gt. 750) then
          just = 0.d0
        else
          just = 1.d0
        endif
        call plptex( x(j/2+1)+dx, y(j/2+1)+dy, 1.d0, 0.d0,
     &    just, text(i+1) )
        theta0 = theta - dthet
      enddo

      call plfont(2)
      call plschr( 0.d0, 1.3d0)
      call plptex( 5.d0, 9.d0, 1.d0, 0.d0,
     &  0.5d0, 'Percentage of Sales' )

      call plend
      end
