/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import org.jmol.adapter.readers.quantum.SlaterReader;

abstract class MopacReader
extends SlaterReader {
    protected static final float MIN_COEF = 1.0E-4f;
    protected int[] atomicNumbers;
    private static final int[] sphericalDValues = new int[]{0, -2, 0, 1, 0, 1, -2, 0, 0, 0, 1, 1, 1, 1, 0};
    private static final int[] principalQuantumNumber = new int[]{0, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
    private static final int[] npqd = new int[]{0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7};

    MopacReader() {
    }

    protected void createSphericalSlaterByType(int n, int n2, String string, float f, float f2) {
        int n3 = "S Px Py Pz  Dx2-y2Dxz Dz2 Dyz Dxy".indexOf(string);
        switch (n3) {
            case 0: {
                this.addSlater(n, 0, 0, 0, MopacReader.getNPQs(n2) - 1, f, f2);
                return;
            }
            case 2: 
            case 5: 
            case 8: {
                this.addSlater(n, n3 == 2 ? 1 : 0, n3 == 5 ? 1 : 0, n3 == 8 ? 1 : 0, MopacReader.getNPQp(n2) - 2, f, f2);
                return;
            }
        }
        n3 = (n3 >> 2) * 3 - 9;
        this.addSlater(n, sphericalDValues[n3++], sphericalDValues[n3++], sphericalDValues[n3++], MopacReader.getNPQd(n2) - 3, f, f2);
    }

    protected double scaleSlater(int n, int n2, int n3, int n4, double d) {
        if (n >= 0 && n2 >= 0) {
            return super.scaleSlater(n, n2, n3, n4, d);
        }
        int n5 = Math.abs(n + n2 + n3);
        if (n5 == 3) {
            return 0.0;
        }
        return MopacReader.getSlaterConstDSpherical(n5 + n4 + 1, Math.abs(d), n, n2);
    }

    private static final int getNPQ(int n) {
        return n < principalQuantumNumber.length ? principalQuantumNumber[n] : 0;
    }

    private static final int getNPQs(int n) {
        int n2 = MopacReader.getNPQ(n);
        switch (n) {
            case 10: 
            case 18: 
            case 36: 
            case 54: 
            case 86: {
                return n2 + 1;
            }
        }
        return n2;
    }

    private static final int getNPQp(int n) {
        int n2 = MopacReader.getNPQ(n);
        switch (n) {
            case 2: {
                return n2 + 1;
            }
        }
        return n2;
    }

    private static final int getNPQd(int n) {
        return n < npqd.length ? npqd[n] : 0;
    }
}

