# Changelog

All notable changes to this project will be documented in this file.

<!-- <START NEW CHANGELOG ENTRY> -->

## 0.12.0

([Full Changelog](https://github.com/jupyter/jupyter_events/compare/v0.11.0...6704ea630522f44542d83608f750da0068e41443))

### Bugs fixed

- pop taskName for older version of python-json-logger [#110](https://github.com/jupyter/jupyter_events/pull/110) ([@Carreau](https://github.com/Carreau))

### Maintenance and upkeep improvements

- declare dependency on packaging [#109](https://github.com/jupyter/jupyter_events/pull/109) ([@bollwyvl](https://github.com/bollwyvl))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/jupyter_events/graphs/contributors?from=2024-12-17&to=2025-02-03&type=c))

[@bollwyvl](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Abollwyvl+updated%3A2024-12-17..2025-02-03&type=Issues) | [@Carreau](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3ACarreau+updated%3A2024-12-17..2025-02-03&type=Issues)

<!-- <END NEW CHANGELOG ENTRY> -->

## 0.11.0

([Full Changelog](https://github.com/jupyter/jupyter_events/compare/v0.10.0...f8012610f86408908004febed9e0e06ef71ca951))

### Bugs fixed

- Switch schema `version` type to `str` [#104](https://github.com/jupyter/jupyter_events/pull/104) ([@afshin](https://github.com/afshin))
- Fix DeprecationWarning with patched python-json-logger [#103](https://github.com/jupyter/jupyter_events/pull/103) ([@cjwatson](https://github.com/cjwatson))
- Prevent unintended `KeyError` when emitting an unregistered event schema [#101](https://github.com/jupyter/jupyter_events/pull/101) ([@afshin](https://github.com/afshin))

### Maintenance and upkeep improvements

- Fix typo and remove double check. [#107](https://github.com/jupyter/jupyter_events/pull/107) ([@Carreau](https://github.com/Carreau))
- test on 3.13 [#106](https://github.com/jupyter/jupyter_events/pull/106) ([@Carreau](https://github.com/Carreau))

### Documentation improvements

- Fix typo [#102](https://github.com/jupyter/jupyter_events/pull/102) ([@davidbrochart](https://github.com/davidbrochart))
- Update notebook to match current version of jupyter-events [#98](https://github.com/jupyter/jupyter_events/pull/98) ([@manics](https://github.com/manics))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/jupyter_events/graphs/contributors?from=2024-03-18&to=2024-12-17&type=c))

[@afshin](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Aafshin+updated%3A2024-03-18..2024-12-17&type=Issues) | [@Carreau](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3ACarreau+updated%3A2024-03-18..2024-12-17&type=Issues) | [@cjwatson](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Acjwatson+updated%3A2024-03-18..2024-12-17&type=Issues) | [@davidbrochart](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Adavidbrochart+updated%3A2024-03-18..2024-12-17&type=Issues) | [@manics](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Amanics+updated%3A2024-03-18..2024-12-17&type=Issues) | [@Zsailer](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3AZsailer+updated%3A2024-03-18..2024-12-17&type=Issues)

## 0.10.0

([Full Changelog](https://github.com/jupyter/jupyter_events/compare/v0.9.1...e7784fd09356ef074d69d1c2f192f1ad96f5f00c))

### Enhancements made

- Enable adding listeners to event before the event is registered [#97](https://github.com/jupyter/jupyter_events/pull/97) ([@Zsailer](https://github.com/Zsailer))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/jupyter_events/graphs/contributors?from=2024-03-12&to=2024-03-18&type=c))

[@Zsailer](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3AZsailer+updated%3A2024-03-12..2024-03-18&type=Issues)

## 0.9.1

([Full Changelog](https://github.com/jupyter/jupyter_events/compare/v0.9.0...014a91c793b12d008bb744614a280bc14b5be7eb))

### Maintenance and upkeep improvements

- Update Release Scripts [#96](https://github.com/jupyter/jupyter_events/pull/96) ([@blink1073](https://github.com/blink1073))
- chore: update pre-commit hooks [#95](https://github.com/jupyter/jupyter_events/pull/95) ([@pre-commit-ci](https://github.com/pre-commit-ci))
- chore: update pre-commit hooks [#94](https://github.com/jupyter/jupyter_events/pull/94) ([@pre-commit-ci](https://github.com/pre-commit-ci))
- Update ruff and typing [#93](https://github.com/jupyter/jupyter_events/pull/93) ([@blink1073](https://github.com/blink1073))
- chore: update pre-commit hooks [#92](https://github.com/jupyter/jupyter_events/pull/92) ([@pre-commit-ci](https://github.com/pre-commit-ci))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/jupyter_events/graphs/contributors?from=2023-11-06&to=2024-03-12&type=c))

[@blink1073](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Ablink1073+updated%3A2023-11-06..2024-03-12&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Apre-commit-ci+updated%3A2023-11-06..2024-03-12&type=Issues)

## 0.9.0

([Full Changelog](https://github.com/jupyter/jupyter_events/compare/v0.8.0...228a04801224d127f4304e17398464d045794cf0))

### Bugs fixed

- Clean up linting and fix a bug that was found [#91](https://github.com/jupyter/jupyter_events/pull/91) ([@blink1073](https://github.com/blink1073))

### Maintenance and upkeep improvements

- Clean up linting and fix a bug that was found [#91](https://github.com/jupyter/jupyter_events/pull/91) ([@blink1073](https://github.com/blink1073))
- Adopt ruff format [#90](https://github.com/jupyter/jupyter_events/pull/90) ([@blink1073](https://github.com/blink1073))
- Normalize "jsonschema\[format-nongpl\]" in  pyproject.toml [#86](https://github.com/jupyter/jupyter_events/pull/86) ([@frenzymadness](https://github.com/frenzymadness))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/jupyter_events/graphs/contributors?from=2023-10-16&to=2023-11-06&type=c))

[@blink1073](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Ablink1073+updated%3A2023-10-16..2023-11-06&type=Issues) | [@frenzymadness](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Afrenzymadness+updated%3A2023-10-16..2023-11-06&type=Issues)

## 0.8.0

([Full Changelog](https://github.com/jupyter/jupyter_events/compare/v0.7.0...e3edb6a868924d3f1b15eaf18d45be621ad77cef))

### Bugs fixed

- Allow for string annotations in listener signature [#88](https://github.com/jupyter/jupyter_events/pull/88) ([@blink1073](https://github.com/blink1073))

### Maintenance and upkeep improvements

- Adopt sp-repo-review [#89](https://github.com/jupyter/jupyter_events/pull/89) ([@blink1073](https://github.com/blink1073))
- Bump actions/checkout from 3 to 4 [#84](https://github.com/jupyter/jupyter_events/pull/84) ([@dependabot](https://github.com/dependabot))
- Add more PyPI URLs [#82](https://github.com/jupyter/jupyter_events/pull/82) ([@pydanny](https://github.com/pydanny))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/jupyter_events/graphs/contributors?from=2023-07-31&to=2023-10-16&type=c))

[@blink1073](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Ablink1073+updated%3A2023-07-31..2023-10-16&type=Issues) | [@dependabot](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Adependabot+updated%3A2023-07-31..2023-10-16&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Apre-commit-ci+updated%3A2023-07-31..2023-10-16&type=Issues) | [@pydanny](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Apydanny+updated%3A2023-07-31..2023-10-16&type=Issues) | [@Zsailer](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3AZsailer+updated%3A2023-07-31..2023-10-16&type=Issues)

## 0.7.0

([Full Changelog](https://github.com/jupyter/jupyter_events/compare/v0.6.3...56e7d2660b59632765a85859217cddc7304e82f8))

### Enhancements made

- allow a 'message' field in an event schema [#72](https://github.com/jupyter/jupyter_events/pull/72) ([@Zsailer](https://github.com/Zsailer))

### Bugs fixed

- Improve usability of jp_read_emitted_events fixture [#74](https://github.com/jupyter/jupyter_events/pull/74) ([@kevin-bates](https://github.com/kevin-bates))

### Maintenance and upkeep improvements

- Migrate RefResolver to referencing.Registry [#80](https://github.com/jupyter/jupyter_events/pull/80) ([@hbcarlos](https://github.com/hbcarlos))
- Use local coverage [#73](https://github.com/jupyter/jupyter_events/pull/73) ([@blink1073](https://github.com/blink1073))
- Clean up license [#67](https://github.com/jupyter/jupyter_events/pull/67) ([@dcsaba89](https://github.com/dcsaba89))
- Add more linting [#65](https://github.com/jupyter/jupyter_events/pull/65) ([@blink1073](https://github.com/blink1073))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/jupyter_events/graphs/contributors?from=2023-01-12&to=2023-07-31&type=c))

[@blink1073](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Ablink1073+updated%3A2023-01-12..2023-07-31&type=Issues) | [@dcsaba89](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Adcsaba89+updated%3A2023-01-12..2023-07-31&type=Issues) | [@hbcarlos](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Ahbcarlos+updated%3A2023-01-12..2023-07-31&type=Issues) | [@kevin-bates](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Akevin-bates+updated%3A2023-01-12..2023-07-31&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Apre-commit-ci+updated%3A2023-01-12..2023-07-31&type=Issues) | [@Zsailer](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3AZsailer+updated%3A2023-01-12..2023-07-31&type=Issues)

## 0.6.3

([Full Changelog](https://github.com/jupyter/jupyter_events/compare/v0.6.2...ac65980322317f1f30bc07150c9e14afaad03d40))

### Maintenance and upkeep improvements

- Clean up typing [#64](https://github.com/jupyter/jupyter_events/pull/64) ([@blink1073](https://github.com/blink1073))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/jupyter_events/graphs/contributors?from=2023-01-10&to=2023-01-12&type=c))

[@blink1073](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Ablink1073+updated%3A2023-01-10..2023-01-12&type=Issues)

## 0.6.2

([Full Changelog](https://github.com/jupyter/jupyter_events/compare/v0.6.1...a00859944090df5277f263fcfe72ae48b8cc2382))

### Maintenance and upkeep improvements

- Decrease pyyaml dependency floor to increase compatibility [#63](https://github.com/jupyter/jupyter_events/pull/63) ([@kevin-bates](https://github.com/kevin-bates))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/jupyter_events/graphs/contributors?from=2023-01-10&to=2023-01-10&type=c))

[@kevin-bates](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Akevin-bates+updated%3A2023-01-10..2023-01-10&type=Issues)

## 0.6.1

([Full Changelog](https://github.com/jupyter/jupyter_events/compare/v0.6.0...1aa57024d0a8c73b10d9944375f84c01ee9f5c33))

### Maintenance and upkeep improvements

- Remove artificial cap on jsonschema dependency [#61](https://github.com/jupyter/jupyter_events/pull/61) ([@kevin-bates](https://github.com/kevin-bates))
- Try dropping jsonschema dependency [#59](https://github.com/jupyter/jupyter_events/pull/59) ([@bretttully](https://github.com/bretttully))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/jupyter_events/graphs/contributors?from=2023-01-09&to=2023-01-10&type=c))

[@blink1073](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Ablink1073+updated%3A2023-01-09..2023-01-10&type=Issues) | [@bretttully](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Abretttully+updated%3A2023-01-09..2023-01-10&type=Issues) | [@kevin-bates](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Akevin-bates+updated%3A2023-01-09..2023-01-10&type=Issues)

## 0.6.0

([Full Changelog](https://github.com/jupyter/jupyter_events/compare/v0.5.0...83f01b142c3190074d9e6108155514ddc6237d2c))

### Maintenance and upkeep improvements

- Add typing file [#60](https://github.com/jupyter/jupyter_events/pull/60) ([@blink1073](https://github.com/blink1073))
- More lint cleanup [#56](https://github.com/jupyter/jupyter_events/pull/56) ([@blink1073](https://github.com/blink1073))
- Add more ci checks [#53](https://github.com/jupyter/jupyter_events/pull/53) ([@blink1073](https://github.com/blink1073))
- Allow releasing from repo [#52](https://github.com/jupyter/jupyter_events/pull/52) ([@blink1073](https://github.com/blink1073))
- Adopt ruff and address lint [#51](https://github.com/jupyter/jupyter_events/pull/51) ([@blink1073](https://github.com/blink1073))
- Use base setup dependency type [#47](https://github.com/jupyter/jupyter_events/pull/47) ([@blink1073](https://github.com/blink1073))
- Clean up CI [#45](https://github.com/jupyter/jupyter_events/pull/45) ([@blink1073](https://github.com/blink1073))
- CI Cleanup [#44](https://github.com/jupyter/jupyter_events/pull/44) ([@blink1073](https://github.com/blink1073))
- Bump actions/checkout from 2 to 3 [#42](https://github.com/jupyter/jupyter_events/pull/42) ([@dependabot](https://github.com/dependabot))
- Add dependabot [#41](https://github.com/jupyter/jupyter_events/pull/41) ([@blink1073](https://github.com/blink1073))
- Maintenance cleanup [#36](https://github.com/jupyter/jupyter_events/pull/36) ([@blink1073](https://github.com/blink1073))
- Clean up CI checks [#35](https://github.com/jupyter/jupyter_events/pull/35) ([@blink1073](https://github.com/blink1073))
- Clean up pyproject and ci [#33](https://github.com/jupyter/jupyter_events/pull/33) ([@blink1073](https://github.com/blink1073))

### Documentation improvements

- Fix listener example [#34](https://github.com/jupyter/jupyter_events/pull/34) ([@dlqqq](https://github.com/dlqqq))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/jupyter_events/graphs/contributors?from=2022-09-12&to=2023-01-09&type=c))

[@blink1073](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Ablink1073+updated%3A2022-09-12..2023-01-09&type=Issues) | [@dependabot](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Adependabot+updated%3A2022-09-12..2023-01-09&type=Issues) | [@dlqqq](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Adlqqq+updated%3A2022-09-12..2023-01-09&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Apre-commit-ci+updated%3A2022-09-12..2023-01-09&type=Issues)

## 0.5.0

([Full Changelog](https://github.com/jupyter/jupyter_events/compare/v0.4.0...af1db6f5b9052e54d5a65797b67bff17b80e7eec))

### Enhancements made

- Add pytest plugin for testing events in other libraries [#23](https://github.com/jupyter/jupyter_events/pull/23) ([@Zsailer](https://github.com/Zsailer))
- improve error messages for absent/invalid schema path [#22](https://github.com/jupyter/jupyter_events/pull/22) ([@dlqqq](https://github.com/dlqqq))

### Bugs fixed

- specify utf-8 encoding for loading/dumping yaml [#29](https://github.com/jupyter/jupyter_events/pull/29) ([@bollwyvl](https://github.com/bollwyvl))
- use safe loaders and dumpers in yaml lib [#28](https://github.com/jupyter/jupyter_events/pull/28) ([@dlqqq](https://github.com/dlqqq))

### Maintenance and upkeep improvements

- add jsonschema\[format-nongpl\], core event schema [#31](https://github.com/jupyter/jupyter_events/pull/31) ([@bollwyvl](https://github.com/bollwyvl))
- Add CLI tests, return codes, version [#30](https://github.com/jupyter/jupyter_events/pull/30) ([@bollwyvl](https://github.com/bollwyvl))
- Set version floor on jsonchema [#25](https://github.com/jupyter/jupyter_events/pull/25) ([@kevin-bates](https://github.com/kevin-bates))
- Testing that the `.emit` call is a no-op when no listeners are registered. [#24](https://github.com/jupyter/jupyter_events/pull/24) ([@Zsailer](https://github.com/Zsailer))

### Documentation improvements

- docs: wrap shell command in quotes [#21](https://github.com/jupyter/jupyter_events/pull/21) ([@dlqqq](https://github.com/dlqqq))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/jupyter_events/graphs/contributors?from=2022-08-29&to=2022-09-12&type=c))

[@bollwyvl](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Abollwyvl+updated%3A2022-08-29..2022-09-12&type=Issues) | [@dlqqq](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Adlqqq+updated%3A2022-08-29..2022-09-12&type=Issues) | [@kevin-bates](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Akevin-bates+updated%3A2022-08-29..2022-09-12&type=Issues) | [@Zsailer](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3AZsailer+updated%3A2022-08-29..2022-09-12&type=Issues)

## 0.4.0

([Full Changelog](https://github.com/jupyter/jupyter_events/compare/v0.3.0...6d22b7dd73b1a04baf26a68539743d8a66599469))

### Enhancements made

- Add method to remove listener [#18](https://github.com/jupyter/jupyter_events/pull/18) ([@Zsailer](https://github.com/Zsailer))
- Add a simple CLI tool for validating event schemas [#9](https://github.com/jupyter/jupyter_events/pull/9) ([@Zsailer](https://github.com/Zsailer))

### Bugs fixed

- Fix minor bugs in Listeners API [#19](https://github.com/jupyter/jupyter_events/pull/19) ([@Zsailer](https://github.com/Zsailer))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/jupyter_events/graphs/contributors?from=2022-08-24&to=2022-08-29&type=c))

[@Zsailer](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3AZsailer+updated%3A2022-08-24..2022-08-29&type=Issues)

## 0.3.0

([Full Changelog](https://github.com/jupyter/jupyter_events/compare/v0.2.0...94646036f0ab4b3397e261422fd3041c0d7501e9))

### Enhancements made

- Remove (duplicate) version argument from API [#16](https://github.com/jupyter/jupyter_events/pull/16) ([@Zsailer](https://github.com/Zsailer))
- Add a "modifiers" hook to allow extension authors to mutate/redact event data [#12](https://github.com/jupyter/jupyter_events/pull/12) ([@Zsailer](https://github.com/Zsailer))
- Add Listeners API [#10](https://github.com/jupyter/jupyter_events/pull/10) ([@Zsailer](https://github.com/Zsailer))

### Bugs fixed

- Reading strings as file path is unsafe [#15](https://github.com/jupyter/jupyter_events/pull/15) ([@Zsailer](https://github.com/Zsailer))

### Maintenance and upkeep improvements

- Fix check_release build [#14](https://github.com/jupyter/jupyter_events/pull/14) ([@blink1073](https://github.com/blink1073))

### Documentation improvements

- Add JupyterLite example to the documentation [#6](https://github.com/jupyter/jupyter_events/pull/6) ([@Zsailer](https://github.com/Zsailer))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/jupyter_events/graphs/contributors?from=2022-08-11&to=2022-08-24&type=c))

[@blink1073](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Ablink1073+updated%3A2022-08-11..2022-08-24&type=Issues) | [@Zsailer](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3AZsailer+updated%3A2022-08-11..2022-08-24&type=Issues)

## 0.2.0

([Full Changelog](https://github.com/jupyter/jupyter_events/compare/v0.1.0...88acd8ec613fe7d2aa6fcaf07158275989dc5dfd))

### Enhancements made

- Add new EventSchema and SchemaRegistry API [#4](https://github.com/jupyter/jupyter_events/pull/4) ([@Zsailer](https://github.com/Zsailer))
- Add redactionPolicies field to Jupyter Event schemas [#2](https://github.com/jupyter/jupyter_events/pull/2) ([@Zsailer](https://github.com/Zsailer))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter/jupyter_events/graphs/contributors?from=2022-05-31&to=2022-08-11&type=c))

[@kevin-bates](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3Akevin-bates+updated%3A2022-05-31..2022-08-11&type=Issues) | [@Zsailer](https://github.com/search?q=repo%3Ajupyter%2Fjupyter_events+involves%3AZsailer+updated%3A2022-05-31..2022-08-11&type=Issues)

## 0.1.0
