'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

var _dates = require('./dates');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var DateAssertion = function () {
  function DateAssertion(date) {
    _classCallCheck(this, DateAssertion);

    this.date = date;
  }

  _createClass(DateAssertion, [{
    key: '_parse',
    value: function _parse(expression) {
      var matches = new RegExp('(<=|<|>|==?)?\s*(.*?)\s*([a-z]*)?\s*$').exec(expression);

      return {
        value: parseInt(matches[2] || 0),
        operator: matches[1] || '==',
        unit: (0, _dates.normalise)(matches[3] || 'days')
      };
    }
  }, {
    key: '_diff',
    value: function _diff(value, unit) {
      var targetDate = (0, _moment2.default)().subtract(value, unit);
      var modified = (0, _moment2.default)(this.date);
      var unitDifference = (0, _moment2.default)(targetDate.format()).diff(modified, 'seconds');

      return unitDifference;
    }
  }, {
    key: 'assert',
    value: function assert(expression) {
      var parts = this._parse(expression);

      if (parts.operator === '<') return this.lessThan(parts.value, parts.unit);
      if (parts.operator === '>') return this.greaterThan(parts.value, parts.unit);
      if (parts.operator === '<=') return this.lessThanOrEqual(parts.value, parts.unit);
      if (parts.operator === '>=') return this.greaterThanOrEqual(parts.value, parts.unit);

      return this.equalTo(parts.value, parts.unit);
    }
  }, {
    key: 'lessThan',
    value: function lessThan(unitNumber, unit) {
      return this._diff(unitNumber, unit) < 0;
    }
  }, {
    key: 'equalTo',
    value: function equalTo(number, unit) {
      return this._diff(number, unit) === 0;
    }
  }, {
    key: 'greaterThan',
    value: function greaterThan(number, unit) {
      return this._diff(number, unit) > 0;
    }
  }, {
    key: 'lessThanOrEqual',
    value: function lessThanOrEqual(number, unit) {
      return this._diff(number, unit) <= 0;
    }
  }, {
    key: 'greaterThanOrEqual',
    value: function greaterThanOrEqual(number, unit) {
      return this._diff(number, unit) >= 0;
    }
  }]);

  return DateAssertion;
}();

exports.default = DateAssertion;