// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a fleet of devices.
func (c *Client) UpdateDeviceFleet(ctx context.Context, params *UpdateDeviceFleetInput, optFns ...func(*Options)) (*UpdateDeviceFleetOutput, error) {
	if params == nil {
		params = &UpdateDeviceFleetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDeviceFleet", params, optFns, c.addOperationUpdateDeviceFleetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDeviceFleetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateDeviceFleetInput struct {

	// The name of the fleet.
	//
	// This member is required.
	DeviceFleetName *string

	// Output configuration for storing sample data collected by the fleet.
	//
	// This member is required.
	OutputConfig *types.EdgeOutputConfig

	// Description of the fleet.
	Description *string

	// Whether to create an Amazon Web Services IoT Role Alias during device fleet
	// creation. The name of the role alias generated will match this pattern:
	// "SageMakerEdge-{DeviceFleetName}". For example, if your device fleet is called
	// "demo-fleet", the name of the role alias will be "SageMakerEdge-demo-fleet".
	EnableIotRoleAlias *bool

	// The Amazon Resource Name (ARN) of the device.
	RoleArn *string

	noSmithyDocumentSerde
}

type UpdateDeviceFleetOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDeviceFleetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateDeviceFleet{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateDeviceFleet{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateDeviceFleetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDeviceFleet(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDeviceFleet(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "sagemaker",
		OperationName: "UpdateDeviceFleet",
	}
}
