//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmachinelearningservices

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AKS.
func (a AKS) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "computeLocation", a.ComputeLocation)
	objectMap["computeType"] = ComputeTypeAKS
	populateTimeRFC3339(objectMap, "createdOn", a.CreatedOn)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "disableLocalAuth", a.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", a.IsAttachedCompute)
	populateTimeRFC3339(objectMap, "modifiedOn", a.ModifiedOn)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "provisioningErrors", a.ProvisioningErrors)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "resourceId", a.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AKS.
func (a *AKS) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &a.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &a.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateTimeRFC3339(val, "CreatedOn", &a.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &a.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &a.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateTimeRFC3339(val, "ModifiedOn", &a.ModifiedOn)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &a.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &a.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AKSProperties.
func (a AKSProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentCount", a.AgentCount)
	populate(objectMap, "agentVmSize", a.AgentVMSize)
	populate(objectMap, "aksNetworkingConfiguration", a.AksNetworkingConfiguration)
	populate(objectMap, "clusterFqdn", a.ClusterFqdn)
	populate(objectMap, "clusterPurpose", a.ClusterPurpose)
	populate(objectMap, "loadBalancerSubnet", a.LoadBalancerSubnet)
	populate(objectMap, "loadBalancerType", a.LoadBalancerType)
	populate(objectMap, "sslConfiguration", a.SSLConfiguration)
	populate(objectMap, "systemServices", a.SystemServices)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AksComputeSecrets.
func (a *AksComputeSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminKubeConfig":
			err = unpopulate(val, "AdminKubeConfig", &a.AdminKubeConfig)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &a.ComputeType)
			delete(rawMsg, key)
		case "imagePullSecretName":
			err = unpopulate(val, "ImagePullSecretName", &a.ImagePullSecretName)
			delete(rawMsg, key)
		case "userKubeConfig":
			err = unpopulate(val, "UserKubeConfig", &a.UserKubeConfig)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlCompute.
func (a AmlCompute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "computeLocation", a.ComputeLocation)
	objectMap["computeType"] = ComputeTypeAmlCompute
	populateTimeRFC3339(objectMap, "createdOn", a.CreatedOn)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "disableLocalAuth", a.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", a.IsAttachedCompute)
	populateTimeRFC3339(objectMap, "modifiedOn", a.ModifiedOn)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "provisioningErrors", a.ProvisioningErrors)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "resourceId", a.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlCompute.
func (a *AmlCompute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &a.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &a.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateTimeRFC3339(val, "CreatedOn", &a.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &a.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &a.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateTimeRFC3339(val, "ModifiedOn", &a.ModifiedOn)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &a.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &a.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlComputeProperties.
func (a AmlComputeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allocationState", a.AllocationState)
	populateTimeRFC3339(objectMap, "allocationStateTransitionTime", a.AllocationStateTransitionTime)
	populate(objectMap, "currentNodeCount", a.CurrentNodeCount)
	populate(objectMap, "enableNodePublicIp", a.EnableNodePublicIP)
	populate(objectMap, "errors", a.Errors)
	populate(objectMap, "isolatedNetwork", a.IsolatedNetwork)
	populate(objectMap, "nodeStateCounts", a.NodeStateCounts)
	populate(objectMap, "osType", a.OSType)
	populate(objectMap, "remoteLoginPortPublicAccess", a.RemoteLoginPortPublicAccess)
	populate(objectMap, "scaleSettings", a.ScaleSettings)
	populate(objectMap, "subnet", a.Subnet)
	populate(objectMap, "targetNodeCount", a.TargetNodeCount)
	populate(objectMap, "userAccountCredentials", a.UserAccountCredentials)
	populate(objectMap, "vmPriority", a.VMPriority)
	populate(objectMap, "vmSize", a.VMSize)
	populate(objectMap, "virtualMachineImage", a.VirtualMachineImage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlComputeProperties.
func (a *AmlComputeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allocationState":
			err = unpopulate(val, "AllocationState", &a.AllocationState)
			delete(rawMsg, key)
		case "allocationStateTransitionTime":
			err = unpopulateTimeRFC3339(val, "AllocationStateTransitionTime", &a.AllocationStateTransitionTime)
			delete(rawMsg, key)
		case "currentNodeCount":
			err = unpopulate(val, "CurrentNodeCount", &a.CurrentNodeCount)
			delete(rawMsg, key)
		case "enableNodePublicIp":
			err = unpopulate(val, "EnableNodePublicIP", &a.EnableNodePublicIP)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &a.Errors)
			delete(rawMsg, key)
		case "isolatedNetwork":
			err = unpopulate(val, "IsolatedNetwork", &a.IsolatedNetwork)
			delete(rawMsg, key)
		case "nodeStateCounts":
			err = unpopulate(val, "NodeStateCounts", &a.NodeStateCounts)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &a.OSType)
			delete(rawMsg, key)
		case "remoteLoginPortPublicAccess":
			err = unpopulate(val, "RemoteLoginPortPublicAccess", &a.RemoteLoginPortPublicAccess)
			delete(rawMsg, key)
		case "scaleSettings":
			err = unpopulate(val, "ScaleSettings", &a.ScaleSettings)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &a.Subnet)
			delete(rawMsg, key)
		case "targetNodeCount":
			err = unpopulate(val, "TargetNodeCount", &a.TargetNodeCount)
			delete(rawMsg, key)
		case "userAccountCredentials":
			err = unpopulate(val, "UserAccountCredentials", &a.UserAccountCredentials)
			delete(rawMsg, key)
		case "vmPriority":
			err = unpopulate(val, "VMPriority", &a.VMPriority)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &a.VMSize)
			delete(rawMsg, key)
		case "virtualMachineImage":
			err = unpopulate(val, "VirtualMachineImage", &a.VirtualMachineImage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterUpdateParameters.
func (c ClusterUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Components1D3SwueSchemasComputeresourceAllof1.
func (c Components1D3SwueSchemasComputeresourceAllof1) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Components1D3SwueSchemasComputeresourceAllof1.
func (c *Components1D3SwueSchemasComputeresourceAllof1) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			c.Properties, err = unmarshalComputeClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Compute.
func (c Compute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "computeLocation", c.ComputeLocation)
	objectMap["computeType"] = c.ComputeType
	populateTimeRFC3339(objectMap, "createdOn", c.CreatedOn)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "disableLocalAuth", c.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", c.IsAttachedCompute)
	populateTimeRFC3339(objectMap, "modifiedOn", c.ModifiedOn)
	populate(objectMap, "provisioningErrors", c.ProvisioningErrors)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "resourceId", c.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Compute.
func (c *Compute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &c.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &c.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateTimeRFC3339(val, "CreatedOn", &c.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &c.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &c.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateTimeRFC3339(val, "ModifiedOn", &c.ModifiedOn)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &c.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &c.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeInstance.
func (c ComputeInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "computeLocation", c.ComputeLocation)
	objectMap["computeType"] = ComputeTypeComputeInstance
	populateTimeRFC3339(objectMap, "createdOn", c.CreatedOn)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "disableLocalAuth", c.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", c.IsAttachedCompute)
	populateTimeRFC3339(objectMap, "modifiedOn", c.ModifiedOn)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "provisioningErrors", c.ProvisioningErrors)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "resourceId", c.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeInstance.
func (c *ComputeInstance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &c.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &c.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateTimeRFC3339(val, "CreatedOn", &c.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &c.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &c.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateTimeRFC3339(val, "ModifiedOn", &c.ModifiedOn)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &c.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &c.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeInstanceLastOperation.
func (c ComputeInstanceLastOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "operationName", c.OperationName)
	populate(objectMap, "operationStatus", c.OperationStatus)
	populateTimeRFC3339(objectMap, "operationTime", c.OperationTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeInstanceLastOperation.
func (c *ComputeInstanceLastOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operationName":
			err = unpopulate(val, "OperationName", &c.OperationName)
			delete(rawMsg, key)
		case "operationStatus":
			err = unpopulate(val, "OperationStatus", &c.OperationStatus)
			delete(rawMsg, key)
		case "operationTime":
			err = unpopulateTimeRFC3339(val, "OperationTime", &c.OperationTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeInstanceProperties.
func (c ComputeInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "applicationSharingPolicy", c.ApplicationSharingPolicy)
	populate(objectMap, "applications", c.Applications)
	populate(objectMap, "computeInstanceAuthorizationType", c.ComputeInstanceAuthorizationType)
	populate(objectMap, "connectivityEndpoints", c.ConnectivityEndpoints)
	populate(objectMap, "createdBy", c.CreatedBy)
	populate(objectMap, "errors", c.Errors)
	populate(objectMap, "lastOperation", c.LastOperation)
	populate(objectMap, "personalComputeInstanceSettings", c.PersonalComputeInstanceSettings)
	populate(objectMap, "sshSettings", c.SSHSettings)
	populate(objectMap, "setupScripts", c.SetupScripts)
	populate(objectMap, "state", c.State)
	populate(objectMap, "subnet", c.Subnet)
	populate(objectMap, "vmSize", c.VMSize)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ComputeResource.
func (c ComputeResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "identity", c.Identity)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "sku", c.SKU)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeResource.
func (c *ComputeResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &c.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			c.Properties, err = unmarshalComputeClassification(val)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &c.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataFactory.
func (d DataFactory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "computeLocation", d.ComputeLocation)
	objectMap["computeType"] = ComputeTypeDataFactory
	populateTimeRFC3339(objectMap, "createdOn", d.CreatedOn)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "disableLocalAuth", d.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", d.IsAttachedCompute)
	populateTimeRFC3339(objectMap, "modifiedOn", d.ModifiedOn)
	populate(objectMap, "provisioningErrors", d.ProvisioningErrors)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "resourceId", d.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataFactory.
func (d *DataFactory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &d.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &d.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateTimeRFC3339(val, "CreatedOn", &d.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &d.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &d.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateTimeRFC3339(val, "ModifiedOn", &d.ModifiedOn)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &d.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &d.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataLakeAnalytics.
func (d DataLakeAnalytics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "computeLocation", d.ComputeLocation)
	objectMap["computeType"] = ComputeTypeDataLakeAnalytics
	populateTimeRFC3339(objectMap, "createdOn", d.CreatedOn)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "disableLocalAuth", d.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", d.IsAttachedCompute)
	populateTimeRFC3339(objectMap, "modifiedOn", d.ModifiedOn)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "provisioningErrors", d.ProvisioningErrors)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "resourceId", d.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataLakeAnalytics.
func (d *DataLakeAnalytics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &d.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &d.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateTimeRFC3339(val, "CreatedOn", &d.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &d.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &d.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateTimeRFC3339(val, "ModifiedOn", &d.ModifiedOn)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &d.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &d.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Databricks.
func (d Databricks) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "computeLocation", d.ComputeLocation)
	objectMap["computeType"] = ComputeTypeDatabricks
	populateTimeRFC3339(objectMap, "createdOn", d.CreatedOn)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "disableLocalAuth", d.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", d.IsAttachedCompute)
	populateTimeRFC3339(objectMap, "modifiedOn", d.ModifiedOn)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "provisioningErrors", d.ProvisioningErrors)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "resourceId", d.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Databricks.
func (d *Databricks) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &d.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &d.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateTimeRFC3339(val, "CreatedOn", &d.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &d.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &d.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateTimeRFC3339(val, "ModifiedOn", &d.ModifiedOn)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &d.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &d.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabricksComputeSecrets.
func (d *DatabricksComputeSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeType":
			err = unpopulate(val, "ComputeType", &d.ComputeType)
			delete(rawMsg, key)
		case "databricksAccessToken":
			err = unpopulate(val, "DatabricksAccessToken", &d.DatabricksAccessToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnoseRequestProperties.
func (d DiagnoseRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "applicationInsights", d.ApplicationInsights)
	populate(objectMap, "containerRegistry", d.ContainerRegistry)
	populate(objectMap, "dnsResolution", d.DNSResolution)
	populate(objectMap, "keyVault", d.KeyVault)
	populate(objectMap, "nsg", d.Nsg)
	populate(objectMap, "others", d.Others)
	populate(objectMap, "resourceLock", d.ResourceLock)
	populate(objectMap, "storageAccount", d.StorageAccount)
	populate(objectMap, "udr", d.Udr)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type HDInsight.
func (h HDInsight) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "computeLocation", h.ComputeLocation)
	objectMap["computeType"] = ComputeTypeHDInsight
	populateTimeRFC3339(objectMap, "createdOn", h.CreatedOn)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "disableLocalAuth", h.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", h.IsAttachedCompute)
	populateTimeRFC3339(objectMap, "modifiedOn", h.ModifiedOn)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "provisioningErrors", h.ProvisioningErrors)
	populate(objectMap, "provisioningState", h.ProvisioningState)
	populate(objectMap, "resourceId", h.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HDInsight.
func (h *HDInsight) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &h.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &h.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateTimeRFC3339(val, "CreatedOn", &h.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &h.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &h.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateTimeRFC3339(val, "ModifiedOn", &h.ModifiedOn)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &h.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &h.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &h.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", i.PrincipalID)
	populate(objectMap, "tenantId", i.TenantID)
	populate(objectMap, "type", i.Type)
	populate(objectMap, "userAssignedIdentities", i.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type InstanceTypeSchema.
func (i InstanceTypeSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nodeSelector", i.NodeSelector)
	populate(objectMap, "resources", i.Resources)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type InstanceTypeSchemaResources.
func (i InstanceTypeSchemaResources) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "limits", i.Limits)
	populate(objectMap, "requests", i.Requests)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Kubernetes.
func (k Kubernetes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "computeLocation", k.ComputeLocation)
	objectMap["computeType"] = ComputeTypeKubernetes
	populateTimeRFC3339(objectMap, "createdOn", k.CreatedOn)
	populate(objectMap, "description", k.Description)
	populate(objectMap, "disableLocalAuth", k.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", k.IsAttachedCompute)
	populateTimeRFC3339(objectMap, "modifiedOn", k.ModifiedOn)
	populate(objectMap, "properties", k.Properties)
	populate(objectMap, "provisioningErrors", k.ProvisioningErrors)
	populate(objectMap, "provisioningState", k.ProvisioningState)
	populate(objectMap, "resourceId", k.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Kubernetes.
func (k *Kubernetes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &k.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &k.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateTimeRFC3339(val, "CreatedOn", &k.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &k.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &k.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &k.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateTimeRFC3339(val, "ModifiedOn", &k.ModifiedOn)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &k.Properties)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &k.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &k.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &k.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesProperties.
func (k KubernetesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "defaultInstanceType", k.DefaultInstanceType)
	populate(objectMap, "extensionInstanceReleaseTrain", k.ExtensionInstanceReleaseTrain)
	populate(objectMap, "extensionPrincipalId", k.ExtensionPrincipalID)
	populate(objectMap, "instanceTypes", k.InstanceTypes)
	populate(objectMap, "namespace", k.Namespace)
	populate(objectMap, "relayConnectionString", k.RelayConnectionString)
	populate(objectMap, "serviceBusConnectionString", k.ServiceBusConnectionString)
	populate(objectMap, "vcName", k.VcName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnection.
func (p PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "identity", p.Identity)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResource.
func (p PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "identity", p.Identity)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type QuotaUpdateParameters.
func (q QuotaUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", q.Location)
	populate(objectMap, "value", q.Value)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SynapseSpark.
func (s SynapseSpark) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "computeLocation", s.ComputeLocation)
	objectMap["computeType"] = ComputeTypeSynapseSpark
	populateTimeRFC3339(objectMap, "createdOn", s.CreatedOn)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "disableLocalAuth", s.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", s.IsAttachedCompute)
	populateTimeRFC3339(objectMap, "modifiedOn", s.ModifiedOn)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "provisioningErrors", s.ProvisioningErrors)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "resourceId", s.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SynapseSpark.
func (s *SynapseSpark) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &s.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &s.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateTimeRFC3339(val, "CreatedOn", &s.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &s.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &s.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateTimeRFC3339(val, "ModifiedOn", &s.ModifiedOn)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &s.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &s.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachine.
func (v VirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "computeLocation", v.ComputeLocation)
	objectMap["computeType"] = ComputeTypeVirtualMachine
	populateTimeRFC3339(objectMap, "createdOn", v.CreatedOn)
	populate(objectMap, "description", v.Description)
	populate(objectMap, "disableLocalAuth", v.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", v.IsAttachedCompute)
	populateTimeRFC3339(objectMap, "modifiedOn", v.ModifiedOn)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "provisioningErrors", v.ProvisioningErrors)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "resourceId", v.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachine.
func (v *VirtualMachine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &v.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &v.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateTimeRFC3339(val, "CreatedOn", &v.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &v.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &v.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &v.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateTimeRFC3339(val, "ModifiedOn", &v.ModifiedOn)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &v.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &v.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineSecrets.
func (v *VirtualMachineSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administratorAccount":
			err = unpopulate(val, "AdministratorAccount", &v.AdministratorAccount)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &v.ComputeType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", w.ID)
	populate(objectMap, "identity", w.Identity)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "sku", w.SKU)
	populate(objectMap, "systemData", w.SystemData)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceProperties.
func (w WorkspaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowPublicAccessWhenBehindVnet", w.AllowPublicAccessWhenBehindVnet)
	populate(objectMap, "applicationInsights", w.ApplicationInsights)
	populate(objectMap, "containerRegistry", w.ContainerRegistry)
	populate(objectMap, "description", w.Description)
	populate(objectMap, "discoveryUrl", w.DiscoveryURL)
	populate(objectMap, "encryption", w.Encryption)
	populate(objectMap, "friendlyName", w.FriendlyName)
	populate(objectMap, "hbiWorkspace", w.HbiWorkspace)
	populate(objectMap, "imageBuildCompute", w.ImageBuildCompute)
	populate(objectMap, "keyVault", w.KeyVault)
	populate(objectMap, "mlFlowTrackingUri", w.MlFlowTrackingURI)
	populate(objectMap, "notebookInfo", w.NotebookInfo)
	populate(objectMap, "primaryUserAssignedIdentity", w.PrimaryUserAssignedIdentity)
	populate(objectMap, "privateEndpointConnections", w.PrivateEndpointConnections)
	populate(objectMap, "privateLinkCount", w.PrivateLinkCount)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", w.PublicNetworkAccess)
	populate(objectMap, "serviceManagedResourcesSettings", w.ServiceManagedResourcesSettings)
	populate(objectMap, "serviceProvisionedResourceGroup", w.ServiceProvisionedResourceGroup)
	populate(objectMap, "sharedPrivateLinkResources", w.SharedPrivateLinkResources)
	populate(objectMap, "storageAccount", w.StorageAccount)
	populate(objectMap, "storageHnsEnabled", w.StorageHnsEnabled)
	populate(objectMap, "tenantId", w.TenantID)
	populate(objectMap, "workspaceId", w.WorkspaceID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceUpdateParameters.
func (w WorkspaceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", w.Identity)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "sku", w.SKU)
	populate(objectMap, "tags", w.Tags)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
