/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header.ims;

import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.header.AddressParametersHeader;
import gov.nist.javax.sip.header.ims.PAssociatedURIHeader;
import gov.nist.javax.sip.header.ims.SIPHeaderNamesIms;
import java.text.ParseException;
import javax.sip.address.URI;
import javax.sip.header.ExtensionHeader;

public class PAssociatedURI
extends AddressParametersHeader
implements PAssociatedURIHeader,
SIPHeaderNamesIms,
ExtensionHeader {
    public PAssociatedURI() {
        super("P-Associated-URI");
    }

    public PAssociatedURI(AddressImpl address) {
        super("P-Associated-URI");
        this.address = address;
    }

    public PAssociatedURI(GenericURI associatedURI) {
        super("P-Associated-URI");
        this.address = new AddressImpl();
        this.address.setURI(associatedURI);
    }

    @Override
    public StringBuilder encodeBody(StringBuilder retval) {
        if (this.address.getAddressType() == 2) {
            retval.append("<");
        }
        this.address.encode(retval);
        if (this.address.getAddressType() == 2) {
            retval.append(">");
        }
        if (!this.parameters.isEmpty()) {
            retval = retval.append(";");
            retval = this.parameters.encode(retval);
        }
        return retval;
    }

    @Override
    public void setAssociatedURI(URI associatedURI) throws NullPointerException {
        if (associatedURI == null) {
            throw new NullPointerException("null URI");
        }
        this.address.setURI(associatedURI);
    }

    @Override
    public URI getAssociatedURI() {
        return this.address.getURI();
    }

    @Override
    public Object clone() {
        PAssociatedURI retval = (PAssociatedURI)super.clone();
        if (this.address != null) {
            retval.address = (AddressImpl)this.address.clone();
        }
        return retval;
    }

    public void setValue(String value2) throws ParseException {
        throw new ParseException(value2, 0);
    }
}

