/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class WondexProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().number("[^d]*").number("(d+),").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd),").number("(-?d+.d+),").number("(-?d+.d+),").number("(d+),").number("(d+),").number("(-?d+.?d*),").number("(d+),").number("(d+),?").number("(d+.d+)V,").optional().number("(d+.d+)?,?").number("(d+)?,?").number("(d+.d+)?,?").number("(d+.d+)?,?").number("(d+)?").any().compile();

    public WondexProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (buf.getUnsignedByte(0) == 208) {
            long deviceId = Long.reverseBytes(buf.getLong(0)) >> 32 & 0xFFFFFFFFL;
            this.getDeviceSession(channel, remoteAddress, String.valueOf(deviceId));
            return null;
        }
        if (buf.toString(StandardCharsets.US_ASCII).startsWith("$OK:") || buf.toString(StandardCharsets.US_ASCII).startsWith("$ERR:") || buf.toString(StandardCharsets.US_ASCII).startsWith("$MSG:")) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, new Date());
            position.set("result", buf.toString(StandardCharsets.US_ASCII));
            return position;
        }
        Parser parser = new Parser(PATTERN, buf.toString(StandardCharsets.US_ASCII));
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime());
        position.setLongitude(parser.nextDouble(0.0));
        position.setLatitude(parser.nextDouble(0.0));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
        position.setCourse(parser.nextDouble(0.0));
        position.setAltitude(parser.nextDouble(0.0));
        int satellites = parser.nextInt(0);
        position.setValid(satellites != 0);
        position.set("sat", satellites);
        position.set("event", parser.next());
        position.set("battery", parser.nextDouble());
        if (parser.hasNext()) {
            position.set("odometer", parser.nextDouble(0.0) * 1000.0);
        }
        position.set("input", parser.next());
        position.set("adc1", parser.next());
        position.set("adc2", parser.next());
        position.set("output", parser.next());
        return position;
    }
}

