/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.helper.DataConverter;
import org.traccar.model.Command;

public class Minifinder2ProtocolEncoder
extends BaseProtocolEncoder {
    public Minifinder2ProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private ByteBuf encodeContent(ByteBuf content) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(171);
        buf.writeByte(0);
        buf.writeShortLE(content.readableBytes());
        buf.writeShortLE(Checksum.crc16(Checksum.CRC16_XMODEM, content.nioBuffer()));
        buf.writeShortLE(1);
        buf.writeBytes(content);
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        if (command.getType().equals("configuration")) {
            ByteBuf content = Unpooled.buffer();
            content.writeByte(2);
            if (command.hasAttribute("data")) {
                byte[] data = DataConverter.parseHex(command.getString("data"));
                content.writeBytes(data);
            } else {
                content.writeByte(1);
                content.writeByte(240);
            }
            return this.encodeContent(content);
        }
        if ("Nano".equalsIgnoreCase(this.getDeviceModel(command.getDeviceId()))) {
            ByteBuf content = Unpooled.buffer();
            if (command.getType().equals("firmwareUpdate")) {
                String url = command.getString("data");
                content.writeByte(4);
                content.writeByte(1 + url.length());
                content.writeByte(48);
                content.writeCharSequence((CharSequence)url, StandardCharsets.US_ASCII);
                return this.encodeContent(content);
            }
        }
        return null;
    }
}

