/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.Bundle;
import org.netbeans.modules.maven.execute.MavenCommandLineExecutor;
import org.netbeans.modules.maven.execute.MavenExecutor;
import org.netbeans.modules.maven.execute.OutputTabMaintainer;
import org.netbeans.modules.maven.execute.cmd.ExecutionEventObject;
import org.netbeans.modules.maven.execute.ui.RunGoalsPanel;
import org.netbeans.modules.maven.execute.ui.ShowExecutionPanel;
import org.netbeans.spi.project.ui.support.BuildExecutionSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;

public abstract class AbstractMavenExecutor
extends OutputTabMaintainer<TabContext>
implements MavenExecutor,
Cancellable {
    protected RunConfig config;
    private TabContext tabContext;
    private List<String> messages = new ArrayList<String>();
    private List<OutputListener> listeners = new ArrayList<OutputListener>();
    protected ExecutorTask task;
    protected MavenItem item;
    protected final Object SEMAPHORE = new Object();

    @Override
    protected Class<TabContext> tabContextType() {
        return TabContext.class;
    }

    protected AbstractMavenExecutor(RunConfig conf) {
        this(conf, new TabContext());
    }

    AbstractMavenExecutor(RunConfig conf, TabContext tc) {
        super(conf.getExecutionName());
        this.config = conf;
        this.tabContext = tc == null ? new TabContext() : tc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setTask(ExecutorTask task) {
        Object object = this.SEMAPHORE;
        synchronized (object) {
            this.task = task;
            this.item = new MavenItem();
            this.SEMAPHORE.notifyAll();
        }
    }

    @Override
    public final void addInitialMessage(String line, OutputListener listener) {
        this.messages.add(line);
        this.listeners.add(listener);
    }

    protected final void processInitialMessage() {
        Iterator<String> it1 = this.messages.iterator();
        Iterator<OutputListener> it2 = this.listeners.iterator();
        InputOutput ioput = this.getInputOutput();
        try {
            while (it1.hasNext()) {
                OutputListener ol = it2.next();
                if (ol != null) {
                    ioput.getErr().println(it1.next(), ol, true);
                    continue;
                }
                ioput.getErr().println(it1.next());
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected final void actionStatesAtStart() {
        AbstractMavenExecutor.updateUILater(false, () -> {
            this.createNewTabActions();
            this.tabContext.rerun.setEnabled(false);
            this.tabContext.rerunDebug.setEnabled(false);
            this.tabContext.overview.setRoot(null);
            this.tabContext.resume.setFinder(null);
            this.tabContext.stop.setEnabled(true);
        });
    }

    protected final void actionStatesAtFinish(@NullAllowed ResumeFromFinder resumeFromFinder, @NullAllowed ExecutionEventObject.Tree root) {
        AbstractMavenExecutor.updateUILater(false, () -> {
            this.createNewTabActions();
            this.tabContext.rerun.setEnabled(true);
            this.tabContext.rerunDebug.setEnabled(true);
            this.tabContext.resume.setFinder(resumeFromFinder);
            this.tabContext.overview.setRoot(root);
            this.tabContext.stop.setEnabled(false);
        });
    }

    @Override
    protected void reassignAdditionalContext(TabContext tabContext) {
        this.tabContext = tabContext;
        tabContext.rerun.setConfig(this.config);
        tabContext.rerunDebug.setConfig(this.config);
        tabContext.resume.setConfig(this.config);
        tabContext.stop.setExecutor(this);
        tabContext.overview.setExecutor((MavenCommandLineExecutor)this);
        tabContext.overview.setRoot(null);
    }

    @Override
    protected final TabContext createContext() {
        return this.tabContext.clone();
    }

    @Override
    protected Action[] createNewTabActions() {
        if (this.tabContext.rerun == null) {
            this.tabContext.rerun = new ReRunAction(false);
            this.tabContext.rerunDebug = new ReRunAction(true);
            this.tabContext.resume = new ResumeAction();
            this.tabContext.stop = new StopAction();
            this.tabContext.options = new OptionsAction();
            this.tabContext.overview = new ShowOverviewAction();
        }
        this.tabContext.rerun.setConfig(this.config);
        this.tabContext.rerunDebug.setConfig(this.config);
        this.tabContext.resume.setConfig(this.config);
        this.tabContext.overview.setExecutor((MavenCommandLineExecutor)this);
        this.tabContext.stop.setExecutor(this);
        return new Action[]{this.tabContext.rerun, this.tabContext.rerunDebug, this.tabContext.resume, this.tabContext.overview, this.tabContext.stop, this.tabContext.options};
    }

    private static void updateUILater(boolean asap, Runnable ui) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        if (asap && EventQueue.isDispatchThread()) {
            ui.run();
        } else {
            EventQueue.invokeLater(ui);
        }
    }

    public static final class TabContext {
        ReRunAction rerun;
        ReRunAction rerunDebug;
        ResumeAction resume;
        ShowOverviewAction overview;
        StopAction stop;
        OptionsAction options;

        protected TabContext clone() {
            TabContext c = new TabContext();
            c.rerun = this.rerun;
            c.rerunDebug = this.rerunDebug;
            c.resume = this.resume;
            c.overview = this.overview;
            c.stop = this.stop;
            c.options = this.options;
            return c;
        }
    }

    protected class MavenItem
    implements BuildExecutionSupport.ActionItem {
        protected MavenItem() {
        }

        public String getDisplayName() {
            return AbstractMavenExecutor.this.config.getTaskDisplayName();
        }

        public void repeatExecution() {
            RunUtils.executeMaven(AbstractMavenExecutor.this.config);
        }

        public boolean isRunning() {
            return !AbstractMavenExecutor.this.task.isFinished();
        }

        public void stopRunning() {
            AbstractMavenExecutor.this.cancel();
        }

        public String getAction() {
            return AbstractMavenExecutor.this.config.getActionName() != null ? AbstractMavenExecutor.this.config.getActionName() : "xxx-custom";
        }

        public FileObject getProjectDirectory() {
            return AbstractMavenExecutor.this.config.getProject() != null ? AbstractMavenExecutor.this.config.getProject().getProjectDirectory() : null;
        }

        public int hashCode() {
            int hash = 5;
            hash = 41 * hash + this.getAction().hashCode();
            hash = 41 * hash + this.getProjectDirectory().hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MavenItem other = (MavenItem)obj;
            if (!this.getAction().equals(other.getAction())) {
                return false;
            }
            return this.getProjectDirectory() == other.getProjectDirectory() || this.getProjectDirectory() != null && this.getProjectDirectory().equals(other.getProjectDirectory());
        }
    }

    protected static interface ResumeFromFinder {
        @CheckForNull
        public NbMavenProject find(@NonNull Project var1);
    }

    class ReRunAction
    extends AbstractAction {
        private RunConfig config;
        private boolean debug;

        ReRunAction(boolean debug) {
            this.debug = debug;
            this.putValue("SmallIcon", debug ? ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/refreshdebug.png", (boolean)false) : ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/refresh.png", (boolean)false));
            this.putValue("Name", debug ? Bundle.TXT_Rerun_extra() : Bundle.TXT_Rerun());
            this.putValue("ShortDescription", debug ? Bundle.TIP_Rerun_Extra() : Bundle.TIP_Rerun());
            this.setEnabled(false);
        }

        void setConfig(RunConfig config) {
            this.config = config;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BeanRunConfig newConfig = new BeanRunConfig(this.config);
            if (this.debug) {
                RunGoalsPanel pnl = new RunGoalsPanel();
                DialogDescriptor dd = new DialogDescriptor((Object)pnl, Bundle.TIT_Run_maven());
                pnl.readConfig(this.config);
                Object retValue = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                if (retValue == DialogDescriptor.OK_OPTION) {
                    pnl.applyValues(newConfig);
                } else {
                    return;
                }
            }
            AbstractMavenExecutor.this.actionStatesAtStart();
            InputOutput inputOutput = AbstractMavenExecutor.this.getInputOutput();
            try {
                inputOutput.getOut().reset();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            MavenCommandLineExecutor.executeMaven(newConfig, inputOutput, AbstractMavenExecutor.this.tabContext);
        }
    }

    private static class ResumeAction
    extends AbstractAction {
        private static final RequestProcessor RP = new RequestProcessor(ResumeAction.class);
        private RunConfig config;
        private ResumeFromFinder finder;

        ResumeAction() {
            this.setEnabled(false);
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/forward.png", (boolean)true));
            this.putValue("ShortDescription", Bundle.TIP_resume());
        }

        void setConfig(RunConfig config) {
            this.config = config;
        }

        void setFinder(ResumeFromFinder finder) {
            this.finder = finder;
            this.setEnabled(finder != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final Project p = this.config.getProject();
            if (p == null) {
                this.setFinder(null);
                StatusDisplayer.getDefault().setStatusText(Bundle.ResumeAction_could_not_find_module());
                return;
            }
            final AtomicReference t = new AtomicReference();
            final ProgressHandle handle = ProgressHandle.createHandle((String)Bundle.ResumeAction_scanning(), (Cancellable)new Cancellable(){

                public boolean cancel() {
                    Thread _t = (Thread)t.get();
                    if (_t != null) {
                        _t.interrupt();
                        return true;
                    }
                    return false;
                }
            });
            RP.post(new Runnable(){

                @Override
                public void run() {
                    NbMavenProject nbmp;
                    t.set(Thread.currentThread());
                    handle.start();
                    try {
                        nbmp = finder.find(p);
                    }
                    finally {
                        handle.finish();
                    }
                    t.set(null);
                    if (nbmp == null || NbMavenProject.isErrorPlaceholder(nbmp.getMavenProject())) {
                        this.setFinder(null);
                        StatusDisplayer.getDefault().setStatusText(Bundle.ResumeAction_could_not_find_module());
                        return;
                    }
                    File root = config.getExecutionDirectory();
                    File module = nbmp.getMavenProject().getBasedir();
                    String rel = root != null && module != null ? FileUtilities.relativizeFile(root, module) : null;
                    String id = rel != null ? rel : nbmp.getMavenProject().getGroupId() + ":" + nbmp.getMavenProject().getArtifactId();
                    BeanRunConfig newConfig = new BeanRunConfig(config);
                    ArrayList<String> goals = new ArrayList<String>(config.getGoals());
                    int rf = goals.indexOf("--resume-from");
                    if (rf != -1) {
                        goals.set(rf + 1, id);
                    } else {
                        goals.add(0, "--resume-from");
                        goals.add(1, id);
                    }
                    newConfig.setGoals(goals);
                    RunUtils.executeMaven(newConfig);
                }
            });
        }
    }

    static class StopAction
    extends AbstractAction {
        private AbstractMavenExecutor exec;

        StopAction() {
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/stop.png", (boolean)false));
            this.putValue("Name", Bundle.TXT_Stop_execution());
            this.putValue("ShortDescription", Bundle.TIP_Stop_Execution());
            this.setEnabled(false);
        }

        void setExecutor(AbstractMavenExecutor ex) {
            this.exec = ex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    exec.cancel();
                }
            });
        }
    }

    private static final class ShowOverviewAction
    extends AbstractAction {
        private MavenCommandLineExecutor executor;
        private ExecutionEventObject.Tree root;
        private Dialog d;

        ShowOverviewAction() {
            super(Bundle.LBL_ShowOverviewAction(), ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/ui/buildplangoals.png", (boolean)true));
            this.putValue("ShortDescription", Bundle.LBL_ShowOverviewAction());
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.root == null) {
                return;
            }
            ShowExecutionPanel panel = new ShowExecutionPanel();
            panel.setTreeToDisplay(this.root, this.executor != null ? this.executor.config : null);
            DialogDescriptor dd = new DialogDescriptor((Object)panel, "Build execution overview");
            dd.setOptions(new Object[]{"Close"});
            dd.setClosingOptions(new Object[]{"Close"});
            this.d = DialogDisplayer.getDefault().createDialog(dd);
            this.d.setModal(false);
            this.d.setVisible(true);
        }

        private void setExecutor(MavenCommandLineExecutor aThis) {
            this.executor = aThis;
            AbstractMavenExecutor.updateUILater(false, () -> {
                if (this.d != null && this.d.isVisible()) {
                    this.d.setVisible(false);
                    this.d = null;
                }
            });
        }

        private void setRoot(ExecutionEventObject.Tree root) {
            this.root = root;
            AbstractMavenExecutor.updateUILater(true, () -> this.setEnabled(root != null));
        }
    }

    public static final class OptionsAction
    extends AbstractAction {
        public OptionsAction() {
            super(Bundle.LBL_OptionsAction(), ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/options.png", (boolean)true));
            this.putValue("ShortDescription", Bundle.LBL_OptionsAction());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptionsDisplayer.getDefault().open("Java/Maven");
        }
    }
}

