/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.notifications.filter;

import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.notifications.center.NotificationCenterManager;
import org.netbeans.modules.notifications.checklist.CheckList;
import org.netbeans.modules.notifications.filter.CategoryFilter;
import org.openide.awt.NotificationDisplayer;

final class CateogoriesPanel
extends JPanel {
    private CheckList lstTypes;
    private List<NotificationDisplayer.Category> categories;
    private boolean[] categoryState;
    private CategoryFilter filter;
    private JScrollPane scrollTypes;

    public CateogoriesPanel(CategoryFilter filter) {
        this.filter = filter;
        this.init();
        if ("Metal".equals(UIManager.getLookAndFeel().getID())) {
            this.setOpaque(true);
        } else {
            this.setOpaque(false);
        }
    }

    public boolean isValueValid() {
        return true;
    }

    private void init() {
        this.initComponents();
        this.categories = NotificationCenterManager.getInstance().getCategories();
        this.categoryState = new boolean[this.categories.size()];
        Object[] names = new String[this.categories.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.categories.get(i).getDisplayName();
        }
        String[] descs = new String[this.categories.size()];
        for (int i = 0; i < descs.length; ++i) {
            descs[i] = this.categories.get(i).getDescription();
        }
        this.lstTypes = new CheckList(this.categoryState, names, descs);
        this.lstTypes.setSelectionMode(0);
        this.lstTypes.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent arg0) {
            }

            @Override
            public void intervalRemoved(ListDataEvent arg0) {
            }

            @Override
            public void contentsChanged(ListDataEvent arg0) {
                CateogoriesPanel.this.putClientProperty("filterValueValid", CateogoriesPanel.this.isValueValid());
            }
        });
        this.scrollTypes.setViewportView(this.lstTypes);
        this.showFilter(this.filter);
    }

    private void showFilter(CategoryFilter filter) {
        for (int i = 0; i < this.categoryState.length; ++i) {
            NotificationDisplayer.Category category = this.categories.get(i);
            this.categoryState[i] = null != filter && filter.isEnabled(category.getName());
        }
        this.lstTypes.setEnabled(null != filter);
    }

    private void initComponents() {
        this.scrollTypes = new JScrollPane();
        this.setOpaque(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scrollTypes, -1, 442, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scrollTypes, -1, 181, Short.MAX_VALUE).addContainerGap()));
    }

    public CategoryFilter getFilter() {
        if (this.filter != null) {
            for (int i = 0; i < this.categoryState.length; ++i) {
                NotificationDisplayer.Category category = this.categories.get(i);
                this.filter.setEnabled(category.getName(), this.categoryState[i]);
            }
        }
        return this.filter;
    }
}

