/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.FacesLogger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Timer {
    private static final Logger LOGGER = FacesLogger.TIMING.getLogger();
    long start;
    long stop;

    private Timer() {
    }

    public static Timer getInstance() {
        if (LOGGER.isLoggable(Level.FINE)) {
            return new Timer();
        }
        return null;
    }

    public void startTiming() {
        this.start = System.currentTimeMillis();
    }

    public void stopTiming() {
        this.stop = System.currentTimeMillis();
    }

    public void logResult(String taskInfo) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, " [TIMING] - [" + this.getTimingResult() + "ms] : " + taskInfo);
        }
    }

    private long getTimingResult() {
        return this.stop - this.start;
    }
}

