/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.nodes;

import java.awt.Image;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUIUtils;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public abstract class AnnotatedAbstractNode
extends AbstractNode
implements FileStatusListener,
Runnable {
    private Set<FileObject> files;
    private Map<FileSystem, FileStatusListener> fileSystemListeners;
    private RequestProcessor.Task task;
    private final Object privateLock = new Object();
    private boolean iconChange;
    private boolean nameChange;
    private static final RequestProcessor RP = new RequestProcessor(AnnotatedAbstractNode.class);

    public AnnotatedAbstractNode(Children childs, Lookup lookup) {
        super(childs, lookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setFiles(Set<FileObject> files) {
        if (this.fileSystemListeners != null) {
            for (Map.Entry<FileSystem, FileStatusListener> e : this.fileSystemListeners.entrySet()) {
                e.getKey().removeFileStatusListener(e.getValue());
            }
        }
        this.fileSystemListeners = new HashMap<FileSystem, FileStatusListener>();
        Object object = this.privateLock;
        synchronized (object) {
            this.files = files;
            if (files == null) {
                return;
            }
            HashSet<FileSystem> hookedFileSystems = new HashSet<FileSystem>();
            for (FileObject fo : files) {
                try {
                    FileSystem fs = fo.getFileSystem();
                    if (hookedFileSystems.contains(fs)) continue;
                    hookedFileSystems.add(fs);
                    FileStatusListener fsl = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fs);
                    fs.addFileStatusListener(fsl);
                    this.fileSystemListeners.put(fs, fsl);
                }
                catch (FileStateInvalidException e) {
                    ErrorManager err = ErrorManager.getDefault();
                    err.annotate((Throwable)e, 0, "Cannot get " + fo + " filesystem, ignoring...", null, null, null);
                    err.notify(1, (Throwable)e);
                }
            }
        }
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean fireName;
        boolean fireIcon;
        Object object = this.privateLock;
        synchronized (object) {
            fireIcon = this.iconChange;
            fireName = this.nameChange;
            this.iconChange = false;
            this.nameChange = false;
        }
        if (fireIcon) {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }
        if (fireName) {
            this.fireDisplayNameChange(null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotationChanged(FileStatusEvent event) {
        if (this.task == null) {
            this.task = RP.create((Runnable)this);
        }
        Object object = this.privateLock;
        synchronized (object) {
            if (!this.iconChange && event.isIconChange() || !this.nameChange && event.isNameChange()) {
                for (FileObject fo : this.files) {
                    if (!event.hasChanged(fo)) continue;
                    this.iconChange |= event.isIconChange();
                    this.nameChange |= event.isNameChange();
                }
            }
        }
        this.task.schedule(50);
    }

    protected abstract Image getIconImpl(int var1);

    protected abstract Image getOpenedIconImpl(int var1);

    public final Image getIcon(int param) {
        Image img = this.getIconImpl(param);
        return this.annotateImpl(img, param);
    }

    public final Image getOpenedIcon(int param) {
        Image img = this.getOpenedIconImpl(param);
        return this.annotateImpl(img, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image annotateImpl(Image img, int param) {
        Object object = this.privateLock;
        synchronized (object) {
            if (this.files != null && this.files.size() > 0) {
                try {
                    Iterator<FileObject> it = this.files.iterator();
                    assert (it.hasNext());
                    FileObject fo = it.next();
                    assert (fo != null);
                    FileSystem fs = fo.getFileSystem();
                    assert (fs != null);
                    return FileUIUtils.getImageDecorator((FileSystem)fs).annotateIcon(img, param, this.files);
                }
                catch (FileStateInvalidException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        }
        return img;
    }
}

