/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.gradle.api.Action;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.Model;

public class BulkModelRetriever {
    private static final AtomicInteger TASK_SEQUENCE = new AtomicInteger();

    <T extends Model, P> Future<T> fetchModel(Class<T> modelType, Class<P> parameterType, Action<? super P> parameterInitializer) {
        return null;
    }

    private static class BulkModelAction
    implements BuildAction<List<ModelResult>> {
        List<ModelTask> modelTasks = new LinkedList<ModelTask>();

        private BulkModelAction() {
        }

        public void addTask(Class modelType, Class parameterType, Action parameterInitializer) {
            ModelTask task = new ModelTask(modelType, parameterType, parameterInitializer);
            this.modelTasks.add(task);
        }

        public List<ModelResult> execute(BuildController bc) {
            LinkedList<ModelResult> results = new LinkedList<ModelResult>();
            for (ModelTask modelTask : this.modelTasks) {
                if (modelTask.parameterType == null) continue;
                try {
                    Model m = (Model)bc.getModel(modelTask.modelType, modelTask.parameterType, modelTask.getParameterInitializer());
                    results.add(new ModelResult(modelTask.getId(), m));
                }
                catch (Throwable th) {
                    results.add(new ModelResult(modelTask.getId(), th));
                }
            }
            return results;
        }
    }

    public static class ModelTask<T extends Model, P>
    implements Serializable {
        String id;
        Class<T> modelType;
        Class<P> parameterType;
        Action<? super P> parameterInitializer;

        public ModelTask(Class<T> modelType, Class<P> parameterType, Action<? super P> parameterInitializer) {
            this.id = modelType.getName() + "-" + TASK_SEQUENCE.getAndIncrement();
            this.modelType = modelType;
            this.parameterType = parameterType;
            this.parameterInitializer = parameterInitializer;
        }

        public String getId() {
            return this.id;
        }

        public Class<T> getModelType() {
            return this.modelType;
        }

        public Class<P> getParameterType() {
            return this.parameterType;
        }

        public Action<? super P> getParameterInitializer() {
            return this.parameterInitializer;
        }
    }

    public static class ModelResult
    implements Serializable {
        String id;
        Model result;
        Throwable exception;

        public ModelResult(String id, Model result) {
            this.id = id;
            this.result = result;
        }

        public ModelResult(String id, Throwable exception) {
            this.id = id;
            this.exception = exception;
        }

        public String getId() {
            return this.id;
        }

        public Model getResult() {
            return this.result;
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    public static class BulkActionResult {
    }
}

