/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSPort;
import org.netbeans.modules.websvc.jaxwsmodelapi.java.JavaMethod;
import org.netbeans.modules.websvc.jaxwsmodelapi.java.JavaParameter;
import org.netbeans.modules.websvc.jaxwsmodelapi.java.JavaType;
import org.netbeans.modules.websvc.manager.ui.MethodExceptionDialog;
import org.netbeans.modules.websvc.manager.ui.MethodTaskListener;
import org.netbeans.modules.websvc.manager.ui.NodeHelper;
import org.netbeans.modules.websvc.manager.ui.ParameterTreeNode;
import org.netbeans.modules.websvc.manager.ui.ReflectionHelper;
import org.netbeans.modules.websvc.manager.ui.ResultCellEditor;
import org.netbeans.modules.websvc.manager.ui.ResultRowModel;
import org.netbeans.modules.websvc.manager.ui.TypeCellEditor;
import org.netbeans.modules.websvc.manager.ui.TypeDataProvider;
import org.netbeans.modules.websvc.manager.ui.TypeNodeData;
import org.netbeans.modules.websvc.manager.ui.TypeRowModel;
import org.netbeans.modules.websvc.manager.ui.WebServiceReflectionException;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlServiceProxyDescriptor;
import org.netbeans.modules.websvc.saas.util.TypeUtil;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RenderDataProvider;
import org.netbeans.swing.outline.RowModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class TestWebServiceMethodDlg
extends JPanel
implements ActionListener,
MethodTaskListener {
    private Dialog dialog;
    private DialogDescriptor dlg = null;
    private final String okString = NbBundle.getMessage(this.getClass(), (String)"CLOSE");
    private URLClassLoader runtimeClassLoader;
    private final DefaultMutableTreeNode parameterRootNode = new DefaultMutableTreeNode();
    private DefaultMutableTreeNode resultRootNode = new DefaultMutableTreeNode();
    private final WsdlSaas wsData;
    private final WSPort port;
    private final JavaMethod method;
    private MethodTask methodTask;
    private JPanel btnPanel;
    private JButton btnSubmit;
    private JSplitPane jSplitPane1;
    private JLabel lblParameters;
    private JLabel lblResults;
    private JLabel lblTitle;
    private JPanel pnlLabel;
    private JPanel pnlParameter;
    private JPanel pnlResults;
    private JScrollPane scrollPaneParameter;
    private JScrollPane scrollPaneResults;
    private final JButton okButton = new JButton();
    private Outline parameterOutline;
    private Outline resultOutline;
    private Cursor normalCursor;

    public TestWebServiceMethodDlg(WsdlSaasMethod saasMethod) {
        this.method = saasMethod.getJavaMethod();
        this.wsData = saasMethod.getSaas();
        this.port = saasMethod.getWsdlPort();
        this.initComponents();
        this.myInitComponents();
        this.lblTitle.setText(NbBundle.getMessage(this.getClass(), (String)"TEST_WEBSVC_LABEL") + " ");
    }

    private boolean isRPCEncoded(WsdlData wsdlData) {
        File wsdlFile = new File(wsdlData.getWsdlFile());
        try {
            wsdlFile = wsdlFile.getCanonicalFile();
            return wsdlFile != null && JaxWsUtils.isRPCEncoded((URI)wsdlFile.toURI());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    private URLClassLoader getRuntimeClassLoader() {
        if (null == this.runtimeClassLoader) {
            try {
                WsdlData wsdlData = this.wsData.getWsdlData();
                boolean isRPCEncoded = this.isRPCEncoded(wsdlData);
                List urlList = TypeUtil.buildClasspath(null, (!isRPCEncoded ? 1 : 0) != 0);
                WsdlServiceProxyDescriptor descriptor = isRPCEncoded ? wsdlData.getJaxRpcDescriptor() : wsdlData.getJaxWsDescriptor();
                for (WsdlServiceProxyDescriptor.JarEntry entry : descriptor.getJars()) {
                    if (!entry.getType().equals("proxy")) continue;
                    File jarFile = new File(descriptor.getXmlDescriptorFile().getParent(), entry.getName());
                    File tmpJarFile = this.createTempCopy(jarFile);
                    urlList.add(tmpJarFile.toURI().toURL());
                }
                URL[] urls = urlList.toArray(new URL[0]);
                this.runtimeClassLoader = new URLClassLoader(urls);
            }
            catch (IOException mfu) {
                ErrorManager.getDefault().notify((Throwable)mfu);
                ErrorManager.getDefault().log(this.getClass().getName() + ":IOException=" + mfu);
                return null;
            }
        }
        return this.runtimeClassLoader;
    }

    private File createTempCopy(File src) {
        try {
            File tempFile = Files.createTempFile("proxyjar", "jar", new FileAttribute[0]).toFile();
            FileChannel inChannel = new FileInputStream(src).getChannel();
            FileChannel outChannel = new FileOutputStream(tempFile).getChannel();
            inChannel.transferTo(0L, inChannel.size(), outChannel);
            inChannel.close();
            outChannel.close();
            return tempFile;
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(16, (Throwable)ex);
            return null;
        }
    }

    public void displayDialog() {
        this.dlg = new DialogDescriptor((Object)this, NbBundle.getMessage(this.getClass(), (String)"TEST_WEB_SERVICE_METHOD"), false, 2, DialogDescriptor.OK_OPTION, 0, HelpCtx.DEFAULT_HELP, (ActionListener)this);
        this.dlg.setOptions(new Object[]{this.okButton});
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dlg);
        final TestWebServiceMethodDlg thisPanel = this;
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TestWebServiceMethodDlg.this.btnSubmit.requestFocus();
                        thisPanel.getRootPane().setDefaultButton(TestWebServiceMethodDlg.this.btnSubmit);
                    }
                });
            }
        });
        this.normalCursor = this.dialog.getCursor();
        BusyMouseAdapter mouseAdapter = new BusyMouseAdapter(this.normalCursor);
        this.okButton.addMouseListener(mouseAdapter);
        this.dialog.show();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.pnlParameter = new JPanel();
        this.pnlLabel = new JPanel();
        this.lblTitle = new JLabel();
        this.lblParameters = new JLabel();
        this.scrollPaneParameter = new JScrollPane();
        this.btnPanel = new JPanel();
        this.btnSubmit = new JButton();
        this.pnlResults = new JPanel();
        this.lblResults = new JLabel();
        this.scrollPaneResults = new JScrollPane();
        this.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.main.ACC_desc"));
        this.setPreferredSize(new Dimension(600, 450));
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.jsplintPane1.ACC_desc"));
        this.pnlParameter.setBorder(BorderFactory.createEmptyBorder(12, 12, 5, 12));
        this.pnlParameter.setLayout(new BorderLayout());
        this.pnlLabel.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.pnlLabel.ACC_desc"));
        this.pnlLabel.setLayout(new GridLayout(2, 0));
        this.lblTitle.setFont(this.lblTitle.getFont().deriveFont(this.lblTitle.getFont().getStyle() | 1, this.lblTitle.getFont().getSize() - 2));
        this.lblTitle.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblTitle, (String)NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TEST_WEB_SERVICE_METHOD"));
        this.lblTitle.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.lblTitle.ACC_desc"));
        this.pnlLabel.add(this.lblTitle);
        this.lblParameters.setFont(this.lblParameters.getFont().deriveFont((float)this.lblParameters.getFont().getSize() - 4.0f));
        this.lblParameters.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblParameters, (String)NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TEST_WEBSVC_INSTRUCTIONS"));
        this.lblParameters.setToolTipText(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.jLabel1.ACC_desc"));
        this.pnlLabel.add(this.lblParameters);
        this.pnlParameter.add((Component)this.pnlLabel, "North");
        this.pnlLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.pnlLabel.ACC_name"));
        this.scrollPaneParameter.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.scrollPaneParameter.ACC_desc"));
        this.pnlParameter.add((Component)this.scrollPaneParameter, "Center");
        this.scrollPaneParameter.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.scrollPaneParameter.ACC_name"));
        this.btnPanel.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.btnPanel.ACC_desc"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSubmit, (String)NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"BUTTON_SUBMIT"));
        this.btnSubmit.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.btnSubmit.ACC_desc"));
        this.btnSubmit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestWebServiceMethodDlg.this.btnSubmitActionPerformed(evt);
            }
        });
        this.btnPanel.add(this.btnSubmit);
        this.pnlParameter.add((Component)this.btnPanel, "South");
        this.btnPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.btnPanel.ACC_name"));
        this.jSplitPane1.setLeftComponent(this.pnlParameter);
        this.pnlParameter.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.pnlParameter.ACC_name"));
        this.pnlParameter.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.pnlParameter.ACC_desc"));
        this.pnlResults.setBorder(BorderFactory.createEmptyBorder(5, 12, 5, 12));
        this.pnlResults.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.pnResults.ACC_desc"));
        this.pnlResults.setLayout(new BorderLayout(0, 5));
        this.lblResults.setHorizontalAlignment(2);
        this.lblResults.setLabelFor(this.scrollPaneResults);
        Mnemonics.setLocalizedText((JLabel)this.lblResults, (String)NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"RESULTS"));
        this.lblResults.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.lblResults.ACC_desc"));
        this.pnlResults.add((Component)this.lblResults, "North");
        this.scrollPaneResults.setToolTipText(NbBundle.getBundle(TestWebServiceMethodDlg.class).getString("TestWebServiceMethodDlg.scrollPaneResults.ACC_desc"));
        this.pnlResults.add((Component)this.scrollPaneResults, "Center");
        this.scrollPaneResults.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.scrollPaneResults.ACC_name"));
        this.jSplitPane1.setRightComponent(this.pnlResults);
        this.pnlResults.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.pnResults.ACC_name"));
        this.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.jsplintPane1.ACC_name"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.main.ACC_name"));
    }

    private void btnSubmitActionPerformed(ActionEvent evt) {
        this.dialog.setCursor(new Cursor(3));
        this.invokeMethod();
    }

    private void invokeMethod() {
        LinkedList<Object> paramList = new LinkedList<Object>();
        for (int ii = 0; null != this.getParamterRootNode() && ii < this.getParamterRootNode().getChildCount(); ++ii) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)this.getParamterRootNode().getChildAt(ii);
            TypeNodeData nodeData = (TypeNodeData)childNode.getUserObject();
            Object parameterValue = nodeData.getTypeValue();
            paramList.add(parameterValue);
        }
        String clientClassName = this.isRPCEncoded(this.wsData.getWsdlData()) ? this.wsData.getWsdlModel().getJavaName() + "_Impl" : this.wsData.getWsdlModel().getJavaName();
        this.methodTask = new MethodTask(clientClassName, paramList, this.method, this.getRuntimeClassLoader());
        this.methodTask.registerListener(this);
        Thread methodThread = new Thread(this.methodTask);
        methodThread.start();
    }

    @Override
    public void methodFinished(final Object inReturnedObject, final LinkedList inParamList) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doMethodFinished(inReturnedObject, inParamList);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TestWebServiceMethodDlg.this.doMethodFinished(inReturnedObject, inParamList);
                }
            });
        }
    }

    private void doMethodFinished(Object inReturnedObject, List inParamList) {
        this.dialog.setCursor(this.normalCursor);
        this.showResults(inReturnedObject);
        for (int ii = 0; null != this.getParamterRootNode() && ii < this.getParamterRootNode().getChildCount(); ++ii) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)this.getParamterRootNode().getChildAt(ii);
            TypeNodeData nodeData = (TypeNodeData)childNode.getUserObject();
            nodeData.setTypeValue(inParamList.get(ii));
            String topNodeType = nodeData.getTypeClass();
            if (!ReflectionHelper.isHolder(topNodeType)) continue;
            ((ParameterTreeNode)((Object)childNode)).updateChildren();
        }
        this.parameterOutline.tableChanged(new TableModelEvent((TableModel)this.parameterOutline.getOutlineModel()));
    }

    private void showResults(Object inResultObject) {
        try {
            this.resultOutline = this.loadResultTreeTable(this.method, inResultObject);
            this.resultOutline.getTableHeader().setReorderingAllowed(false);
            this.resultOutline.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.resultOutline.ACC_name"));
            this.resultOutline.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.resultOutline.ACC_desc"));
            this.addFocusListener((JTable)this.resultOutline);
            this.lblResults.setLabelFor((Component)this.resultOutline);
            this.scrollPaneResults.setViewportView((Component)this.resultOutline);
        }
        catch (WebServiceReflectionException ex) {
            Throwable cause = ex.getCause();
            ErrorManager.getDefault().notify(cause);
            ErrorManager.getDefault().log(this.getClass().getName() + ": WebServiceReflectionException=" + cause);
        }
    }

    private void myInitComponents() {
        this.okButton.setText(this.okString);
        if (null == this.method) {
            return;
        }
        try {
            NodeHelper.createInstance(this.getRuntimeClassLoader());
            this.parameterOutline = this.loadParameterTreeTable(this.method);
            this.scrollPaneParameter.setViewportView((Component)this.parameterOutline);
            this.okButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.okButton.ACC_name"));
            this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.okButton.ACC_desc"));
            this.okButton.setMnemonic(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.okButton.ACC_mnemonic").charAt(0));
            this.parameterOutline.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.parameterOutline.ACC_name"));
            this.parameterOutline.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestWebServiceMethodDlg.class, (String)"TestWebServiceMethodDlg.parameterOutline.ACC_desc"));
            this.lblParameters.setLabelFor((Component)this.parameterOutline);
            this.addFocusListener((JTable)this.parameterOutline);
        }
        catch (WebServiceReflectionException ex) {
            Throwable cause = ex.getCause();
            ErrorManager.getDefault().notify(cause);
            ErrorManager.getDefault().log(this.getClass().getName() + ": WebServiceReflectionException=" + cause);
        }
    }

    private void addFocusListener(final JTable table) {
        table.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent evt) {
                Container cycleRoot = table.getFocusCycleRootAncestor();
                FocusTraversalPolicy policy = table.getFocusTraversalPolicy();
                if (policy == null && cycleRoot != null) {
                    policy = cycleRoot.getFocusTraversalPolicy();
                }
                if (table.getRowCount() == 0 && policy != null) {
                    Component target = policy.getComponentAfter(cycleRoot, table);
                    if (target != null && target == evt.getOppositeComponent()) {
                        target = policy.getComponentBefore(cycleRoot, table);
                    }
                    if (target != null) {
                        target.requestFocusInWindow();
                    }
                }
            }

            @Override
            public void focusLost(FocusEvent evt) {
            }
        });
    }

    private DefaultMutableTreeNode getParamterRootNode() {
        return this.parameterRootNode;
    }

    private DefaultMutableTreeNode getResultRootNode() {
        return this.resultRootNode;
    }

    private void setResultRootNode(DefaultMutableTreeNode inNode) {
        this.resultRootNode = inNode;
    }

    private Outline loadResultTreeTable(JavaMethod inMethod, Object inResultObject) throws WebServiceReflectionException {
        if (null == inMethod) {
            return null;
        }
        JavaType currentType = inMethod.getReturnType();
        String typeName = currentType.getRealName();
        TypeNodeData data = ReflectionHelper.createTypeData(typeName, inResultObject);
        DefaultMutableTreeNode node = NodeHelper.getInstance().createResultNodeFromData(data);
        this.setResultRootNode(new DefaultMutableTreeNode());
        this.getResultRootNode().add(node);
        DefaultTreeModel treeModel = new DefaultTreeModel(this.getResultRootNode());
        ResultRowModel rowModel = new ResultRowModel();
        OutlineModel outlineModel = DefaultOutlineModel.createOutlineModel((TreeModel)treeModel, (RowModel)rowModel, (boolean)false, (String)NbBundle.getMessage(this.getClass(), (String)"TYPE_COLUMN_NAME"));
        Outline returnOutline = new Outline(outlineModel);
        ResultCellEditor cellEditor = new ResultCellEditor();
        returnOutline.setDefaultEditor(Object.class, (TableCellEditor)cellEditor);
        returnOutline.setRootVisible(false);
        returnOutline.setRenderDataProvider((RenderDataProvider)new TypeDataProvider());
        return returnOutline;
    }

    private Outline loadParameterTreeTable(JavaMethod inMethod) throws WebServiceReflectionException {
        if (null == inMethod) {
            return null;
        }
        List parameters = inMethod.getParametersList();
        for (JavaParameter currentParameter : parameters) {
            JavaType currentType = currentParameter.getType();
            String typeName = currentType.getRealName();
            String typeParamName = currentParameter.getName();
            if (currentParameter.isHolder()) {
                typeName = "javax.xml.ws.Holder<" + typeName + ">";
            }
            TypeNodeData data = ReflectionHelper.createTypeData(typeName, typeParamName);
            data.setTypeValue(NodeHelper.getInstance().getParameterDefaultValue(data));
            if (currentParameter.isHolder()) {
                if (currentParameter.isIN()) {
                    data.setHolderType(0);
                }
                if (currentParameter.isOUT()) {
                    data.setHolderType(1);
                }
                if (currentParameter.isINOUT()) {
                    data.setHolderType(2);
                }
            }
            DefaultMutableTreeNode node = NodeHelper.getInstance().createNodeFromData(data);
            this.getParamterRootNode().add(node);
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(this.getParamterRootNode());
        TypeRowModel rowModel = new TypeRowModel(this.getRuntimeClassLoader());
        OutlineModel outlineModel = DefaultOutlineModel.createOutlineModel((TreeModel)treeModel, (RowModel)rowModel, (boolean)false, (String)NbBundle.getMessage(this.getClass(), (String)"TYPE_COLUMN_NAME"));
        Outline returnOutline = new Outline(outlineModel);
        TypeCellEditor cellEditor = new TypeCellEditor(this.getRuntimeClassLoader());
        returnOutline.setDefaultEditor(Object.class, (TableCellEditor)cellEditor);
        returnOutline.setRootVisible(false);
        returnOutline.setRenderDataProvider((RenderDataProvider)new TypeDataProvider());
        returnOutline.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        return returnOutline;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String actionCommand = evt.getActionCommand();
        if (actionCommand.equalsIgnoreCase(this.okString)) {
            this.okButtonAction(evt);
        }
    }

    private void okButtonAction(ActionEvent evt) {
        if (null != this.methodTask) {
            this.methodTask.cancel();
        }
        this.dialog.setCursor(this.normalCursor);
        this.dialog.dispose();
    }

    private static class BusyMouseAdapter
    extends MouseAdapter {
        private final Cursor normalCursor;

        public BusyMouseAdapter(Cursor inNormalCursor) {
            this.normalCursor = inNormalCursor;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            e.getComponent().setCursor(this.normalCursor);
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    class MethodTask
    implements Runnable {
        private final String clientClassName;
        private final LinkedList paramList;
        private final JavaMethod javaMethod;
        private final URLClassLoader urlClassLoader;
        private final List<MethodTaskListener> listeners = new ArrayList<MethodTaskListener>();
        private boolean cancelled = false;

        MethodTask(String inClientClassName, LinkedList inParamList, JavaMethod inJavaMethod, URLClassLoader inURLClassLoader) {
            this.clientClassName = inClientClassName;
            this.paramList = inParamList;
            this.javaMethod = inJavaMethod;
            this.urlClassLoader = inURLClassLoader;
        }

        public void registerListener(MethodTaskListener inListener) {
            if (!this.listeners.contains(inListener)) {
                this.listeners.add(inListener);
            }
        }

        private void notifyListeners(Object returnedObject) {
            for (MethodTaskListener currentListener : this.listeners) {
                currentListener.methodFinished(returnedObject, this.paramList);
            }
        }

        @Override
        public void run() {
            Object returnObject;
            try {
                returnObject = ReflectionHelper.callMethodWithParams(this.clientClassName, this.paramList, this.javaMethod, this.urlClassLoader, TestWebServiceMethodDlg.this.wsData.getWsdlData(), TestWebServiceMethodDlg.this.port);
            }
            catch (Exception wsre) {
                if (!this.cancelled) {
                    Throwable exception = wsre;
                    if (wsre.getCause() instanceof InvocationTargetException) {
                        exception = wsre.getCause();
                    }
                    MethodExceptionDialog errorDialog = new MethodExceptionDialog(exception);
                    this.notifyListeners(null);
                    errorDialog.showDialog(TestWebServiceMethodDlg.this.btnSubmit);
                }
                return;
            }
            this.notifyListeners(returnObject);
        }

        public void cancel() {
            this.cancelled = true;
        }
    }
}

