/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.javascript.nodejs.exec.NodeExecutable;
import org.netbeans.modules.javascript.nodejs.ui.Bundle;
import org.netbeans.modules.javascript.nodejs.util.FileUtils;
import org.netbeans.modules.javascript.nodejs.util.NodeJsUtils;
import org.netbeans.modules.web.clientproject.api.network.NetworkException;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.netbeans.modules.web.common.api.Version;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class NodeJsPathPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(NodeJsPathPanel.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(NodeJsPathPanel.class);
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final RequestProcessor.Task versionTask;
    private final List<String> debugProtocolIds = new ArrayList<String>();
    volatile File nodeSources = null;
    private JComboBox<String> debugProcotolComboBox;
    private JLabel debugProtocolLabel;
    private JButton downloadSourcesButton;
    private JButton nodeBrowseButton;
    private JLabel nodeHintLabel;
    private JLabel nodeInstallLabel;
    private JLabel nodeLabel;
    private JButton nodeSearchButton;
    private JTextField nodeTextField;
    private JButton selectSourcesButton;
    private JLabel sourcesLabel;
    private JTextField sourcesTextField;

    public NodeJsPathPanel() {
        this.initComponents();
        this.init();
        this.versionTask = RP.create(new Runnable(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NodeJsPathPanel.this.setVersion();
                    }
                });
            }
        });
    }

    private void init() {
        FileObject[] children = FileUtil.getConfigRoot().getFileObject("javascript/nodejs-debugger").getChildren();
        Arrays.sort(children, (a, b) -> {
            Integer valA = (Integer)a.getAttribute("position");
            Integer valB = (Integer)b.getAttribute("position");
            if (valA == null) {
                valA = 0;
            }
            if (valB == null) {
                valB = 0;
            }
            return valA - valB;
        });
        this.debugProtocolIds.add("");
        this.debugProcotolComboBox.addItem("Default");
        for (FileObject fo : children) {
            this.debugProtocolIds.add(fo.getNameExt());
            String displayName = (String)fo.getAttribute("displayName");
            if (displayName == null) {
                displayName = fo.getNameExt();
            }
            this.debugProcotolComboBox.addItem(displayName);
        }
        this.sourcesTextField.setText(" ");
        String[] nodes = NodeExecutable.NODE_NAMES;
        if (nodes.length > 1) {
            this.nodeHintLabel.setText(Bundle.NodeJsPathPanel_node_hint2(nodes[0], nodes[1]));
        } else {
            this.nodeHintLabel.setText(Bundle.NodeJsPathPanel_node_hint1(nodes[0]));
        }
        this.nodeTextField.getDocument().addDocumentListener(new NodeDocumentListener());
        this.sourcesTextField.getDocument().addDocumentListener(new DefaultDocumentListener());
    }

    public String getNode() {
        return this.nodeTextField.getText();
    }

    public void setNode(String node) {
        this.nodeTextField.setText(node);
    }

    @CheckForNull
    public String getNodeSources() {
        if (this.nodeSources != null) {
            return this.nodeSources.getAbsolutePath();
        }
        return null;
    }

    public void setNodeSources(String nodeSources) {
        if (StringUtilities.hasText((String)nodeSources)) {
            this.nodeSources = new File(nodeSources);
            this.setNodeSourcesDescription();
        }
    }

    public String getDebugProtocol() {
        return this.debugProtocolIds.get(this.debugProcotolComboBox.getSelectedIndex());
    }

    public void setDebugProtocol(String debugProtocolId) {
        int protocolIdx = this.debugProtocolIds.indexOf(debugProtocolId);
        if (protocolIdx < 0) {
            protocolIdx = 0;
        }
        this.debugProcotolComboBox.setSelectedIndex(protocolIdx);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void enablePanel(boolean enabled) {
        assert (EventQueue.isDispatchThread());
        this.nodeLabel.setEnabled(enabled);
        this.nodeTextField.setEnabled(enabled);
        this.nodeBrowseButton.setEnabled(enabled);
        this.nodeSearchButton.setEnabled(enabled);
        this.nodeHintLabel.setEnabled(enabled);
        this.nodeInstallLabel.setVisible(enabled);
        this.sourcesLabel.setEnabled(enabled);
        this.sourcesTextField.setEnabled(enabled);
        this.selectSourcesButton.setEnabled(enabled);
        this.downloadSourcesButton.setEnabled(false);
        this.debugProcotolComboBox.setEnabled(enabled);
        this.debugProtocolLabel.setEnabled(enabled);
        if (enabled) {
            if (this.nodeSources != null) {
                this.setNodeSourcesDescription();
            }
            this.setVersion();
        }
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    void detectVersion() {
        this.versionTask.schedule(100);
    }

    void setVersion() {
        assert (EventQueue.isDispatchThread());
        this.downloadSourcesButton.setEnabled(false);
        if (this.nodeSources == null) {
            this.setNodeSourcesDescription(Bundle.NodeJsPathPanel_version_detecting());
        }
        final String nodePath = this.getNode();
        RP.post(new Runnable(){

            @Override
            public void run() {
                Version realVersion;
                Version version;
                NodeExecutable node = NodeExecutable.forPath(nodePath);
                if (node != null) {
                    version = node.getVersion();
                    realVersion = node.getRealVersion();
                } else {
                    version = null;
                    realVersion = null;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        assert (EventQueue.isDispatchThread());
                        if (version != null) {
                            NodeJsPathPanel.this.downloadSourcesButton.setEnabled(NodeJsPathPanel.this.sourcesTextField.isEnabled());
                        }
                        if (NodeJsPathPanel.this.nodeSources == null) {
                            NodeJsPathPanel.this.setNodeSourcesDescription(version, realVersion);
                        }
                    }
                });
            }
        });
    }

    private void downloadSources() {
        assert (EventQueue.isDispatchThread());
        this.downloadSourcesButton.setEnabled(false);
        String nodePath = this.getNode();
        final NodeExecutable node = NodeExecutable.forPath(nodePath);
        assert (node != null) : nodePath;
        final Version version = node.getVersion();
        assert (version != null) : nodePath;
        final Version realVersion = node.getRealVersion();
        assert (realVersion != null) : version;
        if (NodeJsUtils.hasNodeSources(version)) {
            this.nodeSources = null;
            this.setNodeSourcesDescription(version, realVersion);
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)Bundle.NodeJsPathPanel_sources_exists(version.toString()), 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.NO_OPTION) {
                this.downloadSourcesButton.setEnabled(this.sourcesTextField.isEnabled());
                return;
            }
        }
        this.sourcesTextField.setText(Bundle.NodeJsPathPanel_sources_downloading());
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (FileUtils.downloadNodeSources(version, node.isIojs())) {
                        StatusDisplayer.getDefault().setStatusText(Bundle.NodeJsPathPanel_download_success());
                    }
                    NodeJsPathPanel.this.nodeSources = null;
                }
                catch (NetworkException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    NodeJsPathPanel.this.informUser(Bundle.NodeJsPathPanel_download_failure(ex.getFailedRequests().get(0)));
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    NodeJsPathPanel.this.informUser(Bundle.NodeJsPathPanel_download_error());
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NodeJsPathPanel.this.setNodeSourcesDescription(version, realVersion);
                        NodeJsPathPanel.this.downloadSourcesButton.setEnabled(NodeJsPathPanel.this.sourcesTextField.isEnabled());
                    }
                });
            }
        });
    }

    private void informUser(String message) {
        NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)message, 0);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)descriptor);
    }

    private void setNodeSourcesDescription() {
        assert (EventQueue.isDispatchThread());
        File nodeSourcesRef = this.nodeSources;
        assert (nodeSourcesRef != null);
        this.setNodeSourcesDescription(nodeSourcesRef.getAbsolutePath());
    }

    private void setNodeSourcesDescription(@NullAllowed Version version, @NullAllowed Version realVersion) {
        String text;
        assert (EventQueue.isDispatchThread());
        if (version == null) {
            text = Bundle.NodeJsPathPanel_sources_na();
        } else if (NodeJsUtils.hasNodeSources(version)) {
            if (Objects.equals(version, realVersion)) {
                text = Bundle.NodeJsPathPanel_sources_downloaded(version);
            } else {
                assert (realVersion != null) : version;
                text = Bundle.NodeJsPathPanel_sources_es5_downloaded(realVersion, version);
            }
        } else if (Objects.equals(version, realVersion)) {
            text = Bundle.NodeJsPathPanel_sources_not_downloaded(version);
        } else {
            assert (realVersion != null) : version;
            text = Bundle.NodeJsPathPanel_sources_es5_not_downloaded(realVersion, version);
        }
        this.setNodeSourcesDescription(text);
    }

    private void setNodeSourcesDescription(String text) {
        assert (EventQueue.isDispatchThread());
        this.sourcesTextField.setText(text);
    }

    private void initComponents() {
        this.nodeLabel = new JLabel();
        this.nodeTextField = new JTextField();
        this.nodeBrowseButton = new JButton();
        this.nodeSearchButton = new JButton();
        this.nodeHintLabel = new JLabel();
        this.nodeInstallLabel = new JLabel();
        this.sourcesLabel = new JLabel();
        this.sourcesTextField = new JTextField();
        this.downloadSourcesButton = new JButton();
        this.selectSourcesButton = new JButton();
        this.debugProtocolLabel = new JLabel();
        this.debugProcotolComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.nodeLabel, (String)NbBundle.getMessage(NodeJsPathPanel.class, (String)"NodeJsPathPanel.nodeLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.nodeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.nodeTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.nodeBrowseButton, (String)NbBundle.getMessage(NodeJsPathPanel.class, (String)"NodeJsPathPanel.nodeBrowseButton.text"));
        this.nodeBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NodeJsPathPanel.this.nodeBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.nodeBrowseButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.nodeSearchButton, (String)NbBundle.getMessage(NodeJsPathPanel.class, (String)"NodeJsPathPanel.nodeSearchButton.text"));
        this.nodeSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NodeJsPathPanel.this.nodeSearchButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.nodeSearchButton, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.nodeHintLabel, (String)"HINT");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.nodeHintLabel, gridBagConstraints);
        this.nodeInstallLabel.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.nodeInstallLabel, (String)NbBundle.getMessage(NodeJsPathPanel.class, (String)"NodeJsPathPanel.nodeInstallLabel.text"));
        this.nodeInstallLabel.setHorizontalTextPosition(4);
        this.nodeInstallLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                NodeJsPathPanel.this.nodeInstallLabelMousePressed(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                NodeJsPathPanel.this.nodeInstallLabelMouseEntered(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.nodeInstallLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.sourcesLabel, (String)NbBundle.getMessage(NodeJsPathPanel.class, (String)"NodeJsPathPanel.sourcesLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.sourcesLabel, gridBagConstraints);
        this.sourcesTextField.setEditable(false);
        this.sourcesTextField.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.sourcesTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.downloadSourcesButton, (String)NbBundle.getMessage(NodeJsPathPanel.class, (String)"NodeJsPathPanel.downloadSourcesButton.text"));
        this.downloadSourcesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NodeJsPathPanel.this.downloadSourcesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.downloadSourcesButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.selectSourcesButton, (String)NbBundle.getMessage(NodeJsPathPanel.class, (String)"NodeJsPathPanel.selectSourcesButton.text"));
        this.selectSourcesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NodeJsPathPanel.this.selectSourcesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.selectSourcesButton, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.debugProtocolLabel, (String)NbBundle.getMessage(NodeJsPathPanel.class, (String)"NodeJsPathPanel.debugProtocolLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.debugProtocolLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.debugProcotolComboBox, gridBagConstraints);
    }

    private void nodeBrowseButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File file = new FileChooserBuilder(NodeJsPathPanel.class).setFilesOnly(true).setTitle(Bundle.NodeJsPathPanel_node_browse_title()).showOpenDialog();
        if (file != null) {
            this.nodeTextField.setText(file.getAbsolutePath());
        }
    }

    private void nodeSearchButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        Iterator<String> iterator = FileUtils.findFileOnUsersPath(NodeExecutable.NODE_NAMES).iterator();
        if (iterator.hasNext()) {
            String node = iterator.next();
            this.nodeTextField.setText(new File(node).getAbsolutePath());
            return;
        }
        StatusDisplayer.getDefault().setStatusText(Bundle.NodeJsPathPanel_node_none());
    }

    private void downloadSourcesButtonActionPerformed(ActionEvent evt) {
        this.downloadSources();
    }

    private void nodeInstallLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void nodeInstallLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("https://nodejs.org/"));
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
    }

    private void selectSourcesButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File sources = new FileChooserBuilder(NodeJsPathPanel.class).setDirectoriesOnly(true).setTitle(Bundle.NodeJsPathPanel_sources_browse_title()).showOpenDialog();
        if (sources != null) {
            this.nodeSources = sources;
            this.setNodeSourcesDescription();
        }
    }

    private final class NodeDocumentListener
    implements DocumentListener {
        private NodeDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            NodeJsPathPanel.this.fireChange();
            NodeExecutable node = NodeExecutable.forPath(NodeJsPathPanel.this.getNode());
            if (node != null) {
                node.resetVersion();
            }
            NodeJsPathPanel.this.detectVersion();
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            NodeJsPathPanel.this.fireChange();
        }
    }
}

