/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.text.View;
import sun.awt.AppContext;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicLabelUI
extends LabelUI
implements PropertyChangeListener {
    protected static BasicLabelUI labelUI = new BasicLabelUI();
    private static final Object BASIC_LABEL_UI_KEY = new Object();
    private Rectangle paintIconR = new Rectangle();
    private Rectangle paintTextR = new Rectangle();

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("press"));
        lazyActionMap.put(new Actions("release"));
    }

    protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        return SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, string, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, jLabel.getIconTextGap());
    }

    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        int n3 = jLabel.getDisplayedMnemonicIndex();
        graphics.setColor(jLabel.getForeground());
        SwingUtilities2.drawStringUnderlineCharAt(jLabel, graphics, string, n3, n, n2);
    }

    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        int n3 = jLabel.getDisplayedMnemonicIndex();
        Color color = jLabel.getBackground();
        graphics.setColor(color.brighter());
        SwingUtilities2.drawStringUnderlineCharAt(jLabel, graphics, string, n3, n + 1, n2 + 1);
        graphics.setColor(color.darker());
        SwingUtilities2.drawStringUnderlineCharAt(jLabel, graphics, string, n3, n, n2);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Icon icon;
        JLabel jLabel = (JLabel)jComponent;
        String string = jLabel.getText();
        Icon icon2 = icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        if (icon == null && string == null) {
            return;
        }
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics((JComponent)jLabel, graphics);
        String string2 = this.layout(jLabel, fontMetrics, jComponent.getWidth(), jComponent.getHeight());
        if (icon != null) {
            icon.paintIcon(jComponent, graphics, this.paintIconR.x, this.paintIconR.y);
        }
        if (string != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, this.paintTextR);
            } else {
                int n = this.paintTextR.x;
                int n2 = this.paintTextR.y + fontMetrics.getAscent();
                if (jLabel.isEnabled()) {
                    this.paintEnabledText(jLabel, graphics, string2, n, n2);
                } else {
                    this.paintDisabledText(jLabel, graphics, string2, n, n2);
                }
            }
        }
    }

    private String layout(JLabel jLabel, FontMetrics fontMetrics, int n, int n2) {
        Insets insets = jLabel.getInsets(null);
        String string = jLabel.getText();
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        Rectangle rectangle = new Rectangle();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = n - (insets.left + insets.right);
        rectangle.height = n2 - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        return this.layoutCL(jLabel, fontMetrics, string, icon, rectangle, this.paintIconR, this.paintTextR);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        JLabel jLabel = (JLabel)jComponent;
        String string = jLabel.getText();
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        Insets insets = jLabel.getInsets(null);
        Font font = jLabel.getFont();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        if (icon == null && (string == null || string != null && font == null)) {
            return new Dimension(n, n2);
        }
        if (string == null || icon != null && font == null) {
            return new Dimension(icon.getIconWidth() + n, icon.getIconHeight() + n2);
        }
        FontMetrics fontMetrics = jLabel.getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        rectangle.height = 0;
        rectangle.width = 0;
        rectangle.y = 0;
        rectangle.x = 0;
        rectangle2.height = 0;
        rectangle2.width = 0;
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.x = n;
        rectangle3.y = n2;
        rectangle3.height = Short.MAX_VALUE;
        rectangle3.width = Short.MAX_VALUE;
        this.layoutCL(jLabel, fontMetrics, string, icon, rectangle3, rectangle, rectangle2);
        int n3 = Math.min(rectangle.x, rectangle2.x);
        int n4 = Math.max(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width);
        int n5 = Math.min(rectangle.y, rectangle2.y);
        int n6 = Math.max(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height);
        Dimension dimension = new Dimension(n4 - n3, n6 - n5);
        dimension.width += n;
        dimension.height += n2;
        return dimension;
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        super.getBaseline(jComponent, n, n2);
        JLabel jLabel = (JLabel)jComponent;
        String string = jLabel.getText();
        if (string == null || "".equals(string) || jLabel.getFont() == null) {
            return -1;
        }
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        this.layout(jLabel, fontMetrics, n, n2);
        return BasicHTML.getBaseline(jLabel, this.paintTextR.y, fontMetrics.getAscent(), this.paintTextR.width, this.paintTextR.height);
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent jComponent) {
        super.getBaselineResizeBehavior(jComponent);
        if (jComponent.getClientProperty("html") != null) {
            return Component.BaselineResizeBehavior.OTHER;
        }
        switch (((JLabel)jComponent).getVerticalAlignment()) {
            case 1: {
                return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
            }
            case 3: {
                return Component.BaselineResizeBehavior.CONSTANT_DESCENT;
            }
            case 0: {
                return Component.BaselineResizeBehavior.CENTER_OFFSET;
            }
        }
        return Component.BaselineResizeBehavior.OTHER;
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.installDefaults((JLabel)jComponent);
        this.installComponents((JLabel)jComponent);
        this.installListeners((JLabel)jComponent);
        this.installKeyboardActions((JLabel)jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults((JLabel)jComponent);
        this.uninstallComponents((JLabel)jComponent);
        this.uninstallListeners((JLabel)jComponent);
        this.uninstallKeyboardActions((JLabel)jComponent);
    }

    protected void installDefaults(JLabel jLabel) {
        LookAndFeel.installColorsAndFont(jLabel, "Label.background", "Label.foreground", "Label.font");
        LookAndFeel.installProperty(jLabel, "opaque", Boolean.FALSE);
    }

    protected void installListeners(JLabel jLabel) {
        jLabel.addPropertyChangeListener(this);
    }

    protected void installComponents(JLabel jLabel) {
        BasicHTML.updateRenderer(jLabel, jLabel.getText());
        jLabel.setInheritsPopupMenu(true);
    }

    protected void installKeyboardActions(JLabel jLabel) {
        int n = jLabel.getDisplayedMnemonic();
        Component component = jLabel.getLabelFor();
        if (n != 0 && component != null) {
            LazyActionMap.installLazyActionMap(jLabel, BasicLabelUI.class, "Label.actionMap");
            InputMap inputMap = SwingUtilities.getUIInputMap(jLabel, 2);
            if (inputMap == null) {
                inputMap = new ComponentInputMapUIResource(jLabel);
                SwingUtilities.replaceUIInputMap(jLabel, 2, inputMap);
            }
            inputMap.clear();
            inputMap.put(KeyStroke.getKeyStroke(n, BasicLookAndFeel.getFocusAcceleratorKeyMask(), false), "press");
            inputMap.put(KeyStroke.getKeyStroke(n, SwingUtilities2.setAltGraphMask(BasicLookAndFeel.getFocusAcceleratorKeyMask()), false), "press");
        } else {
            InputMap inputMap = SwingUtilities.getUIInputMap(jLabel, 2);
            if (inputMap != null) {
                inputMap.clear();
            }
        }
    }

    protected void uninstallDefaults(JLabel jLabel) {
    }

    protected void uninstallListeners(JLabel jLabel) {
        jLabel.removePropertyChangeListener(this);
    }

    protected void uninstallComponents(JLabel jLabel) {
        BasicHTML.updateRenderer(jLabel, "");
    }

    protected void uninstallKeyboardActions(JLabel jLabel) {
        SwingUtilities.replaceUIInputMap(jLabel, 0, null);
        SwingUtilities.replaceUIInputMap(jLabel, 2, null);
        SwingUtilities.replaceUIActionMap(jLabel, null);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        if (System.getSecurityManager() != null) {
            AppContext appContext = AppContext.getAppContext();
            BasicLabelUI basicLabelUI = (BasicLabelUI)appContext.get(BASIC_LABEL_UI_KEY);
            if (basicLabelUI == null) {
                basicLabelUI = new BasicLabelUI();
                appContext.put(BASIC_LABEL_UI_KEY, basicLabelUI);
            }
            return basicLabelUI;
        }
        return labelUI;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "text" || "font" == string || "foreground" == string) {
            JLabel jLabel = (JLabel)propertyChangeEvent.getSource();
            String string2 = jLabel.getText();
            BasicHTML.updateRenderer(jLabel, string2);
        } else if (string == "labelFor" || string == "displayedMnemonic") {
            this.installKeyboardActions((JLabel)propertyChangeEvent.getSource());
        }
    }

    private static class Actions
    extends UIAction {
        private static final String PRESS = "press";
        private static final String RELEASE = "release";

        Actions(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JLabel jLabel = (JLabel)actionEvent.getSource();
            String string = this.getName();
            if (string == PRESS) {
                this.doPress(jLabel);
            } else if (string == RELEASE) {
                this.doRelease(jLabel, actionEvent.getActionCommand() != null);
            }
        }

        private void doPress(JLabel jLabel) {
            Component component = jLabel.getLabelFor();
            if (component != null && component.isEnabled()) {
                InputMap inputMap = SwingUtilities.getUIInputMap(jLabel, 0);
                if (inputMap == null) {
                    inputMap = new InputMapUIResource();
                    SwingUtilities.replaceUIInputMap(jLabel, 0, inputMap);
                }
                int n = jLabel.getDisplayedMnemonic();
                this.putOnRelease(inputMap, n, BasicLookAndFeel.getFocusAcceleratorKeyMask());
                this.putOnRelease(inputMap, n, SwingUtilities2.setAltGraphMask(BasicLookAndFeel.getFocusAcceleratorKeyMask()));
                this.putOnRelease(inputMap, n, 0);
                this.putOnRelease(inputMap, 18, 0);
                jLabel.requestFocus();
            }
        }

        private void doRelease(JLabel jLabel, boolean bl) {
            Component component = jLabel.getLabelFor();
            if (component != null && component.isEnabled()) {
                if (jLabel.hasFocus()) {
                    int n;
                    InputMap inputMap = SwingUtilities.getUIInputMap(jLabel, 0);
                    if (inputMap != null) {
                        n = jLabel.getDisplayedMnemonic();
                        this.removeOnRelease(inputMap, n, BasicLookAndFeel.getFocusAcceleratorKeyMask());
                        this.removeOnRelease(inputMap, n, SwingUtilities2.setAltGraphMask(BasicLookAndFeel.getFocusAcceleratorKeyMask()));
                        this.removeOnRelease(inputMap, n, 0);
                        this.removeOnRelease(inputMap, 18, 0);
                    }
                    if ((inputMap = SwingUtilities.getUIInputMap(jLabel, 2)) == null) {
                        inputMap = new InputMapUIResource();
                        SwingUtilities.replaceUIInputMap(jLabel, 2, inputMap);
                    }
                    n = jLabel.getDisplayedMnemonic();
                    if (bl) {
                        this.putOnRelease(inputMap, 18, 0);
                    } else {
                        this.putOnRelease(inputMap, n, BasicLookAndFeel.getFocusAcceleratorKeyMask());
                        this.putOnRelease(inputMap, n, SwingUtilities2.setAltGraphMask(BasicLookAndFeel.getFocusAcceleratorKeyMask()));
                        this.putOnRelease(inputMap, n, 0);
                    }
                    if (component instanceof Container && ((Container)component).isFocusCycleRoot()) {
                        component.requestFocus();
                    } else {
                        SwingUtilities2.compositeRequestFocus(component);
                    }
                } else {
                    InputMap inputMap = SwingUtilities.getUIInputMap(jLabel, 2);
                    int n = jLabel.getDisplayedMnemonic();
                    if (inputMap != null) {
                        if (bl) {
                            this.removeOnRelease(inputMap, n, BasicLookAndFeel.getFocusAcceleratorKeyMask());
                            this.removeOnRelease(inputMap, n, SwingUtilities2.setAltGraphMask(BasicLookAndFeel.getFocusAcceleratorKeyMask()));
                            this.removeOnRelease(inputMap, n, 0);
                        } else {
                            this.removeOnRelease(inputMap, 18, 0);
                        }
                    }
                }
            }
        }

        private void putOnRelease(InputMap inputMap, int n, int n2) {
            inputMap.put(KeyStroke.getKeyStroke(n, n2, true), RELEASE);
        }

        private void removeOnRelease(InputMap inputMap, int n, int n2) {
            inputMap.remove(KeyStroke.getKeyStroke(n, n2, true));
        }
    }
}

