/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import org.jetbrains.annotations.NotNull;

public class TypeUpdateFlags {
    private static final int ALLOW_WIDER = 1;
    private static final int IGNORE_SAME = 2;
    private static final int IGNORE_UNKNOWN = 4;
    public static final TypeUpdateFlags FLAGS_EMPTY = TypeUpdateFlags.build(0);
    public static final TypeUpdateFlags FLAGS_WIDER = TypeUpdateFlags.build(1);
    public static final TypeUpdateFlags FLAGS_WIDER_IGNORE_SAME = TypeUpdateFlags.build(3);
    public static final TypeUpdateFlags FLAGS_WIDER_IGNORE_UNKNOWN = TypeUpdateFlags.build(5);
    private final int flags;

    @NotNull
    private static TypeUpdateFlags build(int flags) {
        return new TypeUpdateFlags(flags);
    }

    private TypeUpdateFlags(int flags) {
        this.flags = flags;
    }

    public boolean isAllowWider() {
        return (this.flags & 1) != 0;
    }

    public boolean isIgnoreSame() {
        return (this.flags & 2) != 0;
    }

    public boolean isIgnoreUnknown() {
        return (this.flags & 4) != 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isAllowWider()) {
            sb.append("ALLOW_WIDER");
        }
        if (this.isIgnoreSame()) {
            if (sb.length() != 0) {
                sb.append('|');
            }
            sb.append("IGNORE_SAME");
        }
        if (this.isIgnoreUnknown()) {
            if (sb.length() != 0) {
                sb.append('|');
            }
            sb.append("IGNORE_UNKNOWN");
        }
        return sb.toString();
    }
}

