/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import java.util.Set;
import org.jf.baksmali.Adaptors.AnnotationFormatter;
import org.jf.baksmali.formatter.BaksmaliWriter;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.HiddenApiRestriction;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.util.EncodedValueUtils;

public class FieldDefinition {
    public static void writeTo(BaksmaliWriter writer, Field field, boolean setInStaticConstructor) throws IOException {
        EncodedValue initialValue = field.getInitialValue();
        int accessFlags = field.getAccessFlags();
        if (setInStaticConstructor && AccessFlags.STATIC.isSet(accessFlags) && AccessFlags.FINAL.isSet(accessFlags) && initialValue != null) {
            if (!EncodedValueUtils.isDefaultValue((EncodedValue)initialValue)) {
                writer.write("# The value of this static final field might be set in the static constructor\n");
            } else {
                initialValue = null;
            }
        }
        writer.write(".field ");
        FieldDefinition.writeAccessFlagsAndRestrictions(writer, field.getAccessFlags(), field.getHiddenApiRestrictions());
        writer.writeSimpleName(field.getName());
        writer.write(58);
        writer.writeType(field.getType());
        if (initialValue != null) {
            writer.write(" = ");
            writer.writeEncodedValue(initialValue);
        }
        writer.write(10);
        Set annotations = field.getAnnotations();
        if (annotations.size() > 0) {
            writer.indent(4);
            AnnotationFormatter.writeTo(writer, annotations);
            writer.deindent(4);
            writer.write(".end field\n");
        }
    }

    private static void writeAccessFlagsAndRestrictions(BaksmaliWriter writer, int accessFlags, Set<HiddenApiRestriction> hiddenApiRestrictions) throws IOException {
        for (AccessFlags accessFlag : AccessFlags.getAccessFlagsForField((int)accessFlags)) {
            writer.write(accessFlag.toString());
            writer.write(32);
        }
        for (HiddenApiRestriction hiddenApiRestriction : hiddenApiRestrictions) {
            writer.write(hiddenApiRestriction.toString());
            writer.write(32);
        }
    }
}

