/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.HashSet;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

public class AlarmEventHandler
extends BaseEventHandler {
    private final CacheManager cacheManager;
    private final boolean ignoreDuplicates;

    @Inject
    public AlarmEventHandler(Config config, CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.ignoreDuplicates = config.getBoolean(Keys.EVENT_IGNORE_DUPLICATE_ALERTS);
    }

    @Override
    public void onPosition(Position position, BaseEventHandler.Callback callback) {
        String alarmString = position.getString("alarm");
        if (alarmString != null) {
            String lastAlarmString;
            Position lastPosition;
            HashSet<String> alarms = new HashSet<String>(Arrays.asList(alarmString.split(",")));
            if (this.ignoreDuplicates && (lastPosition = this.cacheManager.getPosition(position.getDeviceId())) != null && (lastAlarmString = lastPosition.getString("alarm")) != null) {
                HashSet<String> lastAlarms = new HashSet<String>(Arrays.asList(lastAlarmString.split(",")));
                alarms.removeAll(lastAlarms);
            }
            for (String alarm : alarms) {
                Event event = new Event("alarm", position);
                event.set("alarm", alarm);
                callback.eventDetected(event);
            }
        }
    }
}

