/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.control.FreeColServerHolder;

public final class AIInGameInputHandler
extends FreeColServerHolder
implements MessageHandler {
    private static final Logger logger = Logger.getLogger(AIInGameInputHandler.class.getName());
    private final Player player;
    private final AIMain aiMain;

    public AIInGameInputHandler(FreeColServer freeColServer, Player player, AIMain aiMain) {
        super(freeColServer);
        if (player == null) {
            throw new NullPointerException("serverPlayer == null: " + this);
        }
        if (!player.isAI()) {
            throw new RuntimeException("Applying AIInGameInputHandler to a non-AI player: " + player);
        }
        if (aiMain == null) {
            throw new NullPointerException("aiMain == null: " + this);
        }
        this.player = player;
        this.aiMain = aiMain;
    }

    private AIPlayer getMyAIPlayer() {
        return this.aiMain.getAIPlayer(this.player);
    }

    @Override
    public Message handle(Connection connection, Message message) throws FreeColException {
        message.aiHandler(this.getFreeColServer(), this.getMyAIPlayer());
        return null;
    }

    @Override
    public Message read(Connection connection) throws FreeColException, XMLStreamException {
        return Message.read(this.getGame(), connection.getFreeColXMLReader());
    }
}

