/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.editor.completion;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterCodeWrapper;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterConnectionSettingsUtilKt;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterKernelClient;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterExecutionState;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.connections.server.JupyterServer;
import com.intellij.jupyter.core.jupyter.connections.server.JupyterServerUtils;
import com.intellij.jupyter.py.variables.PythonJupyterVarsCommandExecutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PlatformIcons;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.codeInsight.completion.RemoteFilePathRetrievalService;
import com.jetbrains.python.codeInsight.completion.RuntimeLookupElement;
import com.jetbrains.python.psi.PyStringElement;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J,\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\tH\u0002J \u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006 "}, d2={"Lcom/intellij/jupyter/py/editor/completion/JupyterRemoteFilePathRetrievalService;", "Lcom/jetbrains/python/codeInsight/completion/RemoteFilePathRetrievalService;", "<init>", "()V", "extractPossibleParentPath", "Lkotlin/Pair;", "", "content", "isKernelReady", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFilesFromRemoteServer", "", "notebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "possibleRoot", "getIcon", "Ljavax/swing/Icon;", "completion", "isFile", "canComplete", "originalFile", "Lcom/intellij/psi/PsiFile;", "getContent", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "retrieveRemoteFileLookupElements", "Lcom/jetbrains/python/codeInsight/completion/RuntimeLookupElement;", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterRemoteFilePathRetrievalService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRemoteFilePathRetrievalService.kt\ncom/intellij/jupyter/py/editor/completion/JupyterRemoteFilePathRetrievalService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1#2:124\n24#3:125\n463#4:126\n413#4:127\n1252#5,4:128\n*S KotlinDebug\n*F\n+ 1 JupyterRemoteFilePathRetrievalService.kt\ncom/intellij/jupyter/py/editor/completion/JupyterRemoteFilePathRetrievalService\n*L\n82#1:125\n118#1:126\n118#1:127\n118#1:128,4\n*E\n"})
public final class JupyterRemoteFilePathRetrievalService
implements RemoteFilePathRetrievalService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final char SEPARATOR = '/';

    private final Pair<String, String> extractPossibleParentPath(String content) {
        String string = FileUtil.normalize((String)content);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalize(...)");
        String independentPath = string;
        int index = StringsKt.lastIndexOf$default((CharSequence)independentPath, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            return new Pair((Object)"", (Object)content);
        }
        return new Pair((Object)StringsKt.substring((String)independentPath, (IntRange)new IntRange(0, index)), (Object)StringsKt.substring((String)independentPath, (IntRange)RangesKt.until((int)(index + 1), (int)independentPath.length())));
    }

    private final boolean isKernelReady(Project project, VirtualFile virtualFile) {
        JupyterKernelClient jupyterKernelClient;
        JupyterNotebookSession jupyterNotebookSession = JupyterRuntimeService.Companion.getInstance(project).getSession(virtualFile);
        return (jupyterNotebookSession != null && (jupyterKernelClient = jupyterNotebookSession.getKernelClient()) != null ? jupyterKernelClient.getExecutionState() : null) == JupyterExecutionState.IDLE;
    }

    private final Map<String, Boolean> getFilesFromRemoteServer(Project project, BackedNotebookVirtualFile notebookVirtualFile, String possibleRoot) {
        CharSequence charSequence;
        CharSequence charSequence2 = possibleRoot;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = "./";
        } else {
            charSequence = charSequence2;
        }
        String rootDirectory = (String)charSequence;
        if (JupyterRuntimeService.Companion.getInstance(project).getNotebookSession(notebookVirtualFile) == null) {
            return MapsKt.emptyMap();
        }
        if (!this.isKernelReady(project, notebookVirtualFile.getFile())) {
            return MapsKt.emptyMap();
        }
        String pythonCommand = JupyterRemoteFilePathRetrievalService.Companion.makeCommandForExtractingPathNames(rootDirectory);
        String data = PythonJupyterVarsCommandExecutor.executeCommand$default(PythonJupyterVarsCommandExecutor.Companion.getInstance(project), pythonCommand, notebookVirtualFile, null, 4, null);
        try {
            TypeReference typeRef2 = (TypeReference)new TypeReference<Map<String, ? extends Map<String, ? extends Boolean>>>(){};
            Map result2 = (Map)JupyterJsonKt.getJackson().readValue(data, typeRef2);
            Map map = (Map)result2.get("files");
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            return map;
        }
        catch (JsonProcessingException err) {
            JupyterRemoteFilePathRetrievalService $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterRemoteFilePathRetrievalService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Remote path completion: incorrect python script call for " + possibleRoot + " (with error " + data + "): " + err.getMessage());
            return MapsKt.emptyMap();
        }
    }

    private final Icon getIcon(String completion, boolean isFile) {
        if (isFile) {
            Icon icon = FileTypeManager.getInstance().getFileTypeByExtension(StringsKt.substringAfterLast((String)completion, (String)".", (String)"")).getIcon();
            if (icon == null) {
                Icon icon2 = AllIcons.FileTypes.Unknown;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Unknown");
            }
            return icon;
        }
        Icon icon = PlatformIcons.FOLDER_ICON;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"FOLDER_ICON");
        return icon;
    }

    private final boolean canComplete(Project project, PsiFile originalFile, BackedNotebookVirtualFile notebookVirtualFile) {
        JupyterServer jupyterServer = JupyterServerUtils.INSTANCE.getJupyterServer(project, notebookVirtualFile.getFile());
        if (jupyterServer == null) {
            return false;
        }
        JupyterServer jupyterServer2 = jupyterServer;
        if (JupyterConnectionSettingsUtilKt.isLocal((JupyterConnectionParameters)jupyterServer2.getConnectionParameters())) {
            return false;
        }
        return !PythonRuntimeService.getInstance().isInPydevConsole((PsiElement)originalFile);
    }

    private final String getContent(CompletionParameters parameters) {
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement currentElement = psiElement;
        if (!(currentElement instanceof PyStringElement)) {
            return null;
        }
        String string = ((PyStringElement)currentElement).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = ((PyStringElement)currentElement).getContentRange().getStartOffset();
        int n2 = parameters.getOffset() - ((PyStringElement)currentElement).getTextRange().getStartOffset();
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, RuntimeLookupElement> retrieveRemoteFileLookupElements(@NotNull CompletionParameters parameters) {
        void $this$mapValuesTo$iv$iv;
        VirtualFile virtualFile;
        PsiFile originalFile;
        Project project;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                Project project2 = parameters.getEditor().getProject();
                if (project2 == null) {
                    return MapsKt.emptyMap();
                }
                project = project2;
                PsiFile psiFile2 = parameters.getOriginalFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getOriginalFile(...)");
                originalFile = psiFile2;
                virtualFile = originalFile.getVirtualFile();
                if (virtualFile == null) break block7;
                VirtualFile virtualFile2 = virtualFile;
                BackedNotebookVirtualFile.Companion companion = BackedNotebookVirtualFile.Companion;
                VirtualFile p0 = virtualFile2;
                boolean bl = false;
                BackedNotebookVirtualFile backedNotebookVirtualFile = companion.takeIfBacked(p0);
                virtualFile = backedNotebookVirtualFile;
                if (backedNotebookVirtualFile != null) break block8;
            }
            return MapsKt.emptyMap();
        }
        VirtualFile notebookVirtualFile = virtualFile;
        if (!this.canComplete(project, originalFile, (BackedNotebookVirtualFile)notebookVirtualFile)) {
            return MapsKt.emptyMap();
        }
        String string = this.getContent(parameters);
        if (string == null) {
            return MapsKt.emptyMap();
        }
        String content = string;
        Pair<String, String> pair = this.extractPossibleParentPath(content);
        String parentPath = (String)pair.component1();
        String prefix = (String)pair.component2();
        Map<String, Boolean> $this$mapValues$iv = this.getFilesFromRemoteServer(project, (BackedNotebookVirtualFile)notebookVirtualFile, parentPath);
        boolean $i$f$mapValues = false;
        Map<String, Boolean> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            String completion = (String)entry2.getKey();
            boolean isFile = (Boolean)entry2.getValue();
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)completion).withTypeText("Remote path").withIcon(this.getIcon(completion, isFile));
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withIcon(...)");
            RuntimeLookupElement runtimeLookupElement = new RuntimeLookupElement((LookupElement)lookupElementBuilder, (PrefixMatcher)new PlainPrefixMatcher(prefix));
            map3.put(k, runtimeLookupElement);
        }
        return destination$iv$iv;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/jupyter/py/editor/completion/JupyterRemoteFilePathRetrievalService$Companion;", "", "<init>", "()V", "SEPARATOR", "", "makeCommandForExtractingPathNames", "", "rootDirectory", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        private final String makeCommandForExtractingPathNames(String rootDirectory) {
            return "\ntry:\n    print(__import__('json').dumps({\"files\": {f: __import__('os.path').path.isfile(f) for f in __import__('os').listdir(" + JupyterCodeWrapper.INSTANCE.wrapString(rootDirectory) + ")}}))\nexcept Exception as e:\n    __import__('traceback').print_exc(file=__import__('sys').stdout)\n";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

