/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec4(165l, 133l, 193l, 76l) << u64vec4(2ul, 5ul, 45ul, 63ul)) => i64vec4(660l, 4256l, 6790583813144576l, 0l)
 * (i64vec4(165l, 133l, 193l, 76l) << u64vec4(34ul, 4ul, 24ul, 62ul)) => i64vec4(2834678415360l, 2128l, 3238002688l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) << u64vec4(2ul, 5ul, 45ul, 63ul)) => i64vec4(320l, -480l, -1794402976530432l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) << u64vec4(34ul, 4ul, 24ul, 62ul)) => i64vec4(1374389534720l, -240l, -855638016l, 0l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) << u64vec4(2ul, 5ul, 45ul, 63ul)), i64vec4(660l, 4256l, 6790583813144576l, 0l))) ? 1 : -1] array0;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) << u64vec4(34ul, 4ul, 24ul, 62ul)), i64vec4(2834678415360l, 2128l, 3238002688l, 0l))) ? 1 : -1] array1;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) << u64vec4(2ul, 5ul, 45ul, 63ul)), i64vec4(320l, -480l, -1794402976530432l, 0l))) ? 1 : -1] array2;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) << u64vec4(34ul, 4ul, 24ul, 62ul)), i64vec4(1374389534720l, -240l, -855638016l, 0l))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
