/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec3(-1333333333333333259l, 85l, 94l) << uvec3(22u, 23u, 4u)) => i64vec3(1833772823194107904l, 713031680l, 1504l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) << uvec3(19u, 1u, 13u)) => i64vec3(7146750630540345344l, 170l, 770048l)
 * (i64vec3(167l, 66l, 187l) << uvec3(22u, 23u, 4u)) => i64vec3(700448768l, 553648128l, 2992l)
 * (i64vec3(167l, 66l, 187l) << uvec3(19u, 1u, 13u)) => i64vec3(87556096l, 132l, 1531904l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) << uvec3(22u, 23u, 4u)), i64vec3(1833772823194107904l, 713031680l, 1504l))) ? 1 : -1] array0;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) << uvec3(19u, 1u, 13u)), i64vec3(7146750630540345344l, 170l, 770048l))) ? 1 : -1] array1;
  float[all(equal((i64vec3(167l, 66l, 187l) << uvec3(22u, 23u, 4u)), i64vec3(700448768l, 553648128l, 2992l))) ? 1 : -1] array2;
  float[all(equal((i64vec3(167l, 66l, 187l) << uvec3(19u, 1u, 13u)), i64vec3(87556096l, 132l, 1531904l))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
