/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URI;
import java.text.ParseException;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.matcher.GlobPatternMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.file.FileRepository;
import org.apache.ivy.plugins.resolver.ChainResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.FileSystemResolver;
import org.apache.ivy.plugins.resolver.IBiblioResolver;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkSubmit$;
import org.apache.spark.deploy.SparkSubmitOperation;
import org.apache.spark.deploy.SparkSubmitUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SparkSubmitUtils$
implements Logging {
    public static final SparkSubmitUtils$ MODULE$ = new SparkSubmitUtils$();
    private static PrintStream printStream;
    private static final Seq<String> IVY_DEFAULT_EXCLUDES;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        printStream = SparkSubmit$.MODULE$.printStream();
        IVY_DEFAULT_EXCLUDES = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"catalyst_", "core_", "graphx_", "kvstore_", "launcher_", "mllib_", "mllib-local_", "network-common_", "network-shuffle_", "repl_", "sketch_", "sql_", "streaming_", "tags_", "unsafe_"}));
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public PrintStream printStream() {
        return printStream;
    }

    public void printStream_$eq(PrintStream x$1) {
        printStream = x$1;
    }

    public Seq<String> IVY_DEFAULT_EXCLUDES() {
        return IVY_DEFAULT_EXCLUDES;
    }

    public Seq<SparkSubmitUtils.MavenCoordinate> extractMavenCoordinates(String coordinates) {
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])coordinates.split(",")), (Function1 & Serializable)p -> {
            String[] splits = p.replace("/", ":").split(":");
            Predef$.MODULE$.require(splits.length == 3, (Function0 & Serializable)() -> new StringBuilder(0).append("Provided Maven Coordinates must be in the form ").append(new StringBuilder(58).append("'groupId:artifactId:version'. The coordinate provided is: ").append((String)p).toString()).toString());
            Predef$.MODULE$.require(splits[0] != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(splits[0].trim())), (Function0 & Serializable)() -> new StringBuilder(0).append("The groupId cannot be null or ").append(new StringBuilder(40).append("be whitespace. The groupId provided is: ").append(splits[0]).toString()).toString());
            Predef$.MODULE$.require(splits[1] != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(splits[1].trim())), (Function0 & Serializable)() -> new StringBuilder(0).append("The artifactId cannot be null or ").append(new StringBuilder(43).append("be whitespace. The artifactId provided is: ").append(splits[1]).toString()).toString());
            Predef$.MODULE$.require(splits[2] != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(splits[2].trim())), (Function0 & Serializable)() -> new StringBuilder(0).append("The version cannot be null or ").append(new StringBuilder(40).append("be whitespace. The version provided is: ").append(splits[2]).toString()).toString());
            return new SparkSubmitUtils.MavenCoordinate(splits[0], splits[1], splits[2]);
        }, ClassTag$.MODULE$.apply(SparkSubmitUtils.MavenCoordinate.class)));
    }

    public File m2Path() {
        return Utils$.MODULE$.isTesting() ? new File("dummy", new StringBuilder(13).append(".m2").append(File.separator).append("repository").toString()) : new File(System.getProperty("user.home"), new StringBuilder(13).append(".m2").append(File.separator).append("repository").toString());
    }

    /*
     * WARNING - void declaration
     */
    public ChainResolver createRepoResolvers(File defaultIvyUserDir, boolean useLocalM2AsCache) {
        void var3_3;
        ChainResolver cr = new ChainResolver();
        cr.setName("spark-list");
        if (useLocalM2AsCache) {
            IBiblioResolver localM2 = new IBiblioResolver();
            localM2.setM2compatible(true);
            localM2.setRoot(this.m2Path().toURI().toString());
            localM2.setUsepoms(true);
            localM2.setName("local-m2-cache");
            cr.add((DependencyResolver)localM2);
        }
        FileSystemResolver localIvy = new FileSystemResolver();
        File localIvyRoot = new File(defaultIvyUserDir, "local");
        localIvy.setLocal(true);
        localIvy.setRepository((Repository)new FileRepository(localIvyRoot));
        String ivyPattern = package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{localIvyRoot.getAbsolutePath(), "[organisation]", "[module]", "[revision]", "ivys", "ivy.xml"})).mkString(File.separator);
        localIvy.addIvyPattern(ivyPattern);
        String artifactPattern = package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{localIvyRoot.getAbsolutePath(), "[organisation]", "[module]", "[revision]", "[type]s", "[artifact](-[classifier]).[ext]"})).mkString(File.separator);
        localIvy.addArtifactPattern(artifactPattern);
        localIvy.setName("local-ivy-cache");
        cr.add((DependencyResolver)localIvy);
        IBiblioResolver br = new IBiblioResolver();
        br.setM2compatible(true);
        br.setUsepoms(true);
        Option defaultInternalRepo = scala.sys.package$.MODULE$.env().get((Object)"DEFAULT_ARTIFACT_REPOSITORY");
        br.setRoot((String)defaultInternalRepo.getOrElse((Function0 & Serializable)() -> "https://repo1.maven.org/maven2/"));
        br.setName("central");
        cr.add((DependencyResolver)br);
        IBiblioResolver sp2 = new IBiblioResolver();
        sp2.setM2compatible(true);
        sp2.setUsepoms(true);
        sp2.setRoot((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"DEFAULT_ARTIFACT_REPOSITORY", (Function0 & Serializable)() -> "https://repos.spark-packages.org/"));
        sp2.setName("spark-packages");
        cr.add((DependencyResolver)sp2);
        return var3_3;
    }

    public boolean createRepoResolvers$default$2() {
        return true;
    }

    public Seq<String> resolveDependencyPaths(Object[] artifacts, File cacheDirectory) {
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(artifacts), (Function1 & Serializable)x$25 -> (Artifact)x$25, ClassTag$.MODULE$.apply(Artifact.class))), (Function1 & Serializable)artifactInfo -> BoxesRunTime.boxToBoolean((boolean)SparkSubmitUtils$.$anonfun$resolveDependencyPaths$2(artifactInfo)))), (Function1 & Serializable)artifactInfo -> {
            ModuleRevisionId artifact = artifactInfo.getModuleRevisionId();
            Map extraAttrs = artifactInfo.getExtraAttributes();
            String classifier = extraAttrs.containsKey("classifier") ? new StringBuilder(1).append("-").append(extraAttrs.get("classifier")).toString() : "";
            return new StringBuilder(0).append(cacheDirectory.getAbsolutePath()).append(File.separator).append(new StringBuilder(6).append(artifact.getOrganisation()).append("_").append(artifact.getName()).append("-").append(artifact.getRevision()).append(classifier).append(".jar").toString()).toString();
        }, ClassTag$.MODULE$.apply(String.class)));
    }

    public void addDependenciesToIvy(DefaultModuleDescriptor md, Seq<SparkSubmitUtils.MavenCoordinate> artifacts, String ivyConfName) {
        artifacts.foreach((Function1 & Serializable)mvn -> {
            SparkSubmitUtils$.$anonfun$addDependenciesToIvy$1(ivyConfName, md, mvn);
            return BoxedUnit.UNIT;
        });
    }

    public void addExclusionRules(IvySettings ivySettings, String ivyConfName, DefaultModuleDescriptor md) {
        md.addExcludeRule(this.createExclusion("*:scala-library:*", ivySettings, ivyConfName));
        this.IVY_DEFAULT_EXCLUDES().foreach((Function1 & Serializable)comp -> {
            md.addExcludeRule(SparkSubmitUtils$.MODULE$.createExclusion(new StringBuilder(26).append("org.apache.spark:spark-").append(comp).append("*:*").toString(), ivySettings, ivyConfName));
            return BoxedUnit.UNIT;
        });
    }

    public IvySettings buildIvySettings(Option<String> remoteRepos, Option<String> ivyPath, boolean useLocalM2AsCache) {
        IvySettings ivySettings = new IvySettings();
        this.processIvyPathArg(ivySettings, ivyPath);
        ivySettings.addMatcher((PatternMatcher)new GlobPatternMatcher());
        ChainResolver repoResolver = this.createRepoResolvers(ivySettings.getDefaultIvyUserDir(), useLocalM2AsCache);
        ivySettings.addResolver((DependencyResolver)repoResolver);
        ivySettings.setDefaultResolver(repoResolver.getName());
        this.processRemoteRepoArg(ivySettings, remoteRepos);
        ivySettings.setVariable("ivy.maven.lookup.sources", "false");
        ivySettings.setVariable("ivy.maven.lookup.javadoc", "false");
        return ivySettings;
    }

    public boolean buildIvySettings$default$3() {
        return true;
    }

    public IvySettings loadIvySettings(String settingsFile, Option<String> remoteRepos, Option<String> ivyPath) {
        File file;
        block6: {
            URI uri = new URI(settingsFile);
            String string = (String)Option$.MODULE$.apply((Object)uri.getScheme()).getOrElse((Function0 & Serializable)() -> "file");
            switch (string == null ? 0 : string.hashCode()) {
                case 3143036: {
                    if (!"file".equals(string)) break;
                    file = new File(uri.getPath());
                    break block6;
                }
            }
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(25).append("Scheme ").append(string).append(" not supported in ").toString()).append(org.apache.spark.internal.config.package$.MODULE$.JAR_IVY_SETTING_PATH().key()).toString());
        }
        File file2 = file;
        Predef$.MODULE$.require(file2.exists(), (Function0 & Serializable)() -> new StringBuilder(33).append("Ivy settings file ").append(file2).append(" does not exist").toString());
        Predef$.MODULE$.require(file2.isFile(), (Function0 & Serializable)() -> new StringBuilder(39).append("Ivy settings file ").append(file2).append(" is not a normal file").toString());
        IvySettings ivySettings = new IvySettings();
        try {
            ivySettings.load(file2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IOException ? true : throwable2 instanceof ParseException;
            if (bl) {
                throw new SparkException(new StringBuilder(38).append("Failed when loading Ivy settings from ").append(settingsFile).toString(), throwable2);
            }
            throw throwable;
        }
        this.processIvyPathArg(ivySettings, ivyPath);
        this.processRemoteRepoArg(ivySettings, remoteRepos);
        return ivySettings;
    }

    private void processIvyPathArg(IvySettings ivySettings, Option<String> ivyPath) {
        ivyPath.filterNot((Function1 & Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)SparkSubmitUtils$.$anonfun$processIvyPathArg$1(x$26))).foreach((Function1 & Serializable)alternateIvyDir -> {
            SparkSubmitUtils$.$anonfun$processIvyPathArg$2(ivySettings, alternateIvyDir);
            return BoxedUnit.UNIT;
        });
    }

    private void processRemoteRepoArg(IvySettings ivySettings, Option<String> remoteRepos) {
        remoteRepos.filterNot((Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)SparkSubmitUtils$.$anonfun$processRemoteRepoArg$1(x$27))).map((Function1 & Serializable)x$28 -> x$28.split(",")).foreach((Function1 & Serializable)repositoryList -> {
            SparkSubmitUtils$.$anonfun$processRemoteRepoArg$3(ivySettings, repositoryList);
            return BoxedUnit.UNIT;
        });
    }

    public DefaultModuleDescriptor getModuleDescriptor() {
        return DefaultModuleDescriptor.newDefaultInstance((ModuleRevisionId)ModuleRevisionId.newInstance((String)"org.apache.spark", (String)new StringBuilder(20).append("spark-submit-parent-").append(UUID.randomUUID().toString()).toString(), (String)"1.0"));
    }

    private void clearIvyResolutionFiles(ModuleRevisionId mdId, File defaultCacheFile, String ivyConfName) {
        Seq currentResolutionFiles = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(6).append(mdId.getOrganisation()).append("-").append(mdId.getName()).append("-").append(ivyConfName).append(".xml").toString(), new StringBuilder(15).append("resolved-").append(mdId.getOrganisation()).append("-").append(mdId.getName()).append("-").append(mdId.getRevision()).append(".xml").toString(), new StringBuilder(22).append("resolved-").append(mdId.getOrganisation()).append("-").append(mdId.getName()).append("-").append(mdId.getRevision()).append(".properties").toString()}));
        currentResolutionFiles.foreach((Function1 & Serializable)filename -> BoxesRunTime.boxToBoolean((boolean)SparkSubmitUtils$.$anonfun$clearIvyResolutionFiles$1(defaultCacheFile, filename)));
    }

    private void clearInvalidIvyCacheFiles(ModuleRevisionId mdId, File defaultCacheFile) {
        Seq cacheFiles = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(0).append(new StringBuilder(0).append(mdId.getOrganisation()).append(File.separator).append(mdId.getName()).append(File.separator).toString()).append(new StringBuilder(8).append("ivy-").append(mdId.getRevision()).append(".xml").toString()).toString(), new StringBuilder(0).append(new StringBuilder(0).append(mdId.getOrganisation()).append(File.separator).append(mdId.getName()).append(File.separator).toString()).append(new StringBuilder(17).append("ivy-").append(mdId.getRevision()).append(".xml.original").toString()).toString(), new StringBuilder(0).append(new StringBuilder(0).append(mdId.getOrganisation()).append(File.separator).append(mdId.getName()).append(File.separator).toString()).append(new StringBuilder(19).append("ivydata-").append(mdId.getRevision()).append(".properties").toString()).toString()}));
        cacheFiles.foreach((Function1 & Serializable)filename -> BoxesRunTime.boxToBoolean((boolean)SparkSubmitUtils$.$anonfun$clearInvalidIvyCacheFiles$1(defaultCacheFile, filename)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<String> resolveMavenCoordinates(String coordinates, IvySettings ivySettings, Option<IvySettings> noCacheIvySettings, boolean transitive, Seq<String> exclusions, boolean isTest) {
        Seq<String> seq;
        if (coordinates == null || coordinates.trim().isEmpty()) {
            seq = package$.MODULE$.Nil();
            return seq;
        }
        PrintStream sysOut = System.out;
        String ivyConfName = "default";
        DefaultModuleDescriptor md = this.getModuleDescriptor();
        md.setDefaultConf(ivyConfName);
        try {
            ResolveOptions resolveOptions;
            System.setOut(this.printStream());
            Seq<SparkSubmitUtils.MavenCoordinate> artifacts = this.extractMavenCoordinates(coordinates);
            File packagesDirectory = new File(ivySettings.getDefaultIvyUserDir(), "jars");
            this.printStream().println(new StringBuilder(26).append("Ivy Default Cache set to: ").append(ivySettings.getDefaultCache().getAbsolutePath()).toString());
            this.printStream().println(new StringBuilder(37).append("The jars for the packages stored in: ").append(packagesDirectory).toString());
            Ivy ivy = Ivy.newInstance((IvySettings)ivySettings);
            ivy.pushContext();
            ResolveOptions resolveOptions2 = new ResolveOptions();
            resolveOptions2.setTransitive(transitive);
            RetrieveOptions retrieveOptions = new RetrieveOptions();
            if (isTest) {
                resolveOptions2.setDownload(false);
                resolveOptions2.setLog("quiet");
                resolveOptions = retrieveOptions.setLog("quiet");
            } else {
                resolveOptions = resolveOptions2.setDownload(true);
            }
            retrieveOptions.setDestArtifactPattern(new StringBuilder(57).append(packagesDirectory.getAbsolutePath()).append(File.separator).append("[organization]_[artifact]-[revision](-[classifier]).[ext]").toString());
            retrieveOptions.setConfs((String[])((Object[])new String[]{ivyConfName}));
            this.addExclusionRules(ivySettings, ivyConfName, md);
            this.addDependenciesToIvy(md, artifacts, ivyConfName);
            exclusions.foreach((Function1 & Serializable)e -> {
                md.addExcludeRule(SparkSubmitUtils$.MODULE$.createExclusion(new StringBuilder(2).append(e).append(":*").toString(), ivySettings, ivyConfName));
                return BoxedUnit.UNIT;
            });
            ResolveReport rr = ivy.resolve((ModuleDescriptor)md, resolveOptions2);
            if (rr.hasError()) {
                ArtifactDownloadReport[] failedReports = rr.getArtifactsReports(DownloadStatus.FAILED, true);
                if (!ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])failedReports)) || !noCacheIvySettings.isDefined()) throw new RuntimeException(rr.getAllProblemMessages().toString());
                Artifact[] failedArtifacts = (Artifact[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])failedReports), (Function1 & Serializable)r -> r.getArtifact(), ClassTag$.MODULE$.apply(Artifact.class));
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(19).append("Download failed: ").append(Predef$.MODULE$.wrapRefArray((Object[])failedArtifacts).mkString("[", ", ", "]")).append(", ").toString()).append("attempt to retry while skipping local-m2-cache.").toString());
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])failedArtifacts), (Function1 & Serializable)artifact -> {
                    SparkSubmitUtils$.MODULE$.clearInvalidIvyCacheFiles(artifact.getModuleRevisionId(), ivySettings.getDefaultCache());
                    return BoxedUnit.UNIT;
                });
                ivy.popContext();
                Ivy noCacheIvy = Ivy.newInstance((IvySettings)((IvySettings)noCacheIvySettings.get()));
                noCacheIvy.pushContext();
                ResolveReport noCacheRr = noCacheIvy.resolve((ModuleDescriptor)md, resolveOptions2);
                if (noCacheRr.hasError()) {
                    throw new RuntimeException(noCacheRr.getAllProblemMessages().toString());
                }
                noCacheIvy.retrieve(noCacheRr.getModuleDescriptor().getModuleRevisionId(), retrieveOptions);
                Seq<String> dependencyPaths = this.resolveDependencyPaths(noCacheRr.getArtifacts().toArray(), packagesDirectory);
                noCacheIvy.popContext();
                seq = dependencyPaths;
                return seq;
            } else {
                ivy.retrieve(rr.getModuleDescriptor().getModuleRevisionId(), retrieveOptions);
                Seq<String> dependencyPaths = this.resolveDependencyPaths(rr.getArtifacts().toArray(), packagesDirectory);
                ivy.popContext();
                seq = dependencyPaths;
            }
            return seq;
        }
        finally {
            System.setOut(sysOut);
            this.clearIvyResolutionFiles(md.getModuleRevisionId(), ivySettings.getDefaultCache(), ivyConfName);
        }
    }

    public Option<IvySettings> resolveMavenCoordinates$default$3() {
        return None$.MODULE$;
    }

    public Seq<String> resolveMavenCoordinates$default$5() {
        return package$.MODULE$.Nil();
    }

    public boolean resolveMavenCoordinates$default$6() {
        return false;
    }

    public ExcludeRule createExclusion(String coords, IvySettings ivySettings, String ivyConfName) {
        SparkSubmitUtils.MavenCoordinate c = (SparkSubmitUtils.MavenCoordinate)this.extractMavenCoordinates(coords).apply(0);
        ArtifactId id = new ArtifactId(new ModuleId(c.groupId(), c.artifactId()), "*", "*", "*");
        DefaultExcludeRule rule = new DefaultExcludeRule(id, ivySettings.getMatcher("glob"), null);
        rule.addConfiguration(ivyConfName);
        return rule;
    }

    public Tuple2<String, String> parseSparkConfProperty(String pair) {
        SeqOps seqOps;
        Seq seq = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])pair.split("=", 2)));
        if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) {
            throw new SparkException(new StringBuilder(26).append("Spark config without '=': ").append(pair).toString());
        }
        String k = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        String v = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
        Tuple2 tuple2 = new Tuple2((Object)k, (Object)v);
        return tuple2;
    }

    public SparkSubmitOperation getSubmitOperations(String master) {
        ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
        Iterable serviceLoaders = (Iterable)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ServiceLoader.load(SparkSubmitOperation.class, loader)).asScala()).filter((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)x$29.supports(master)));
        int n = serviceLoaders.size();
        if (n > 1) {
            throw new SparkException(new StringBuilder(0).append(new StringBuilder(42).append("Multiple(").append(n).append(") external SparkSubmitOperations ").toString()).append(new StringBuilder(35).append("clients registered for master url ").append(master).append(".").toString()).toString());
        }
        if (1 != n) {
            throw new IllegalArgumentException(new StringBuilder(0).append("No external SparkSubmitOperations ").append(new StringBuilder(32).append("clients found for master url: '").append(master).append("'").toString()).toString());
        }
        SparkSubmitOperation sparkSubmitOperation = (SparkSubmitOperation)serviceLoaders.headOption().get();
        return sparkSubmitOperation;
    }

    public static final /* synthetic */ boolean $anonfun$resolveDependencyPaths$2(Artifact artifactInfo) {
        boolean bl;
        String string = artifactInfo.getExt();
        String string2 = "jar";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            bl = true;
        } else {
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Skipping non-jar dependency ").append(artifactInfo.getId()).toString());
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$addDependenciesToIvy$1(String ivyConfName$1, DefaultModuleDescriptor md$1, SparkSubmitUtils.MavenCoordinate mvn) {
        ModuleRevisionId ri = ModuleRevisionId.newInstance((String)mvn.groupId(), (String)mvn.artifactId(), (String)mvn.version());
        DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(ri, false, false);
        dd.addDependencyConfiguration(ivyConfName$1, new StringBuilder(9).append(ivyConfName$1).append("(runtime)").toString());
        MODULE$.printStream().println(new StringBuilder(22).append(dd.getDependencyId()).append(" added as a dependency").toString());
        md$1.addDependency((DependencyDescriptor)dd);
    }

    public static final /* synthetic */ boolean $anonfun$processIvyPathArg$1(String x$26) {
        return x$26.trim().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$processIvyPathArg$2(IvySettings ivySettings$2, String alternateIvyDir) {
        ivySettings$2.setDefaultIvyUserDir(new File(alternateIvyDir));
        ivySettings$2.setDefaultCache(new File(alternateIvyDir, "cache"));
    }

    public static final /* synthetic */ boolean $anonfun$processRemoteRepoArg$1(String x$27) {
        return x$27.trim().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$processRemoteRepoArg$5(ChainResolver cr$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String repo = (String)tuple2._1();
        int i = tuple2._2$mcI$sp();
        IBiblioResolver brr = new IBiblioResolver();
        brr.setM2compatible(true);
        brr.setUsepoms(true);
        brr.setRoot(repo);
        brr.setName(new StringBuilder(5).append("repo-").append(i + 1).toString());
        cr$1.add((DependencyResolver)brr);
        MODULE$.printStream().println(new StringBuilder(45).append(repo).append(" added as a remote repository with the name: ").append(brr.getName()).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$processRemoteRepoArg$3(IvySettings ivySettings$3, String[] repositoryList) {
        ChainResolver cr = new ChainResolver();
        cr.setName("user-list");
        Option$.MODULE$.apply((Object)ivySettings$3.getDefaultResolver()).foreach((Function1 & Serializable)x$1 -> {
            cr.add(x$1);
            return BoxedUnit.UNIT;
        });
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])repositoryList))), (Function1 & Serializable)x0$1 -> {
            SparkSubmitUtils$.$anonfun$processRemoteRepoArg$5(cr, x0$1);
            return BoxedUnit.UNIT;
        });
        ivySettings$3.addResolver((DependencyResolver)cr);
        ivySettings$3.setDefaultResolver(cr.getName());
    }

    public static final /* synthetic */ boolean $anonfun$clearIvyResolutionFiles$1(File defaultCacheFile$1, String filename) {
        return new File(defaultCacheFile$1, filename).delete();
    }

    public static final /* synthetic */ boolean $anonfun$clearInvalidIvyCacheFiles$1(File defaultCacheFile$2, String filename) {
        return new File(defaultCacheFile$2, filename).delete();
    }

    private SparkSubmitUtils$() {
    }
}

